/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.Utilities;

final class InstanceBasedMatching {
    @Nonnull
    private final List<Class<?>> mockedTypesToMatchOnInstances = new LinkedList();

    InstanceBasedMatching() {
    }

    void discoverMockedTypesToMatchOnInstances(@Nonnull List<Class<?>> targetClasses) {
        int numClasses = targetClasses.size();
        if (numClasses > 1) {
            for (int i = 0; i < numClasses; ++i) {
                Class<?> targetClass = targetClasses.get(i);
                if (targetClasses.lastIndexOf(targetClass) <= i) continue;
                this.addMockedTypeToMatchOnInstance(targetClass);
            }
        }
    }

    private void addMockedTypeToMatchOnInstance(@Nonnull Class<?> mockedType) {
        if (!Utilities.containsReference(this.mockedTypesToMatchOnInstances, mockedType)) {
            this.mockedTypesToMatchOnInstances.add(mockedType);
        }
    }

    boolean isToBeMatchedOnInstance(@Nonnull Object mock) {
        Class<?> mockedClass = GeneratedClasses.getMockedClass(mock);
        return Utilities.containsReference(this.mockedTypesToMatchOnInstances, mockedClass);
    }
}

