/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.controlFlow.Label;
import mockit.asm.jvmConstants.JVMInstruction;
import mockit.asm.methods.MethodWriter;
import mockit.asm.methods.WrappingMethodVisitor;
import mockit.asm.types.JavaType;
import mockit.internal.expectations.transformation.ArgumentCapturing;
import mockit.internal.expectations.transformation.ArgumentMatching;
import mockit.internal.util.TypeConversionBytecode;

public final class InvocationBlockModifier
extends WrappingMethodVisitor {
    private static final String CLASS_DESC = "mockit/internal/expectations/ActiveInvocations";
    @Nonnull
    private final String blockOwner;
    @Nonnegative
    private int stackSize;
    @Nonnull
    final ArgumentMatching argumentMatching;
    @Nonnull
    final ArgumentCapturing argumentCapturing;
    private boolean justAfterWithCaptureInvocation;
    @Nonnegative
    private int lastLoadedVarIndex;

    InvocationBlockModifier(@Nonnull MethodWriter mw, @Nonnull String blockOwner) {
        super(mw);
        this.blockOwner = blockOwner;
        this.argumentMatching = new ArgumentMatching(this);
        this.argumentCapturing = new ArgumentCapturing(this);
    }

    void generateCallToActiveInvocationsMethod(@Nonnull String name) {
        this.mw.visitMethodInsn(184, CLASS_DESC, name, "()V", false);
    }

    void generateCallToActiveInvocationsMethod(@Nonnull String name, @Nonnull String desc) {
        this.visitMethodInstruction(184, CLASS_DESC, name, desc, false);
    }

    @Override
    public void visitFieldInsn(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        boolean getField;
        boolean bl = getField = opcode == 180;
        if ((getField || opcode == 181) && this.blockOwner.equals(owner) && name.indexOf(36) <= 0) {
            if (getField && ArgumentMatching.isAnyField(name)) {
                this.argumentMatching.generateCodeToAddArgumentMatcherForAnyField(owner, name, desc);
                this.argumentMatching.addMatcher(this.stackSize);
                return;
            }
            if (!getField && this.generateCodeThatReplacesAssignmentToSpecialField(name)) {
                this.visitInsn(87);
                return;
            }
        }
        this.stackSize += InvocationBlockModifier.stackSizeVariationForFieldAccess(opcode, desc);
        this.mw.visitFieldInsn(opcode, owner, name, desc);
    }

    private boolean generateCodeThatReplacesAssignmentToSpecialField(@Nonnull String fieldName) {
        if ("result".equals(fieldName)) {
            this.generateCallToActiveInvocationsMethod("addResult", "(Ljava/lang/Object;)V");
            return true;
        }
        if ("times".equals(fieldName) || "minTimes".equals(fieldName) || "maxTimes".equals(fieldName)) {
            this.generateCallToActiveInvocationsMethod(fieldName, "(I)V");
            return true;
        }
        return false;
    }

    private static int stackSizeVariationForFieldAccess(@Nonnegative int opcode, @Nonnull String fieldType) {
        char c = fieldType.charAt(0);
        boolean twoByteType = c == 'D' || c == 'J';
        switch (opcode) {
            case 178: {
                return twoByteType ? 2 : 1;
            }
            case 179: {
                return twoByteType ? -2 : -1;
            }
            case 180: {
                return twoByteType ? 1 : 0;
            }
            case 181: {
                return twoByteType ? -3 : -2;
            }
        }
        throw new IllegalArgumentException("Invalid field access opcode: " + opcode);
    }

    @Override
    public void visitMethodInsn(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
        if (opcode == 184 && (TypeConversionBytecode.isBoxing(owner, name, desc) || this.isAccessMethod(owner, name))) {
            this.visitMethodInstruction(184, owner, name, desc, itf);
        } else if (this.isCallToArgumentMatcher(opcode, owner, name, desc)) {
            this.visitMethodInstruction(182, owner, name, desc, itf);
            boolean withCaptureMethod = "withCapture".equals(name);
            if (this.argumentCapturing.registerMatcher(withCaptureMethod, desc, this.lastLoadedVarIndex)) {
                this.justAfterWithCaptureInvocation = withCaptureMethod;
                this.argumentMatching.addMatcher(this.stackSize);
            }
        } else if (TypeConversionBytecode.isUnboxing(opcode, owner, desc)) {
            if (this.justAfterWithCaptureInvocation) {
                this.generateCodeToReplaceNullWithZeroOnTopOfStack(desc);
                this.justAfterWithCaptureInvocation = false;
            } else {
                this.visitMethodInstruction(opcode, owner, name, desc, itf);
            }
        } else {
            this.handleMockedOrNonMockedInvocation(opcode, owner, name, desc, itf);
        }
    }

    private boolean isAccessMethod(@Nonnull String methodOwner, @Nonnull String name) {
        return !methodOwner.equals(this.blockOwner) && name.startsWith("access$");
    }

    private void visitMethodInstruction(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
        if (!"()V".equals(desc)) {
            int argAndRetSize = JavaType.getArgumentsAndReturnSizes(desc);
            int argSize = argAndRetSize >> 2;
            if (opcode == 184) {
                --argSize;
            }
            this.stackSize -= argSize;
            int retSize = argAndRetSize & 3;
            this.stackSize += retSize;
        } else if (opcode != 184) {
            --this.stackSize;
        }
        this.mw.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    private boolean isCallToArgumentMatcher(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        return opcode == 182 && owner.equals(this.blockOwner) && ArgumentMatching.isCallToArgumentMatcher(name, desc);
    }

    private void generateCodeToReplaceNullWithZeroOnTopOfStack(@Nonnull String unboxingMethodDesc) {
        int zeroOpcode;
        this.visitInsn(87);
        char primitiveTypeCode = unboxingMethodDesc.charAt(2);
        switch (primitiveTypeCode) {
            case 'J': {
                zeroOpcode = 9;
                break;
            }
            case 'F': {
                zeroOpcode = 11;
                break;
            }
            case 'D': {
                zeroOpcode = 14;
                break;
            }
            default: {
                zeroOpcode = 3;
            }
        }
        this.visitInsn(zeroOpcode);
    }

    private void handleMockedOrNonMockedInvocation(@Nonnegative int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
        if (this.argumentMatching.getMatcherCount() == 0) {
            this.visitMethodInstruction(opcode, owner, name, desc, itf);
        } else {
            boolean mockedInvocationUsingTheMatchers = this.argumentMatching.handleInvocationParameters(this.stackSize, desc);
            this.visitMethodInstruction(opcode, owner, name, desc, itf);
            this.handleArgumentCapturingIfNeeded(mockedInvocationUsingTheMatchers);
        }
    }

    private void handleArgumentCapturingIfNeeded(boolean mockedInvocationUsingTheMatchers) {
        if (mockedInvocationUsingTheMatchers) {
            this.argumentCapturing.generateCallsToCaptureMatchedArgumentsIfPending();
        }
        this.justAfterWithCaptureInvocation = false;
    }

    @Override
    public void visitLabel(@Nonnull Label label) {
        this.mw.visitLabel(label);
        if (!label.isDebug()) {
            this.stackSize = 0;
        }
    }

    @Override
    public void visitTypeInsn(@Nonnegative int opcode, @Nonnull String typeDesc) {
        this.argumentCapturing.registerTypeToCaptureIfApplicable(opcode, typeDesc);
        if (opcode == 187) {
            ++this.stackSize;
        }
        this.mw.visitTypeInsn(opcode, typeDesc);
    }

    @Override
    public void visitIntInsn(@Nonnegative int opcode, int operand) {
        if (opcode != 188) {
            ++this.stackSize;
        }
        this.mw.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(@Nonnegative int opcode, @Nonnegative int varIndex) {
        if (opcode == 25) {
            this.lastLoadedVarIndex = varIndex;
        }
        this.argumentCapturing.registerAssignmentToCaptureVariableIfApplicable(opcode, varIndex);
        this.stackSize += JVMInstruction.SIZE[opcode];
        this.mw.visitVarInsn(opcode, varIndex);
    }

    @Override
    public void visitLdcInsn(@Nonnull Object cst) {
        ++this.stackSize;
        if (cst instanceof Long || cst instanceof Double) {
            ++this.stackSize;
        }
        this.mw.visitLdcInsn(cst);
    }

    @Override
    public void visitJumpInsn(@Nonnegative int opcode, @Nonnull Label label) {
        this.stackSize += JVMInstruction.SIZE[opcode];
        this.mw.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, @Nonnull Label dflt, Label ... labels) {
        --this.stackSize;
        this.mw.visitTableSwitchInsn(min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(@Nonnull Label dflt, @Nonnull int[] keys, @Nonnull Label[] labels) {
        --this.stackSize;
        this.mw.visitLookupSwitchInsn(dflt, keys, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(@Nonnull String desc, @Nonnegative int dims) {
        this.stackSize += 1 - dims;
        this.mw.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitInsn(@Nonnegative int opcode) {
        if (opcode == 177) {
            this.generateCallToActiveInvocationsMethod("endInvocations");
        } else {
            this.stackSize += JVMInstruction.SIZE[opcode];
        }
        this.mw.visitInsn(opcode);
    }

    @Override
    public void visitLocalVariable(@Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nonnull Label start, @Nonnull Label end, @Nonnegative int index) {
        if (signature != null) {
            ArgumentCapturing.registerTypeToCaptureIntoListIfApplicable(index, signature);
        }
        if (end.position > 0) {
            this.mw.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    @Nonnull
    MethodWriter getMethodWriter() {
        return this.mw;
    }
}

