/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.injection.BeanExporter;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InjectionProviders;
import mockit.internal.injection.InterfaceResolution;
import mockit.internal.injection.LifecycleMethods;
import mockit.internal.injection.TestedClass;
import mockit.internal.reflection.FieldReflection;
import mockit.internal.reflection.GenericTypeReflection;

public final class InjectionState {
    @Nonnull
    private static final Map<InjectionPoint, Object> globalObjects = new ConcurrentHashMap<InjectionPoint, Object>(2);
    @Nonnull
    private final Map<InjectionPoint, Object> testedObjects = new LinkedHashMap<InjectionPoint, Object>();
    @Nonnull
    private final Map<InjectionPoint, Object> instantiatedDependencies = new LinkedHashMap<InjectionPoint, Object>();
    @Nonnull
    public final InjectionProviders injectionProviders;
    @Nonnull
    public final LifecycleMethods lifecycleMethods = new LifecycleMethods();
    @Nonnull
    final InterfaceResolution interfaceResolution;
    @Nullable
    private BeanExporter beanExporter;
    private Object currentTestClassInstance;

    InjectionState() {
        this.injectionProviders = new InjectionProviders(this.lifecycleMethods);
        this.interfaceResolution = new InterfaceResolution();
    }

    void setInjectables(@Nonnull Object testClassInstance, @Nonnull List<? extends InjectionProvider> injectables) {
        this.currentTestClassInstance = testClassInstance;
        this.injectionProviders.setInjectables(injectables);
        this.lifecycleMethods.getServletConfigForInitMethodsIfAny(injectables, testClassInstance);
    }

    void addInjectables(@Nonnull Object testClassInstance, @Nonnull List<? extends InjectionProvider> injectablesToAdd) {
        this.currentTestClassInstance = testClassInstance;
        List<InjectionProvider> injectables = this.injectionProviders.addInjectables(injectablesToAdd);
        this.lifecycleMethods.getServletConfigForInitMethodsIfAny(injectables, testClassInstance);
    }

    Object getCurrentTestClassInstance() {
        return this.currentTestClassInstance;
    }

    @Nullable
    public Object getValueToInject(@Nonnull InjectionProvider injectionProvider) {
        return this.injectionProviders.getValueToInject(injectionProvider, this.currentTestClassInstance);
    }

    void saveTestedObject(@Nonnull InjectionPoint key, @Nonnull Object testedObject, boolean global) {
        Map<InjectionPoint, Object> objects = global ? globalObjects : this.testedObjects;
        objects.put(key, testedObject);
    }

    @Nullable
    Object getTestedInstance(@Nonnull InjectionPoint injectionPoint, boolean global) {
        Object testedInstance;
        Object object = testedInstance = this.instantiatedDependencies.isEmpty() ? null : this.findPreviouslyInstantiatedDependency(injectionPoint);
        if (testedInstance == null) {
            Object object2 = testedInstance = this.testedObjects.isEmpty() ? null : this.getValueFromExistingTestedObject(injectionPoint);
        }
        if (testedInstance == null && global) {
            testedInstance = globalObjects.get(injectionPoint);
        }
        return testedInstance;
    }

    @Nullable
    private Object findPreviouslyInstantiatedDependency(@Nonnull InjectionPoint injectionPoint) {
        InjectionPoint injectionPointWithTypeOnly;
        Object dependency = this.instantiatedDependencies.get(injectionPoint);
        if (dependency == null && (dependency = this.instantiatedDependencies.get(injectionPointWithTypeOnly = new InjectionPoint(injectionPoint.type))) == null) {
            dependency = InjectionState.findMatchingObject(this.instantiatedDependencies, null, injectionPointWithTypeOnly);
        }
        return dependency;
    }

    @Nullable
    private Object getValueFromExistingTestedObject(@Nonnull InjectionPoint injectionPoint) {
        for (Object testedObject : this.testedObjects.values()) {
            Object fieldValue = InjectionState.getValueFromFieldOfEquivalentTypeAndName(injectionPoint, testedObject);
            if (fieldValue == null) continue;
            return fieldValue;
        }
        return null;
    }

    @Nullable
    private static Object getValueFromFieldOfEquivalentTypeAndName(@Nonnull InjectionPoint injectionPoint, @Nonnull Object testedObject) {
        for (Field internalField : testedObject.getClass().getDeclaredFields()) {
            String qualifiedName;
            boolean qualified;
            String fieldName;
            Type fieldType = internalField.getGenericType();
            InjectionPoint internalInjectionPoint = new InjectionPoint(fieldType, fieldName = (qualified = (qualifiedName = InjectionPoint.getQualifiedName(internalField.getDeclaredAnnotations())) != null) ? qualifiedName : internalField.getName(), qualified);
            if (!internalInjectionPoint.equals(injectionPoint)) continue;
            Object fieldValue = FieldReflection.getFieldValue(internalField, testedObject);
            return fieldValue;
        }
        return null;
    }

    @Nullable
    public static <D> D getGlobalDependency(@Nonnull InjectionPoint key) {
        return (D)globalObjects.get(key);
    }

    @Nullable
    public Object getTestedValue(@Nonnull TestedClass testedClass, @Nonnull InjectionPoint injectionPoint) {
        Object testedValue = this.testedObjects.get(injectionPoint);
        if (testedValue == null) {
            testedValue = InjectionState.findMatchingObject(this.testedObjects, testedClass, injectionPoint);
        }
        return testedValue;
    }

    @Nullable
    public Object getInstantiatedDependency(@Nullable TestedClass testedClass, @Nonnull InjectionPoint dependencyKey) {
        Object dependency = this.testedObjects.get(dependencyKey);
        if (dependency == null && (dependency = InjectionState.findMatchingObject(this.testedObjects, testedClass, dependencyKey)) == null && (dependency = this.instantiatedDependencies.get(dependencyKey)) == null && (dependency = InjectionState.findMatchingObject(this.instantiatedDependencies, testedClass, dependencyKey)) == null) {
            dependency = InjectionState.findMatchingObject(globalObjects, testedClass, dependencyKey);
        }
        return dependency;
    }

    @Nullable
    private static Object findMatchingObject(@Nonnull Map<InjectionPoint, Object> availableObjects, @Nullable TestedClass testedClass, @Nonnull InjectionPoint injectionPoint) {
        if (availableObjects.isEmpty()) {
            return null;
        }
        GenericTypeReflection reflection = testedClass == null ? null : testedClass.reflection;
        Type dependencyType = injectionPoint.type;
        Object found = null;
        for (Map.Entry<InjectionPoint, Object> injectionPointAndObject : availableObjects.entrySet()) {
            InjectionPoint dependencyIP = injectionPointAndObject.getKey();
            Object dependencyObject = injectionPointAndObject.getValue();
            if (injectionPoint.equals(dependencyIP)) {
                return dependencyObject;
            }
            if (reflection != null) {
                if (!reflection.areMatchingTypes(dependencyType, dependencyIP.type)) continue;
                found = dependencyObject;
            }
            if (!injectionPoint.hasSameName(dependencyIP)) continue;
            return dependencyObject;
        }
        return injectionPoint.qualified ? null : found;
    }

    public void saveInstantiatedDependency(@Nonnull InjectionPoint dependencyKey, @Nonnull Object dependency) {
        this.instantiatedDependencies.put(dependencyKey, dependency);
    }

    public static void saveGlobalDependency(@Nonnull InjectionPoint dependencyKey, @Nonnull Object dependency) {
        globalObjects.put(dependencyKey, dependency);
    }

    void clearTestedObjectsAndInstantiatedDependencies() {
        this.testedObjects.clear();
        this.instantiatedDependencies.clear();
    }

    @Nonnull
    BeanExporter getBeanExporter() {
        if (this.beanExporter == null) {
            this.beanExporter = new BeanExporter(this);
        }
        return this.beanExporter;
    }

    @Nullable
    public Class<?> resolveInterface(@Nonnull Class<?> anInterface) {
        return this.interfaceResolution.resolveInterface(anInterface, this.currentTestClassInstance);
    }
}

