/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.reflection.ParameterReflection;
import mockit.internal.reflection.ThrowOfCheckedException;
import mockit.internal.util.Utilities;

public final class ConstructorReflection {
    private ConstructorReflection() {
    }

    @Nonnull
    static <T> Constructor<T> findSpecifiedConstructor(@Nonnull Class<?> theClass, @Nonnull Class<?>[] paramTypes) {
        for (Constructor<?> declaredConstructor : theClass.getDeclaredConstructors()) {
            Class<?>[] declaredParameterTypes = declaredConstructor.getParameterTypes();
            int firstRealParameter = ParameterReflection.indexOfFirstRealParameter(declaredParameterTypes, paramTypes);
            if (firstRealParameter < 0 || !ParameterReflection.matchesParameterTypes(declaredParameterTypes, paramTypes, firstRealParameter)) continue;
            return declaredConstructor;
        }
        String paramTypesDesc = ParameterReflection.getParameterTypesDescription(paramTypes);
        throw new IllegalArgumentException("Specified constructor not found: " + theClass.getSimpleName() + paramTypesDesc);
    }

    @Nonnull
    public static <T> T invokeAccessible(@Nonnull Constructor<T> constructor, Object ... initArgs) {
        try {
            return constructor.newInstance(initArgs);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            ThrowOfCheckedException.doThrow((Exception)cause);
            throw new IllegalStateException("Should never get here", cause);
        }
    }

    public static void newInstanceUsingCompatibleConstructor(@Nonnull Class<?> aClass, @Nonnull String argument) throws ReflectiveOperationException {
        Constructor<?> constructor = aClass.getDeclaredConstructor(String.class);
        Utilities.ensureThatMemberIsAccessible(constructor);
        constructor.newInstance(argument);
    }

    @Nonnull
    public static <T> T newInstanceUsingDefaultConstructor(@Nonnull Class<T> aClass) {
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(new Class[0]);
            Utilities.ensureThatMemberIsAccessible(constructor);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    @Nullable
    public static <T> T newInstanceUsingDefaultConstructorIfAvailable(@Nonnull Class<T> aClass) {
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignore) {
            return null;
        }
    }

    @Nullable
    public static <T> T newInstanceUsingPublicConstructorIfAvailable(@Nonnull Class<T> aClass, @Nonnull Class<?>[] parameterTypes, Object ... initArgs) {
        Constructor<T> publicConstructor;
        try {
            publicConstructor = aClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
        return ConstructorReflection.invokeAccessible(publicConstructor, initArgs);
    }
}

