/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.security.Provider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassWriter;
import mockit.asm.classes.WrappingClassVisitor;
import mockit.internal.ClassLoadingBridge;
import mockit.internal.expectations.mocking.MockedBridge;
import mockit.internal.faking.FakeBridge;
import mockit.internal.faking.FakeMethodBridge;

final class ClassLoadingBridgeFields {
    private ClassLoadingBridgeFields() {
    }

    static void createSyntheticFieldsInJREClassToHoldClassLoadingBridges(@Nonnull Instrumentation instrumentation) {
        FieldAdditionTransformer fieldAdditionTransformer = new FieldAdditionTransformer(instrumentation);
        instrumentation.addTransformer(fieldAdditionTransformer);
        NegativeArraySizeException.class.getName();
        String hostClassName = fieldAdditionTransformer.hostClassName;
        if (hostClassName == null) {
            Provider.class.getName();
            hostClassName = fieldAdditionTransformer.hostClassName;
        }
        ClassLoadingBridge.hostJREClassName = hostClassName;
    }

    private static final class FieldAdditionTransformer
    implements ClassFileTransformer {
        private static final int FIELD_ACCESS = 4105;
        @Nonnull
        private final Instrumentation instrumentation;
        String hostClassName;

        FieldAdditionTransformer(@Nonnull Instrumentation instrumentation) {
            this.instrumentation = instrumentation;
        }

        @Override
        @Nullable
        public byte[] transform(@Nullable ClassLoader loader, @Nonnull String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] classfileBuffer) {
            ClassReader cr;
            if (loader == null && this.hostClassName == null && Modifier.isPublic((cr = new ClassReader(classfileBuffer)).getAccess())) {
                this.instrumentation.removeTransformer(this);
                this.hostClassName = className;
                return FieldAdditionTransformer.getModifiedJREClassWithAddedFields(cr);
            }
            return null;
        }

        @Nonnull
        private static byte[] getModifiedJREClassWithAddedFields(@Nonnull ClassReader classReader) {
            ClassWriter cw = new ClassWriter(classReader);
            WrappingClassVisitor cv = new WrappingClassVisitor(cw){

                @Override
                public void visitEnd() {
                    this.addField(MockedBridge.MB);
                    this.addField(FakeBridge.MB);
                    this.addField(FakeMethodBridge.MB);
                }

                private void addField(@Nonnull ClassLoadingBridge mb) {
                    this.cw.visitField(4105, mb.id, "Ljava/lang/reflect/InvocationHandler;", null, null);
                }
            };
            classReader.accept(cv);
            return cw.toByteArray();
        }
    }
}

