/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import mockit.asm.metadata.ClassMetadataReader;
import mockit.internal.ClassFile;
import mockit.internal.state.ParameterNames;

public final class ParameterNameExtractor {
    private static final EnumSet<ClassMetadataReader.Attribute> PARAMETERS = EnumSet.of(ClassMetadataReader.Attribute.Parameters);

    private ParameterNameExtractor() {
    }

    @Nonnull
    public static String extractNames(@Nonnull Class<?> classOfInterest) {
        String className = classOfInterest.getName();
        String classDesc = className.replace('.', '/');
        if (!ParameterNames.hasNamesForClass(classDesc)) {
            byte[] classfile = ClassFile.readBytesFromClassFile(classDesc);
            ClassMetadataReader cmr = new ClassMetadataReader(classfile, PARAMETERS);
            List<ClassMetadataReader.MethodInfo> methods = cmr.getMethods();
            for (ClassMetadataReader.MethodInfo method : methods) {
                String[] parameters;
                if (method.isSynthetic() || (parameters = method.parameters) == null) continue;
                ParameterNames.register(classDesc, method.name, method.desc, parameters);
            }
        }
        return classDesc;
    }
}

