/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.lineCoverage;

import java.io.PrintWriter;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.reporting.lineCoverage.LineCoverageFormatter;
import mockit.coverage.reporting.parsing.LineParser;

public final class LineCoverageOutput {
    @Nonnull
    private final PrintWriter output;
    @Nonnull
    private final PerFileLineCoverage lineCoverageData;
    @Nonnull
    private final LineCoverageFormatter lineCoverageFormatter;

    public LineCoverageOutput(@Nonnull PrintWriter output, @Nonnull PerFileLineCoverage lineCoverageData, boolean withCallPoints) {
        this.output = output;
        this.lineCoverageData = lineCoverageData;
        this.lineCoverageFormatter = new LineCoverageFormatter(withCallPoints);
    }

    public boolean writeLineWithCoverageInfo(@Nonnull LineParser lineParser) {
        int line = lineParser.getNumber();
        if (!this.lineCoverageData.hasLineData(line)) {
            return false;
        }
        int lineExecutionCount = this.lineCoverageData.getExecutionCount(line);
        if (lineExecutionCount < 0) {
            return false;
        }
        this.writeLineExecutionCount(lineExecutionCount);
        this.writeExecutableCode(lineParser);
        return true;
    }

    private void writeLineExecutionCount(@Nonnegative int lineExecutionCount) {
        this.output.write("<td class='ct'>");
        this.output.print(lineExecutionCount);
        this.output.println("</td>");
    }

    private void writeExecutableCode(@Nonnull LineParser lineParser) {
        String formattedLine = this.lineCoverageFormatter.format(lineParser, this.lineCoverageData);
        this.output.write("      <td>");
        this.output.write(formattedLine);
        this.output.println("</td>");
    }
}

