/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.state.TestRun;

public enum ExecutionMode {
    Regular{

        @Override
        boolean isNativeMethodToBeIgnored(int access) {
            return false;
        }

        @Override
        boolean isToExecuteRealImplementation(@Nullable Object instance) {
            return instance != null && !TestRun.mockFixture().isInstanceOfMockedClass(instance);
        }
    }
    ,
    Partial{

        @Override
        boolean isToExecuteRealImplementation(@Nullable Object instance) {
            return instance != null && !TestRun.mockFixture().isInstanceOfMockedClass(instance);
        }

        @Override
        boolean isWithRealImplementation(@Nullable Object instance) {
            return instance == null || !TestRun.getExecutingTest().isInjectableMock(instance);
        }

        @Override
        boolean isToExecuteRealObjectOverride(@Nonnull Object instance) {
            return true;
        }
    }
    ,
    PerInstance{

        @Override
        boolean isStaticMethodToBeIgnored(int access) {
            return Modifier.isStatic(access);
        }

        @Override
        boolean isToExecuteRealImplementation(@Nullable Object instance) {
            return instance == null || TestRun.getExecutingTest().isUnmockedInstance(instance);
        }

        @Override
        boolean isToExecuteRealObjectOverride(@Nonnull Object instance) {
            return TestRun.getExecutingTest().isUnmockedInstance(instance);
        }
    };


    public final boolean isMethodToBeIgnored(int access) {
        return this.isStaticMethodToBeIgnored(access) || this.isNativeMethodToBeIgnored(access);
    }

    boolean isStaticMethodToBeIgnored(int access) {
        return false;
    }

    boolean isNativeMethodToBeIgnored(int access) {
        return Modifier.isNative(access);
    }

    boolean isToExecuteRealImplementation(@Nullable Object instance) {
        return false;
    }

    boolean isWithRealImplementation(@Nullable Object instance) {
        return false;
    }

    boolean isToExecuteRealObjectOverride(@Nonnull Object instance) {
        return false;
    }
}

