/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.AutoBoxing;

public final class TypeConversion {
    private TypeConversion() {
    }

    @Nullable
    public static Object convertFromString(@Nonnull Class<?> targetType, @Nonnull String value) {
        if (targetType == String.class) {
            return value;
        }
        if (TypeConversion.isCharacter(targetType)) {
            return Character.valueOf(value.charAt(0));
        }
        if (targetType.isPrimitive() || AutoBoxing.isWrapperOfPrimitiveType(targetType)) {
            return TypeConversion.newWrapperInstance(targetType, value);
        }
        if (targetType == BigDecimal.class) {
            return new BigDecimal(value.trim());
        }
        if (targetType == BigInteger.class) {
            return new BigInteger(value.trim());
        }
        if (targetType == AtomicInteger.class) {
            return new AtomicInteger(Integer.parseInt(value.trim()));
        }
        if (targetType == AtomicLong.class) {
            return new AtomicLong(Long.parseLong(value.trim()));
        }
        if (targetType.isEnum()) {
            return TypeConversion.enumValue(targetType, value);
        }
        return null;
    }

    private static boolean isCharacter(@Nonnull Class<?> targetType) {
        return targetType == Character.TYPE || targetType == Character.class;
    }

    @Nonnull
    private static Object newWrapperInstance(@Nonnull Class<?> targetType, @Nonnull String value) {
        String trimmedValue = value.trim();
        try {
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return Integer.valueOf(trimmedValue);
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return Long.valueOf(trimmedValue);
            }
            if (targetType == Short.TYPE || targetType == Short.class) {
                return Short.valueOf(trimmedValue);
            }
            if (targetType == Byte.TYPE || targetType == Byte.class) {
                return Byte.valueOf(trimmedValue);
            }
            if (targetType == Double.TYPE || targetType == Double.class) {
                return Double.valueOf(trimmedValue);
            }
            if (targetType == Float.TYPE || targetType == Float.class) {
                return Float.valueOf(trimmedValue);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid value \"" + trimmedValue + "\" for " + targetType);
        }
        return Boolean.valueOf(trimmedValue);
    }

    @Nonnull
    private static <E extends Enum<E>> Object enumValue(Class<?> targetType, @Nonnull String value) {
        Class<?> enumType = targetType;
        return Enum.valueOf(enumType, value);
    }
}

