/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class JaxbUtil {
    public static final String UTF_8 = "UTF-8";

    public static String marshall(Object object, String encoding) throws JAXBException, UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String result = "";
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)encoding);
            m.marshal(object, (OutputStream)out);
            result = new String(out.toByteArray(), encoding);
        }
        catch (JAXBException e) {
            throw new JAXBException("Marshallointi ep\u00e4onnistui.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        return result;
    }

    public static Object unmarshallerForSOAPMessage(String inputXml, Class<?> clazz, String encoding) throws JAXBException, IOException, SOAPException, SAXException, ParserConfigurationException {
        Object result = null;
        try {
            SAXParserFactory spf = JaxbUtil.getSaxParserFactory();
            SAXParser parser = spf.newSAXParser();
            parser.parse(new InputSource(new StringReader(inputXml)), new DefaultHandler());
            SOAPMessage soapMessage = MessageFactory.newInstance().createMessage(null, (InputStream)new ByteArrayInputStream(inputXml.getBytes(encoding)));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller u = jc.createUnmarshaller();
            result = u.unmarshal((Node)soapMessage.getSOAPBody().extractContentAsDocument());
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (SOAPException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        return result;
    }

    public static Object unmarshaller(InputStream xml, Class<?> clazz, String encoding) throws JAXBException, SAXException, IOException, XMLStreamException {
        Object result = null;
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(xml);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller u = jc.createUnmarshaller();
            result = u.unmarshal(xsr);
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (XMLStreamException e) {
            throw e;
        }
        return result;
    }

    public static Object unmarshaller(Node node, Class<?> clazz, String encoding) throws JAXBException {
        Object result = null;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller u = jc.createUnmarshaller();
        result = u.unmarshal(node);
        return result;
    }

    public static Object unmarshaller(String xml, Class<?> clazz, String encoding) throws JAXBException, SAXException, ParserConfigurationException {
        Object result = null;
        try {
            SAXParserFactory spf = JaxbUtil.getSaxParserFactory();
            SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(new StringReader(xml)));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller u = jc.createUnmarshaller();
            result = u.unmarshal((Source)xmlSource);
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        return result;
    }

    public static Object unmarshaller(File file, Class<?> clazz, String encoding) throws JAXBException, SAXException, IOException, XMLStreamException {
        return JaxbUtil.unmarshaller(new FileInputStream(file), clazz, encoding);
    }

    public static SAXParserFactory getSaxParserFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spf.setNamespaceAware(true);
        return spf;
    }
}

