/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.colors;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.colors.PDCIEDictionaryBased;

public class PDCalGray
extends PDCIEDictionaryBased {
    public PDCalGray() {
    }

    public PDCalGray(COSObject obj) {
        super(obj);
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public ASAtom getType() {
        return ASAtom.CALGRAY;
    }

    @Override
    public double[] toRGB(double[] value) {
        double a = value[0];
        double gamma = this.getGamma();
        double powAG = Math.pow(a, gamma);
        return this.convXYZtoRGB(this.wpX * powAG, this.wpY * powAG, this.wpZ * powAG);
    }

    public Double getGamma() {
        return PDCalGray.getNumber(this.dictionary.getKey(ASAtom.GAMMA), 1.0);
    }

    private static Double getNumber(COSObject object, double defaultValue) {
        if (object != null) {
            return object.getReal();
        }
        return defaultValue;
    }
}

