/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.parsers.pkcs7;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class InputBuffer
extends ByteArrayInputStream
implements Cloneable {
    public InputBuffer(byte[] buffer) {
        super(buffer);
    }

    public InputBuffer dup() {
        try {
            InputBuffer result = (InputBuffer)this.clone();
            result.mark(Integer.MAX_VALUE);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public void truncate(int length) throws IOException {
        if (length > this.available()) {
            throw new IOException("Invalid data length");
        }
        this.count = this.pos + length;
    }

    public int peek() throws IOException {
        if (this.pos < this.count) {
            return this.buf[this.pos];
        }
        throw new IOException("Out of buffer");
    }

    public BigInteger getBigInteger(int length) throws IOException {
        if (length <= this.available() || length != 0) {
            byte[] data = new byte[length];
            System.arraycopy(this.buf, this.pos, data, 0, length);
            this.skip(length);
            return new BigInteger(data);
        }
        throw new IOException("Integer value length is invalid: " + length + ", available length: " + this.available());
    }

    public byte[] getBitString() throws IOException {
        byte paddingBitsCount = this.buf[this.pos];
        if (paddingBitsCount < 0 || paddingBitsCount > 7) {
            throw new IOException("Invalid padding bits count");
        }
        int length = this.available();
        byte[] result = new byte[length - 1];
        System.arraycopy(this.buf, this.pos + 1, result, 0, length - 1);
        if (paddingBitsCount != 0) {
            int n = length - 2;
            result[n] = (byte)(result[n] & 255 << paddingBitsCount);
        }
        this.skip(length);
        return result;
    }

    public byte[] toByteArray() {
        int available = this.available();
        if (available <= 0) {
            return null;
        }
        byte[] result = new byte[available];
        System.arraycopy(this.buf, this.pos, result, 0, available);
        return result;
    }
}

