/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.TransformerException;
import org.verapdf.core.VeraPDFException;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.MrrHandler;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.report.HTMLReport;

final class HTMLHandler
extends MrrHandler {
    private final File file;
    private final PrintWriter reportStreamWriter;
    private final String wikiPath;

    private HTMLHandler(PrintWriter reportStreamWriter, File file, String wikiPath, boolean logPassed) throws VeraPDFException, IOException {
        super(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), logPassed);
        this.reportStreamWriter = reportStreamWriter;
        this.file = file;
        this.wikiPath = wikiPath;
    }

    static BatchProcessingHandler newInstance(PrintWriter reportStreamWriter, String wikiPath, boolean logPassed) throws VeraPDFException {
        try {
            File file = File.createTempFile("veraPDF", "xmlReport");
            return new HTMLHandler(reportStreamWriter, file, wikiPath, logPassed);
        }
        catch (IOException exception) {
            throw new VeraPDFException(exception.getMessage(), exception);
        }
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) throws VeraPDFException {
        super.handleBatchEnd(summary);
        try (FileInputStream xmlStream = new FileInputStream(this.file);){
            HTMLReport.writeHTMLReport((InputStream)xmlStream, this.reportStreamWriter, summary.isMultiJob(), this.wikiPath, true);
        }
        catch (IOException | TransformerException e) {
            throw new VeraPDFException(e.getMessage(), e);
        }
        this.file.deleteOnExit();
        this.reportStreamWriter.flush();
        this.reportStreamWriter.close();
    }
}

