/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.processor.reports.MetadataFixerReport;

@XmlRootElement(name="metadataRepairReport")
final class FixerReportImpl
implements MetadataFixerReport {
    @XmlAttribute
    private final String status;
    @XmlAttribute
    private final int fixCount;
    @XmlElementWrapper(name="fixes")
    @XmlElement(name="fix")
    private final List<String> fixes;
    @XmlElementWrapper(name="errors")
    @XmlElement(name="error")
    private final List<String> errors;

    private FixerReportImpl(String status, int fixCount, List<String> fixes, List<String> errors) {
        this.status = status;
        this.fixCount = fixCount;
        this.fixes = Collections.unmodifiableList(fixes);
        this.errors = Collections.unmodifiableList(errors);
    }

    private FixerReportImpl() {
        this("", 0, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public int getFixCount() {
        return this.fixCount;
    }

    @Override
    public List<String> getFixes() {
        return this.fixes;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    static final MetadataFixerReport fromValues(String status, int fixCount, List<String> fixes, List<String> errors) {
        return new FixerReportImpl(status, fixCount, fixes, errors);
    }

    static final MetadataFixerReport fromValues(MetadataFixerResult fixerResult) {
        int fixCount = 0;
        ArrayList<String> fixes = new ArrayList<String>();
        ArrayList<String> errors = new ArrayList();
        switch (fixerResult.getRepairStatus()) {
            case SUCCESS: 
            case ID_REMOVED: {
                fixCount = fixerResult.getAppliedFixes().size();
                fixes = new ArrayList<String>(fixerResult.getAppliedFixes());
                break;
            }
            case FIX_ERROR: {
                errors = new ArrayList<String>(fixerResult.getAppliedFixes());
                break;
            }
        }
        String status = fixerResult.getRepairStatus().toString();
        return new FixerReportImpl(status, fixCount, fixes, errors);
    }

    static class Adapter
    extends XmlAdapter<FixerReportImpl, MetadataFixerReport> {
        Adapter() {
        }

        public MetadataFixerReport unmarshal(FixerReportImpl report) {
            return report;
        }

        public FixerReportImpl marshal(MetadataFixerReport report) {
            return (FixerReportImpl)report;
        }
    }
}

