/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.dataItems;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class FieldData
implements Serializable {
    private static final long serialVersionUID = 8565599590976858508L;
    @Nonnegative
    int readCount;
    @Nonnegative
    int writeCount;
    @Nullable
    Boolean covered;

    private void writeObject(@Nonnull ObjectOutputStream out) throws IOException {
        this.isCovered();
        out.defaultWriteObject();
    }

    @Nonnegative
    public final int getReadCount() {
        return this.readCount;
    }

    @Nonnegative
    public final int getWriteCount() {
        return this.writeCount;
    }

    public final boolean isCovered() {
        if (this.covered == null) {
            this.covered = false;
            this.markAsCoveredIfNoUnreadValuesAreLeft();
        }
        return this.covered;
    }

    abstract void markAsCoveredIfNoUnreadValuesAreLeft();

    final void addCountsFromPreviousTestRun(@Nonnull FieldData previousInfo) {
        this.readCount += previousInfo.readCount;
        this.writeCount += previousInfo.writeCount;
        this.covered = this.isCovered() || previousInfo.isCovered();
    }
}

