/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.modification;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassInfo;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassWriter;
import mockit.asm.classes.WrappingClassVisitor;
import mockit.asm.fields.FieldVisitor;
import mockit.asm.methods.MethodVisitor;
import mockit.asm.methods.MethodWriter;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.modification.MethodModifier;
import mockit.coverage.modification.VisitInterruptedException;
import mockit.internal.ClassFile;

final class CoverageModifier
extends WrappingClassVisitor {
    private static final Map<String, CoverageModifier> INNER_CLASS_MODIFIERS = new HashMap<String, CoverageModifier>();
    private static final int FIELD_MODIFIERS_TO_IGNORE = 4112;
    @Nullable
    private String internalClassName;
    @Nullable
    private String simpleClassName;
    @Nonnull
    private String sourceFileName = "";
    @Nullable
    private FileCoverageData fileData;
    private final boolean forInnerClass;
    private boolean forEnumClass;
    @Nullable
    private String kindOfTopLevelType;

    @Nullable
    static byte[] recoverModifiedByteCodeIfAvailable(@Nonnull String innerClassName) {
        CoverageModifier modifier = INNER_CLASS_MODIFIERS.remove(innerClassName);
        return modifier == null ? null : modifier.toByteArray();
    }

    CoverageModifier(@Nonnull ClassReader cr) {
        this(cr, false);
    }

    private CoverageModifier(@Nonnull ClassReader cr, boolean forInnerClass) {
        super(new ClassWriter(cr));
        this.forInnerClass = forInnerClass;
    }

    private CoverageModifier(@Nonnull ClassReader cr, @Nonnull CoverageModifier other, @Nullable String simpleClassName) {
        this(cr, true);
        this.sourceFileName = other.sourceFileName;
        this.fileData = other.fileData;
        this.internalClassName = other.internalClassName;
        this.simpleClassName = simpleClassName;
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nonnull ClassInfo additionalInfo) {
        boolean nestedType;
        if ((access & 0x1000) != 0) {
            throw new VisitInterruptedException();
        }
        boolean bl = nestedType = name.indexOf(36) > 0;
        if (!nestedType && this.kindOfTopLevelType == null) {
            this.kindOfTopLevelType = CoverageModifier.getKindOfJavaType(access, additionalInfo.superName);
        }
        this.forEnumClass = (access & 0x4000) != 0;
        String sourceFileDebugName = CoverageModifier.getSourceFileDebugName(additionalInfo);
        if (!this.forInnerClass) {
            boolean cannotModify;
            this.extractClassAndSourceFileName(name);
            boolean bl2 = cannotModify = (access & 0x2000) != 0;
            if (cannotModify) {
                throw VisitInterruptedException.INSTANCE;
            }
            this.registerAsInnerClassModifierIfApplicable(access, name, nestedType);
            this.createFileData(sourceFileDebugName);
        }
        this.cw.visit(version, access, name, additionalInfo);
    }

    @Nonnull
    private static String getKindOfJavaType(int typeModifiers, @Nonnull String superName) {
        if ((typeModifiers & 0x2000) != 0) {
            return "ant";
        }
        if ((typeModifiers & 0x200) != 0) {
            return "itf";
        }
        if ((typeModifiers & 0x4000) != 0) {
            return "enm";
        }
        if ((typeModifiers & 0x400) != 0) {
            return "absCls";
        }
        if (superName.endsWith("Exception") || superName.endsWith("Error")) {
            return "exc";
        }
        return "cls";
    }

    @Nonnull
    private static String getSourceFileDebugName(@Nonnull ClassInfo additionalInfo) {
        String sourceFileDebugName = additionalInfo.sourceFileName;
        if (sourceFileDebugName == null || !sourceFileDebugName.endsWith(".java")) {
            throw VisitInterruptedException.INSTANCE;
        }
        return sourceFileDebugName;
    }

    private void extractClassAndSourceFileName(@Nonnull String className) {
        this.internalClassName = className;
        int p = className.lastIndexOf(47);
        if (p < 0) {
            this.simpleClassName = className;
            this.sourceFileName = "";
        } else {
            this.simpleClassName = className.substring(p + 1);
            this.sourceFileName = className.substring(0, p + 1);
        }
    }

    private void registerAsInnerClassModifierIfApplicable(int access, @Nonnull String name, boolean nestedType) {
        if (!this.forEnumClass && (access & 0x20) != 0 && nestedType) {
            INNER_CLASS_MODIFIERS.put(name.replace('/', '.'), this);
        }
    }

    private void createFileData(@Nonnull String sourceFileDebugName) {
        this.sourceFileName = this.sourceFileName + sourceFileDebugName;
        this.fileData = CoverageData.instance().getOrAddFile(this.sourceFileName, this.kindOfTopLevelType);
    }

    @Override
    public void visitInnerClass(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        this.cw.visitInnerClass(name, outerName, innerName, access);
        if (this.forInnerClass || CoverageModifier.isSyntheticOrEnumClass(access) || !this.isNestedInsideClassBeingModified(name, outerName)) {
            return;
        }
        String innerClassName = name.replace('/', '.');
        if (INNER_CLASS_MODIFIERS.containsKey(innerClassName)) {
            return;
        }
        ClassReader innerCR = ClassFile.createClassReader(CoverageModifier.class.getClassLoader(), name);
        if (innerCR != null) {
            CoverageModifier innerClassModifier = new CoverageModifier(innerCR, this, innerName);
            innerCR.accept(innerClassModifier);
            INNER_CLASS_MODIFIERS.put(innerClassName, innerClassModifier);
        }
    }

    private static boolean isSyntheticOrEnumClass(int access) {
        return (access & 0x1000) != 0 || access == 16392;
    }

    private boolean isNestedInsideClassBeingModified(@Nonnull String internalName, @Nullable String outerName) {
        String className = outerName == null ? internalName : outerName;
        int p = className.indexOf(36);
        String outerClassName = p < 0 ? className : className.substring(0, p);
        return outerClassName.equals(this.internalClassName);
    }

    @Override
    public FieldVisitor visitField(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        if (this.fileData != null && this.simpleClassName != null && (access & 0x1010) == 0) {
            this.fileData.dataCoverageInfo.addField(this.simpleClassName, name, (access & 8) != 0);
        }
        return this.cw.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        MethodWriter mw = this.cw.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x1000) != 0 || this.fileData == null || "<clinit>".equals(name) && this.forEnumClass) {
            return mw;
        }
        return new MethodModifier(mw, this.sourceFileName, this.fileData);
    }
}

