/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.lineCoverage;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CallPoint;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;
import mockit.coverage.reporting.ListOfCallPoints;
import mockit.coverage.reporting.lineCoverage.LineSegmentsFormatter;
import mockit.coverage.reporting.parsing.LineParser;

final class LineCoverageFormatter {
    @Nonnull
    private final StringBuilder formattedLine = new StringBuilder(200);
    @Nonnull
    private final LineSegmentsFormatter segmentsFormatter;
    @Nullable
    private final ListOfCallPoints listOfCallPoints;

    LineCoverageFormatter(boolean withCallPoints) {
        this.segmentsFormatter = new LineSegmentsFormatter(withCallPoints, this.formattedLine);
        this.listOfCallPoints = withCallPoints ? new ListOfCallPoints() : null;
    }

    String format(@Nonnull LineParser lineParser, @Nonnull PerFileLineCoverage lineCoverageData) {
        this.formattedLine.setLength(0);
        this.formattedLine.append("<pre class='pp");
        int line = lineParser.getNumber();
        LineCoverageData lineData = lineCoverageData.getLineData(line);
        if (lineData.containsBranches()) {
            this.formatLineWithMultipleSegments(lineParser, lineData);
        } else {
            this.formatLineWithSingleSegment(lineParser, lineData);
        }
        return this.formattedLine.toString();
    }

    private void formatLineWithMultipleSegments(@Nonnull LineParser lineParser, @Nonnull LineCoverageData lineData) {
        this.formattedLine.append(" jmp'>");
        this.segmentsFormatter.formatSegments(lineParser, lineData);
    }

    private void formatLineWithSingleSegment(@Nonnull LineParser lineParser, @Nonnull LineCoverageData lineData) {
        this.formattedLine.append(lineData.isCovered() ? " cvd" : " uncvd");
        List<CallPoint> callPoints = lineData.getCallPoints();
        if (this.listOfCallPoints != null && callPoints != null) {
            this.formattedLine.append(" cp' onclick='sh(this)");
        }
        this.formattedLine.append("' id='l").append(lineParser.getNumber()).append("s0'>");
        String content = lineParser.getInitialElement().toString();
        this.formattedLine.append(content).append("</pre>");
        if (this.listOfCallPoints != null) {
            this.listOfCallPoints.insertListOfCallPoints(callPoints);
            this.formattedLine.append(this.listOfCallPoints.getContents());
        }
    }
}

