/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.nio.CharBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationResults;
import mockit.internal.expectations.invocation.MultiValuedConversion;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.util.AutoBoxing;
import mockit.internal.util.MethodFormatter;
import mockit.internal.util.Utilities;

public final class ReturnTypeConversion {
    private static final Class<?>[] STRING = new Class[]{String.class};
    @Nonnull
    private ExpectedInvocation invocation;
    @Nullable
    private final InvocationResults invocationResults;
    @Nonnull
    private final Class<?> returnType;
    @Nonnull
    private final Object valueToReturn;

    public ReturnTypeConversion(@Nonnull ExpectedInvocation invocation, @Nonnull InvocationResults invocationResults, @Nonnull Class<?> returnType, @Nonnull Object value) {
        this.invocation = invocation;
        this.invocationResults = invocationResults;
        this.returnType = returnType;
        this.valueToReturn = value;
    }

    ReturnTypeConversion(@Nonnull ExpectedInvocation invocation, @Nonnull Class<?> returnType, @Nonnull Object value) {
        this.invocation = invocation;
        this.invocationResults = null;
        this.returnType = returnType;
        this.valueToReturn = value;
    }

    @Nonnull
    Object getConvertedValue() {
        Class<?> wrapperType = this.getWrapperType();
        Class<?> valueType = this.valueToReturn.getClass();
        if (valueType == wrapperType) {
            return this.valueToReturn;
        }
        if (wrapperType != null && AutoBoxing.isWrapperOfPrimitiveType(valueType)) {
            return this.getPrimitiveValueConvertingAsNeeded(wrapperType);
        }
        throw this.newIncompatibleTypesException();
    }

    @Nullable
    private Class<?> getWrapperType() {
        return AutoBoxing.isWrapperOfPrimitiveType(this.returnType) ? this.returnType : AutoBoxing.getWrapperType(this.returnType);
    }

    public void addConvertedValue() {
        Class<?> wrapperType = this.getWrapperType();
        Class<?> valueType = this.valueToReturn.getClass();
        if (valueType == wrapperType) {
            this.addReturnValue(this.valueToReturn);
        } else if (wrapperType != null && AutoBoxing.isWrapperOfPrimitiveType(valueType)) {
            this.addPrimitiveValueConvertingAsNeeded(wrapperType);
        } else {
            boolean valueIsArray = valueType.isArray();
            if (valueIsArray || this.valueToReturn instanceof Iterable || this.valueToReturn instanceof Iterator) {
                assert (this.invocationResults != null);
                new MultiValuedConversion(this.invocationResults, this.returnType, this.valueToReturn).addMultiValuedResultBasedOnTheReturnType(valueIsArray);
            } else {
                if (wrapperType != null) {
                    throw this.newIncompatibleTypesException();
                }
                this.addResultFromSingleValue();
            }
        }
    }

    private void addReturnValue(@Nonnull Object returnValue) {
        assert (this.invocationResults != null);
        this.invocationResults.addReturnValueResult(returnValue);
    }

    private void addPrimitiveValueConvertingAsNeeded(@Nonnull Class<?> targetType) {
        Object convertedValue = this.getPrimitiveValueConvertingAsNeeded(targetType);
        this.addReturnValue(convertedValue);
    }

    private void addResultFromSingleValue() {
        if (this.returnType == Object.class) {
            this.addReturnValue(this.valueToReturn);
        } else {
            if (this.returnType == Void.TYPE) {
                throw this.newIncompatibleTypesException();
            }
            if (this.addByteArrayIfApplicable()) {
                return;
            }
            if (this.returnType.isArray()) {
                this.addArray();
            } else if (this.returnType.isAssignableFrom(ListIterator.class)) {
                this.addListIterator();
            } else {
                if (this.addCollectionWithSingleElement()) {
                    return;
                }
                if (Utilities.JAVA8 && this.addJava8ObjectIfApplicable()) {
                    return;
                }
                if (this.valueToReturn instanceof CharSequence) {
                    this.addCharSequence((CharSequence)this.valueToReturn);
                } else {
                    this.addPrimitiveValue();
                }
            }
        }
    }

    @Nonnull
    private IllegalArgumentException newIncompatibleTypesException() {
        String valueTypeName = MethodReflection.JAVA_LANG.matcher(this.valueToReturn.getClass().getName()).replaceAll("");
        String returnTypeName = MethodReflection.JAVA_LANG.matcher(this.returnType.getName()).replaceAll("");
        MethodFormatter methodDesc = new MethodFormatter(this.invocation.getClassDesc(), this.invocation.getMethodNameAndDescription());
        String msg = "Value of type " + valueTypeName + " incompatible with return type " + returnTypeName + " of " + methodDesc;
        return new IllegalArgumentException(msg);
    }

    private void addArray() {
        Object array = Array.newInstance(this.returnType.getComponentType(), 1);
        Array.set(array, 0, this.valueToReturn);
        this.addReturnValue(array);
    }

    private void addListIterator() {
        ArrayList<Object> l = new ArrayList<Object>(1);
        l.add(this.valueToReturn);
        ListIterator iterator = l.listIterator();
        this.addReturnValue(iterator);
    }

    private void addCharSequence(@Nonnull CharSequence textualValue) {
        Object convertedValue = textualValue;
        if (this.returnType.isAssignableFrom(ByteArrayInputStream.class)) {
            convertedValue = new ByteArrayInputStream(textualValue.toString().getBytes());
        } else if (this.returnType.isAssignableFrom(StringReader.class)) {
            convertedValue = new StringReader(textualValue.toString());
        } else if (!(textualValue instanceof StringBuilder) && this.returnType.isAssignableFrom(StringBuilder.class)) {
            convertedValue = new StringBuilder(textualValue);
        } else if (!(textualValue instanceof CharBuffer) && this.returnType.isAssignableFrom(CharBuffer.class)) {
            convertedValue = CharBuffer.wrap(textualValue);
        } else {
            Object valueFromText = ConstructorReflection.newInstanceUsingPublicConstructorIfAvailable(this.returnType, STRING, textualValue);
            if (valueFromText != null) {
                convertedValue = valueFromText;
            }
        }
        this.addReturnValue(convertedValue);
    }

    private boolean addByteArrayIfApplicable() {
        if (this.returnType == byte[].class && this.valueToReturn instanceof CharSequence) {
            this.addReturnValue(this.valueToReturn.toString().getBytes());
            return true;
        }
        return false;
    }

    private boolean addCollectionWithSingleElement() {
        AbstractCollection container = null;
        if (this.returnType.isAssignableFrom(ArrayList.class)) {
            container = new ArrayList<Object>(1);
        } else if (this.returnType.isAssignableFrom(LinkedList.class)) {
            container = new LinkedList();
        } else if (this.returnType.isAssignableFrom(HashSet.class)) {
            container = new HashSet(1);
        } else if (this.returnType.isAssignableFrom(TreeSet.class)) {
            container = new TreeSet();
        }
        if (container != null) {
            container.add(this.valueToReturn);
            this.addReturnValue(container);
            return true;
        }
        return false;
    }

    private boolean addJava8ObjectIfApplicable() {
        if (this.returnType == Optional.class) {
            this.addReturnValue(Optional.of(this.valueToReturn));
            return true;
        }
        if (this.returnType.isAssignableFrom(Stream.class)) {
            this.addReturnValue(Collections.singletonList(this.valueToReturn).stream());
            return true;
        }
        return false;
    }

    private void addPrimitiveValue() {
        Class<?> primitiveType = AutoBoxing.getPrimitiveType(this.valueToReturn.getClass());
        if (primitiveType != null) {
            Class[] parameterType = new Class[]{primitiveType};
            Object convertedValue = ConstructorReflection.newInstanceUsingPublicConstructorIfAvailable(this.returnType, parameterType, this.valueToReturn);
            if (convertedValue == null) {
                convertedValue = MethodReflection.invokePublicIfAvailable(this.returnType, null, "valueOf", parameterType, this.valueToReturn);
            }
            if (convertedValue != null) {
                this.addReturnValue(convertedValue);
                return;
            }
        }
        throw this.newIncompatibleTypesException();
    }

    @Nonnull
    private Object getPrimitiveValueConvertingAsNeeded(@Nonnull Class<?> targetType) {
        Object convertedValue = null;
        if (this.valueToReturn instanceof Number) {
            convertedValue = ReturnTypeConversion.convertFromNumber(targetType, (Number)this.valueToReturn);
        } else if (this.valueToReturn instanceof Character) {
            convertedValue = ReturnTypeConversion.convertFromChar(targetType, ((Character)this.valueToReturn).charValue());
        }
        if (convertedValue == null) {
            throw this.newIncompatibleTypesException();
        }
        return convertedValue;
    }

    @Nullable
    private static Object convertFromNumber(@Nonnull Class<?> targetType, @Nonnull Number number) {
        if (targetType == Integer.class) {
            return number.intValue();
        }
        if (targetType == Short.class) {
            return number.shortValue();
        }
        if (targetType == Long.class) {
            return number.longValue();
        }
        if (targetType == Byte.class) {
            return number.byteValue();
        }
        if (targetType == Double.class) {
            return number.doubleValue();
        }
        if (targetType == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (targetType == Character.class) {
            return Character.valueOf((char)number.intValue());
        }
        return null;
    }

    @Nullable
    private static Object convertFromChar(@Nonnull Class<?> targetType, char c) {
        if (targetType == Integer.class) {
            return (int)c;
        }
        if (targetType == Short.class) {
            return (short)c;
        }
        if (targetType == Long.class) {
            return (long)c;
        }
        if (targetType == Byte.class) {
            return (byte)c;
        }
        if (targetType == Double.class) {
            return (double)c;
        }
        if (targetType == Float.class) {
            return Float.valueOf(c);
        }
        return null;
    }
}

