/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.TypeVariable;
import javax.annotation.Nonnull;
import mockit.internal.expectations.mocking.MockedClassModifier;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TypeRedefinition;
import mockit.internal.state.TestRun;

final class FieldTypeRedefinition
extends TypeRedefinition {
    private boolean usePartialMocking;

    FieldTypeRedefinition(@Nonnull MockedType typeMetadata) {
        super(typeMetadata);
    }

    boolean redefineTypeForTestedField() {
        this.usePartialMocking = true;
        return this.redefineTypeForFieldNotSet();
    }

    @Override
    void configureClassModifier(@Nonnull MockedClassModifier modifier) {
        if (this.usePartialMocking) {
            modifier.useDynamicMocking();
        }
    }

    boolean redefineTypeForFinalField() {
        if (this.targetClass == TypeVariable.class || !this.typeMetadata.injectable && this.targetClass.isInterface()) {
            String mockFieldName = this.typeMetadata.getName();
            throw new IllegalArgumentException("Final mock field \"" + mockFieldName + "\" must be of a class type");
        }
        return this.redefineTypeForFieldNotSet();
    }

    private boolean redefineTypeForFieldNotSet() {
        boolean redefined = this.redefineMethodsAndConstructorsInTargetType();
        if (redefined) {
            TestRun.mockFixture().registerMockedClass(this.targetClass);
        }
        return redefined;
    }
}

