/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection.full;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionState;

final class ServletDependencies {
    @Nonnull
    private final InjectionState injectionState;

    static boolean isApplicable(@Nonnull Class<?> dependencyType) {
        return dependencyType == HttpSession.class || dependencyType == ServletContext.class;
    }

    ServletDependencies(@Nonnull InjectionState injectionState) {
        this.injectionState = injectionState;
    }

    @Nonnull
    Object createAndRegisterDependency(@Nonnull Class<?> dependencyType) {
        if (dependencyType == ServletContext.class) {
            return this.createAndRegisterServletContext();
        }
        return this.createAndRegisterHttpSession();
    }

    @Nonnull
    private ServletContext createAndRegisterServletContext() {
        ServletContext context = new ServletContext(){
            private final Map<String, String> init = new HashMap<String, String>();
            private final Map<String, Object> attrs = new HashMap<String, Object>();

            public String getContextPath() {
                return "";
            }

            public ServletContext getContext(String uriPath) {
                return null;
            }

            public int getMajorVersion() {
                return 3;
            }

            public int getMinorVersion() {
                return 0;
            }

            public int getEffectiveMajorVersion() {
                return 3;
            }

            public int getEffectiveMinorVersion() {
                return 0;
            }

            public String getMimeType(String file) {
                return null;
            }

            public String getRealPath(String path) {
                return null;
            }

            public Set<String> getResourcePaths(String path) {
                return null;
            }

            public URL getResource(String path) {
                return this.getClass().getResource(path);
            }

            public InputStream getResourceAsStream(String path) {
                return this.getClass().getResourceAsStream(path);
            }

            public RequestDispatcher getRequestDispatcher(String path) {
                return null;
            }

            public RequestDispatcher getNamedDispatcher(String name) {
                return null;
            }

            public String getServletContextName() {
                return null;
            }

            public String getServerInfo() {
                return "JMockit 1.x";
            }

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }

            public Servlet getServlet(String name) {
                return null;
            }

            public Enumeration<Servlet> getServlets() {
                return null;
            }

            public Enumeration<String> getServletNames() {
                return null;
            }

            public void log(String msg) {
            }

            public void log(Exception exception, String msg) {
            }

            public void log(String message, Throwable throwable) {
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(this.init.keySet());
            }

            public String getInitParameter(String name) {
                return this.init.get(name);
            }

            public boolean setInitParameter(String name, String value) {
                return this.init.put(name, value) == null;
            }

            public Enumeration<String> getAttributeNames() {
                return Collections.enumeration(this.attrs.keySet());
            }

            public Object getAttribute(String name) {
                return this.attrs.get(name);
            }

            public void setAttribute(String name, Object value) {
                this.attrs.put(name, value);
            }

            public void removeAttribute(String name) {
                this.attrs.remove(name);
            }

            public ServletRegistration.Dynamic addServlet(String name, String className) {
                return null;
            }

            public ServletRegistration.Dynamic addServlet(String name, Servlet servlet) {
                return null;
            }

            public ServletRegistration.Dynamic addServlet(String nm, Class<? extends Servlet> c) {
                return null;
            }

            public <T extends Servlet> T createServlet(Class<T> clazz) {
                return null;
            }

            public ServletRegistration getServletRegistration(String servletName) {
                return null;
            }

            public Map<String, ? extends ServletRegistration> getServletRegistrations() {
                return null;
            }

            public FilterRegistration.Dynamic addFilter(String name, String className) {
                return null;
            }

            public FilterRegistration.Dynamic addFilter(String name, Filter filter) {
                return null;
            }

            public FilterRegistration.Dynamic addFilter(String name, Class<? extends Filter> cl) {
                return null;
            }

            public <T extends Filter> T createFilter(Class<T> clazz) {
                return null;
            }

            public FilterRegistration getFilterRegistration(String filterName) {
                return null;
            }

            public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
                return null;
            }

            public SessionCookieConfig getSessionCookieConfig() {
                return null;
            }

            public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
            }

            public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
                return null;
            }

            public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
                return null;
            }

            public void addListener(String className) {
            }

            public <T extends EventListener> void addListener(T t) {
            }

            public void addListener(Class<? extends EventListener> listenerClass) {
            }

            public <T extends EventListener> T createListener(Class<T> clazz) {
                return null;
            }

            public JspConfigDescriptor getJspConfigDescriptor() {
                return null;
            }

            public void declareRoles(String ... roleNames) {
            }

            public String getVirtualServerName() {
                return null;
            }

            public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
                return null;
            }

            public int getSessionTimeout() {
                return 0;
            }

            public void setSessionTimeout(int sessionTimeout) {
            }

            public String getRequestCharacterEncoding() {
                return null;
            }

            public void setRequestCharacterEncoding(String encoding) {
            }

            public String getResponseCharacterEncoding() {
                return null;
            }

            public void setResponseCharacterEncoding(String encoding) {
            }
        };
        InjectionPoint injectionPoint = new InjectionPoint((Type)((Object)ServletContext.class));
        InjectionState.saveGlobalDependency(injectionPoint, context);
        return context;
    }

    @Nonnull
    private HttpSession createAndRegisterHttpSession() {
        HttpSession session = new HttpSession(){
            private final String id = String.valueOf(Math.abs(new Random().nextInt()));
            private final long creationTime = System.currentTimeMillis();
            private final Map<String, Object> attrs = new HashMap<String, Object>();
            private int maxInactiveInterval;
            private boolean invalidated;

            public String getId() {
                return this.id;
            }

            public int getMaxInactiveInterval() {
                return this.maxInactiveInterval;
            }

            public void setMaxInactiveInterval(int interval) {
                this.maxInactiveInterval = interval;
            }

            public long getCreationTime() {
                this.checkValid();
                return this.creationTime;
            }

            public long getLastAccessedTime() {
                this.checkValid();
                return this.creationTime;
            }

            public boolean isNew() {
                this.checkValid();
                return false;
            }

            public Enumeration<String> getAttributeNames() {
                this.checkValid();
                return Collections.enumeration(this.attrs.keySet());
            }

            public Object getAttribute(String name) {
                this.checkValid();
                return this.attrs.get(name);
            }

            public void setAttribute(String name, Object value) {
                this.checkValid();
                this.attrs.put(name, value);
            }

            public void removeAttribute(String name) {
                this.checkValid();
                this.attrs.remove(name);
            }

            public void invalidate() {
                this.checkValid();
                this.attrs.clear();
                this.invalidated = true;
            }

            private void checkValid() {
                if (this.invalidated) {
                    throw new IllegalStateException("Session is invalid");
                }
            }

            public ServletContext getServletContext() {
                ServletContext context = (ServletContext)InjectionState.getGlobalDependency(new InjectionPoint((Type)((Object)ServletContext.class)));
                if (context == null) {
                    context = ServletDependencies.this.createAndRegisterServletContext();
                }
                return context;
            }

            public Object getValue(String name) {
                return null;
            }

            public void putValue(String name, Object value) {
            }

            public void removeValue(String name) {
            }

            public String[] getValueNames() {
                return null;
            }

            public HttpSessionContext getSessionContext() {
                return null;
            }
        };
        InjectionPoint injectionPoint = new InjectionPoint((Type)((Object)HttpSession.class));
        this.injectionState.saveInstantiatedDependency(injectionPoint, session);
        return session;
    }
}

