/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;

public class DateHelperDateTimeFormatter {
    private DateTimeFormatter xmlYear = null;
    private DateTimeFormatter xmlMonth = null;
    private DateTimeFormatter xmlDate = null;
    private DateTimeFormatter xmlDateHour = null;
    private DateTimeFormatter xmlMediumDate = null;
    private DateTimeFormatter xmlLongDate = null;
    private DateTimeFormatter oracleDate = null;
    private DateTimeFormatter oracleLongDate = null;
    private boolean acceptAllFormats = false;
    private static final Object nullDate = "nulldate";

    public DateHelperDateTimeFormatter() {
        this.xmlDate = this.createDateTimeFormatter("yyyyMMdd");
        this.xmlLongDate = this.createDateTimeFormatter("yyyyMMddHHmmss");
        this.oracleDate = this.createDateTimeFormatter("MM/dd/yyyy");
        this.oracleLongDate = this.createDateTimeFormatter("MM/dd/yyyy HH:mm:ss");
        this.acceptAllFormats = false;
    }

    public DateHelperDateTimeFormatter(boolean acceptAllFormats) {
        this.xmlYear = this.createDateTimeFormatter("yyyy");
        this.xmlMonth = this.createDateTimeFormatter("yyyyMM");
        this.xmlDate = this.createDateTimeFormatter("yyyyMMdd");
        this.xmlDateHour = this.createDateTimeFormatter("yyyyMMddHH");
        this.xmlMediumDate = this.createDateTimeFormatter("yyyyMMddHHmm");
        this.xmlLongDate = this.createDateTimeFormatter("yyyyMMddHHmmss");
        this.oracleDate = this.createDateTimeFormatter("MM/dd/yyyy");
        this.oracleLongDate = this.createDateTimeFormatter("MM/dd/yyyy HH:mm:ss");
        this.acceptAllFormats = acceptAllFormats;
    }

    public String toOracleDate(String logId, String origDate) throws UtilException {
        return this.toOracleDate(logId, origDate, this.oracleDate);
    }

    public String toOracleLongDate(String logId, String origDate) throws UtilException {
        return this.toOracleDate(logId, origDate, this.oracleLongDate);
    }

    public String toOracleDate(String logId, String origDate, DateTimeFormatter sdf) throws UtilException {
        LocalDateTime tempDate = null;
        String retDate = null;
        ParsePosition pos = new ParsePosition(0);
        if (origDate == null || origDate.trim().length() == 0 || origDate.equals(nullDate)) {
            return "";
        }
        if (origDate.length() == "yyyyMMddHHmmss".length()) {
            tempDate = LocalDateTime.parse(origDate, this.xmlLongDate);
        } else if (origDate.length() == "yyyyMMdd".length()) {
            tempDate = LocalDateTime.parse(origDate, this.xmlDate);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMMddHHmm".length()) {
            tempDate = LocalDateTime.parse(origDate, this.xmlMediumDate);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMMddHH".length()) {
            tempDate = LocalDateTime.parse(origDate, this.xmlDateHour);
        } else if (this.acceptAllFormats && origDate.length() == "yyyy".length()) {
            tempDate = LocalDateTime.parse(origDate, this.xmlYear);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMM".length()) {
            tempDate = LocalDateTime.parse(origDate, this.xmlMonth);
        } else {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        if (tempDate == null || pos.getErrorIndex() != -1) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        retDate = sdf.format(tempDate);
        if (origDate.length() == "yyyyMMddHHmmss".length()) {
            if (!this.xmlLongDate.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMdd".length()) {
            if (!this.xmlDate.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMddHH".length()) {
            if (!this.xmlDateHour.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMddHHmm".length()) {
            if (!this.xmlMediumDate.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMM".length()) {
            if (!this.xmlMonth.format(tempDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyy".length() && !this.xmlYear.format(tempDate).equals(origDate)) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        return retDate;
    }

    public Date toDate(String logId, String origDate) throws UtilException {
        return this.toDate(logId, origDate, this.oracleLongDate);
    }

    public Date toDate(String logId, String origDate, DateTimeFormatter sdf) throws UtilException {
        LocalDateTime retDate = null;
        ParsePosition pos = new ParsePosition(0);
        if (origDate == null || origDate.trim().length() == 0 || origDate.equals(nullDate)) {
            return null;
        }
        if (origDate.length() == "yyyyMMddHHmmss".length()) {
            retDate = LocalDateTime.parse(origDate, this.xmlLongDate);
        } else if (origDate.length() == "yyyyMMdd".length()) {
            retDate = LocalDateTime.parse(origDate, this.xmlDate);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMMddHHmm".length()) {
            retDate = LocalDateTime.parse(origDate, this.xmlMediumDate);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMMddHH".length()) {
            retDate = LocalDateTime.parse(origDate, this.xmlDateHour);
        } else if (this.acceptAllFormats && origDate.length() == "yyyy".length()) {
            retDate = LocalDateTime.parse(origDate, this.xmlYear);
        } else if (this.acceptAllFormats && origDate.length() == "yyyyMM".length()) {
            retDate = LocalDateTime.parse(origDate, this.xmlMonth);
        } else {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        if (retDate == null || pos.getErrorIndex() != -1) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        if (origDate.length() == "yyyyMMddHHmmss".length()) {
            if (!this.xmlLongDate.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMdd".length()) {
            if (!this.xmlDate.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMddHH".length()) {
            if (!this.xmlDateHour.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMMddHHmm".length()) {
            if (!this.xmlMediumDate.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyyMM".length()) {
            if (!this.xmlMonth.format(retDate).equals(origDate)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(origDate);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        } else if (origDate.length() == "yyyy".length() && !this.xmlYear.format(retDate).equals(origDate)) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2001");
            error.setErrorDescription(origDate);
            error.setCommonError(true);
            throw new UtilException(error);
        }
        return retDate == null ? null : Date.from(retDate.atZone(ZoneId.systemDefault()).toInstant());
    }

    public String toOracleDate(String origDate) throws UtilException {
        return this.toOracleDate("LogId puuttuu!", origDate);
    }

    public String toHL7ShortDate(Date origDate) {
        String rval = "";
        rval = origDate != null ? this.xmlDate.format(origDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()) : "nulldate";
        return rval;
    }

    public String toHL7LongDate(Date origDate) {
        String rval = "";
        rval = origDate != null ? this.xmlLongDate.format(origDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()) : "nulldate";
        return rval;
    }

    public Date parseDate(String logId, String dateString, String dateFormat) throws UtilException {
        Date returnDate = null;
        SimpleDateFormat sdf = null;
        if (dateString != null && !dateString.isEmpty() && !dateString.equals(nullDate)) {
            sdf = new SimpleDateFormat(dateFormat);
            ParsePosition pos = new ParsePosition(0);
            returnDate = sdf.parse(dateString, pos);
            if (returnDate == null || pos.getErrorIndex() != -1) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(dateString);
                error.setCommonError(true);
                throw new UtilException(error);
            }
            if (pos.getIndex() != dateString.length()) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(dateString);
                error.setCommonError(true);
                throw new UtilException(error);
            }
            if (!sdf.format(returnDate).equals(dateString)) {
                InternalServiceError error = new InternalServiceError();
                error.setErrorCode("2001");
                error.setErrorDescription(dateString);
                error.setCommonError(true);
                throw new UtilException(error);
            }
        }
        return returnDate;
    }

    public Date parseDate(String dateString, String dateFormat) throws UtilException {
        return this.parseDate("LogId puuttuu!", dateString, dateFormat);
    }

    public String getFormattedDate(String dateFormat) {
        return this.getFormattedDate(new Date(), dateFormat);
    }

    public String getFormattedDate(Date date, String dateFormat) {
        Locale locale = new Locale("fi", "FI");
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat, locale);
        return formatter.format(date);
    }

    public DateTimeFormatter createDateTimeFormatter(String format) {
        return new DateTimeFormatterBuilder().appendPattern(format).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.MILLI_OF_SECOND, 0L).toFormatter();
    }
}

