/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import fi.kanta.common.util.InternalServiceError;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;

public class LogHelper {
    private String hostName = "";

    public LogHelper() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
    }

    public String formatMsg(String user, String message) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] ");
        strBuff.append(message);
        return strBuff.toString();
    }

    public String formatMsg(String user, InternalServiceError error) {
        StringBuffer strBuff = new StringBuffer();
        if (error != null) {
            strBuff.append(this.hostName);
            strBuff.append(" [");
            strBuff.append(user);
            strBuff.append("] Lvl:");
            strBuff.append(error.getErrorLevel());
            strBuff.append(" Code:");
            strBuff.append(error.getErrorCode());
            strBuff.append(" Msg:");
            strBuff.append(error.getErrorMessage());
            strBuff.append(" Desc:");
            if (error.getErrorDescription() != null) {
                strBuff.append(error.getErrorDescription());
            }
        } else {
            strBuff.append(this.hostName);
            strBuff.append(" [");
            strBuff.append(user);
            strBuff.append("] NULL INTERNAL ERROR!!!");
        }
        return strBuff.toString();
    }

    public String formatMsg(String user, InternalServiceError error, Object[] args) {
        StringBuffer strBuff = new StringBuffer();
        if (error != null) {
            strBuff.append(this.hostName);
            strBuff.append(" [");
            strBuff.append(user);
            strBuff.append("] Lvl:");
            strBuff.append(error.getErrorLevel());
            strBuff.append(" Code:");
            strBuff.append(error.getErrorCode());
            strBuff.append(" Msg:");
            strBuff.append(MessageFormat.format(error.getErrorMessage(), args));
            strBuff.append(" Desc:");
            if (error.getErrorDescription() != null) {
                strBuff.append(MessageFormat.format(error.getErrorDescription(), args));
            }
        } else {
            strBuff.append(this.hostName);
            strBuff.append(" [");
            strBuff.append(user);
            strBuff.append("] NULL INTERNAL ERROR!!!");
        }
        return strBuff.toString();
    }

    public String formatMsg(String user, String message, String value) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] ");
        strBuff.append(message);
        strBuff.append(" (");
        strBuff.append(value);
        strBuff.append(")");
        return strBuff.toString();
    }

    public String formatMsg(String user, StringBuffer message, String value) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] ");
        strBuff.append(message);
        strBuff.append(" (");
        strBuff.append(value);
        strBuff.append(")");
        return strBuff.toString();
    }

    public String formatMsg(String user, StringBuffer message, StringBuffer value) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] ");
        strBuff.append(message);
        strBuff.append(" (");
        strBuff.append(value);
        strBuff.append(")");
        return strBuff.toString();
    }

    public String formatMsg(String user, String message, StringBuffer value) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] ");
        strBuff.append(message);
        strBuff.append(" (");
        strBuff.append(value);
        strBuff.append(")");
        return strBuff.toString();
    }

    public String formatMsg(String user, String message, int value) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] ");
        strBuff.append(message);
        strBuff.append(" (");
        strBuff.append(value);
        strBuff.append(")");
        return strBuff.toString();
    }

    public String formatMsg(String user, StringBuffer message, int value) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] ");
        strBuff.append(message);
        strBuff.append(" (");
        strBuff.append(value);
        strBuff.append(")");
        return strBuff.toString();
    }

    public String formatMsg(String user) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] ");
        return strBuff.toString();
    }

    public String formatMsgBgn(String user) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] BEGIN");
        return strBuff.toString();
    }

    public String formatMsgBgnService(String user) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] BEGIN SERVICE");
        return strBuff.toString();
    }

    public String formatMsgEnd(String user) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] END");
        return strBuff.toString();
    }

    public String formatMsgEndService(String user) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.hostName);
        strBuff.append(" [");
        strBuff.append(user);
        strBuff.append("] END SERVICE");
        return strBuff.toString();
    }
}

