/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments;

import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.exception.RerunException;
import fi.kanta.arkistopalvelu.olddocuments.filesystem.CompareInfo;
import fi.kanta.arkistopalvelu.olddocuments.filesystem.ListSubDirectories;
import fi.kanta.arkistopalvelu.olddocuments.manifest.Manifest;
import fi.kanta.arkistopalvelu.olddocuments.metadata.Hoitoasiakirja;
import fi.kanta.arkistopalvelu.olddocuments.metadata.Palvelutapahtuma;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RerunLogger {
    private DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder documentBuilder = this.documentFactory.newDocumentBuilder();
    private Logger log4j = Logger.getLogger(RerunLogger.class);
    private LogHelper logHelper = new LogHelper();
    private ErrorWrapperLoader errorWrapper = ErrorWrapperLoader.getInstance();
    private boolean reRunlogsGenerated = false;

    public static void main(String[] args) {
        try {
            RerunLogger rerunLogger = new RerunLogger();
            String logId = PropertyHandler.getInstance().getProperty(null, "logId");
            rerunLogger.execute(logId);
        }
        catch (ConfigException | RerunException | PropertyException | UtilException | IOException | ParserConfigurationException | TransformerException e) {
            Logger.getLogger(RerunLogger.class).error((Object)"RerunLogger virhe:", e);
        }
    }

    private void execute(String logId) throws PropertyException, ConfigException, ParserConfigurationException, UtilException, TransformerException, IOException, RerunException {
        File[] files;
        if (this.log4j.isInfoEnabled()) {
            this.log4j.info((Object)this.logHelper.formatMsgBgnService(logId));
        }
        int ajokierros = Integer.parseInt(PropertyHandler.getInstance().getProperty(logId, "ajokierros"));
        String logPath = PropertyHandler.getInstance().getProperty(logId, "logpath") + ajokierros;
        String manifestFile = PropertyHandler.getInstance().getProperty(logId, "manifestfile");
        String rerunManifestFilePrefix = PropertyHandler.getInstance().getProperty(logId, "rerunmanifestfileprefix");
        String rerunManifestFile = rerunManifestFilePrefix + ajokierros + ".xml";
        Object origManifestFile = manifestFile;
        if (ajokierros > 1) {
            origManifestFile = rerunManifestFile;
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)("Ajokierroksen " + ajokierros + " tiedot:"));
            this.log4j.debug((Object)("Lokipolku: " + logPath));
            this.log4j.debug((Object)("Ajossa k\u00e4ytett\u00e4v\u00e4n koontitiedoston nimi: " + (String)origManifestFile));
        }
        if ((files = this.getCompareFiles(logId, logPath)) != null && files.length > 0) {
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)("Compare-tiedostoja l\u00f6ytyi: " + files.length));
            }
            ArrayList<String> compareDirectories = new ArrayList<String>();
            Document document = null;
            Element palvelutapahtuma = null;
            Element hoitoasiakirja = null;
            Attr attr = null;
            CompareInfo compareInfo = null;
            Manifest manifest = null;
            List<Palvelutapahtuma> palvelutapahtumat = null;
            List<Hoitoasiakirja> hoitoasiakirjat = null;
            File nextRerunFile = null;
            String nextRerunFilePath = null;
            for (File file : files) {
                boolean writeRerunFile = false;
                compareInfo = this.getCompareInfo(logId, file);
                nextRerunFilePath = compareInfo.getManifestPath() + File.separator + rerunManifestFilePrefix + (ajokierros + 1) + ".xml";
                compareDirectories.add(compareInfo.getManifestPath());
                manifest = new Manifest(compareInfo.getManifestPath(), manifestFile);
                palvelutapahtumat = manifest.haePalvelutapahtumat();
                document = this.getDocument(logId, manifest);
                for (Palvelutapahtuma pt : palvelutapahtumat) {
                    palvelutapahtuma = document.createElement("palvelutapahtuma");
                    if (compareInfo.getSuccessOidList().contains(pt.getOid())) {
                        attr = document.createAttribute("id");
                        attr.setValue(pt.getOid());
                        palvelutapahtuma.setAttributeNode(attr);
                        attr = document.createAttribute("saved");
                        attr.setValue(Boolean.toString(true));
                        palvelutapahtuma.setAttributeNode(attr);
                        hoitoasiakirjat = pt.getHoitoasiakirjat();
                        for (Hoitoasiakirja ha : hoitoasiakirjat) {
                            boolean hasPalvelutapahtuma = false;
                            if (compareInfo.getSuccessOidList().contains(ha.getOid())) continue;
                            if (!hasPalvelutapahtuma) {
                                document.getDocumentElement().appendChild(palvelutapahtuma);
                                hasPalvelutapahtuma = true;
                            }
                            hoitoasiakirja = document.createElement("asiakirja");
                            palvelutapahtuma.appendChild(hoitoasiakirja);
                            attr = document.createAttribute("id");
                            attr.setValue(ha.getOid());
                            hoitoasiakirja.setAttributeNode(attr);
                            writeRerunFile = true;
                        }
                        continue;
                    }
                    document.getDocumentElement().appendChild(palvelutapahtuma);
                    attr = document.createAttribute("id");
                    attr.setValue(pt.getOid());
                    palvelutapahtuma.setAttributeNode(attr);
                    attr = document.createAttribute("saved");
                    attr.setValue(Boolean.toString(false));
                    palvelutapahtuma.setAttributeNode(attr);
                    writeRerunFile = true;
                    hoitoasiakirjat = pt.getHoitoasiakirjat();
                    for (Hoitoasiakirja ha : hoitoasiakirjat) {
                        hoitoasiakirja = document.createElement("asiakirja");
                        palvelutapahtuma.appendChild(hoitoasiakirja);
                        attr = document.createAttribute("id");
                        attr.setValue(ha.getOid());
                        hoitoasiakirja.setAttributeNode(attr);
                    }
                }
                if (!writeRerunFile) continue;
                nextRerunFile = new File(nextRerunFilePath);
                if (nextRerunFile.exists()) {
                    InternalServiceError error = this.errorWrapper.getError("0019");
                    error.setErrorDescription(nextRerunFile.getPath());
                    this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                    throw new RerunException(error);
                }
                this.printOut(logId, document, nextRerunFilePath);
            }
            this.checkUnfinishedDirectories(logId, (String)origManifestFile, compareDirectories, ajokierros);
            if (this.reRunlogsGenerated) {
                if (this.log4j.isInfoEnabled()) {
                    this.log4j.info((Object)"Uudelleenajo-koontitiedostoja kirjoitettiin.");
                }
            } else if (this.log4j.isInfoEnabled()) {
                this.log4j.info((Object)"Uudelleenajo-koontitiedostoja ei kirjoitettu.");
            }
            if (this.log4j.isInfoEnabled()) {
                this.log4j.info((Object)this.logHelper.formatMsgEndService(logId));
            }
        } else {
            InternalServiceError error = this.errorWrapper.getError("0017");
            error.setErrorDescription("Compare-tiedostoja ei l\u00f6ytynyt hakemistosta: " + logPath);
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            throw new RerunException(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private File[] getCompareFiles(String logId, String logPath) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        File folder = new File(logPath);
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("compare_") && name.endsWith(".log");
            }
        });
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return files;
    }

    private void checkUnfinishedDirectories(String logId, String manifestFile, List<String> compareDirectories, int ajokierros) throws IOException, PropertyException, ConfigException, TransformerException, RerunException, UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String nextRerunFilePath = null;
        ListSubDirectories lister = new ListSubDirectories(logId);
        String dataPath = PropertyHandler.getInstance().getProperty(logId, "filepath");
        String rerunManifestFilePrefix = PropertyHandler.getInstance().getProperty(logId, "rerunmanifestfileprefix");
        File nextRerunFile = null;
        Manifest manifest = null;
        List<String> origDirectories = lister.listDirs(dataPath, manifestFile);
        for (String dir : origDirectories) {
            if (compareDirectories.contains(dir)) continue;
            nextRerunFilePath = dir + File.separator + rerunManifestFilePrefix + (ajokierros + 1) + ".xml";
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)("Comparetiedostoa ei l\u00f6ytynyt hakemistolle: " + dir));
                this.log4j.debug((Object)("Luodaan uusi koontitiedosto uudelleenajoa varten: " + nextRerunFilePath));
            }
            manifest = new Manifest(dir, manifestFile);
            nextRerunFile = new File(nextRerunFilePath);
            if (!nextRerunFile.exists()) continue;
            InternalServiceError error = this.errorWrapper.getError("0019");
            error.setErrorDescription(nextRerunFile.getPath());
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            throw new RerunException(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private Document getDocument(String logId, Manifest manifest) throws ParserConfigurationException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        Document document = this.documentBuilder.newDocument();
        Element root = document.createElement("palvelutapahtumat");
        document.appendChild(root);
        Attr attr = document.createAttribute("xmlns:xsi");
        attr.setValue("http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNode(attr);
        attr = document.createAttribute("palvelujenantaja");
        attr = document.createAttribute("xsi:noNamespaceSchemaLocation");
        attr.setValue("Koontitiedosto.xsd");
        root.setAttributeNode(attr);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return document;
    }

    private void printOut(String logId, Document doc, String fileName) throws TransformerException, RerunException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("standalone", "no");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(new File(fileName));
            fw.write(writer.getBuffer().toString());
            this.reRunlogsGenerated = true;
        }
        catch (IOException e) {
            InternalServiceError error = this.errorWrapper.getError("0020");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new RerunException(error);
        }
        finally {
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                }
            }
            catch (IOException e) {
                this.log4j.error((Object)"Koontitiedoston sulkemisessa tapahtui virhe", (Throwable)e);
            }
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private CompareInfo getCompareInfo(String logId, File file) throws RerunException, PropertyException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        FileReader fr = null;
        BufferedReader br = null;
        CompareInfo compareInfo = new CompareInfo();
        ArrayList<String> successOidList = null;
        String dataPath = PropertyHandler.getInstance().getProperty(logId, "filepath");
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            successOidList = new ArrayList<String>();
            compareInfo = new CompareInfo();
            String line = null;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (i == 0) {
                    compareInfo.setManifestPath(dataPath + line);
                } else {
                    successOidList.add(line);
                }
                ++i;
            }
            compareInfo.setSuccessOidList(successOidList);
        }
        catch (FileNotFoundException e) {
            InternalServiceError error = this.errorWrapper.getError("0017");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new RerunException(error);
        }
        catch (IOException e) {
            InternalServiceError error = this.errorWrapper.getError("0017");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            throw new RerunException(error);
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                this.log4j.warn((Object)"Lokitiedoston sulkemisessa tapahtui virhe", (Throwable)e);
            }
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return compareInfo;
    }
}

