/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.metadata;

import fi.kanta.arkistopalvelu.olddocuments.metadata.DocumentData;
import fi.kanta.arkistopalvelu.olddocuments.utils.MimeHelper;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.ApplicationException;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocumentWrapper {
    String logId;
    Logger log4j = null;
    LogHelper logHelper = null;

    public DocumentWrapper(String logId) {
        this.logId = logId;
        this.log4j = Logger.getLogger(DocumentWrapper.class);
        this.logHelper = new LogHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getCdaWrap(DocumentData documentData, String documentFile) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        Document doc = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            DocumentBuilder parser = fact.newDocumentBuilder();
            doc = parser.newDocument();
            Element cdaMainNode = doc.createElementNS("http://webservices.arkistopalvelu.kanta.fi/", "controlActProcess");
            cdaMainNode.setAttribute("xmlns:xsi", "xsi");
            cdaMainNode.setAttribute("xmlns:v3", "urn:hl7-org:v3");
            Element reasonCode = doc.createElementNS("urn:hl7-org:v3", "reasonCode");
            reasonCode.setPrefix("v3");
            reasonCode.setAttribute("code", "PP37");
            reasonCode.setAttribute("codeSystem", "1.2.246.537.5.40157.2008");
            cdaMainNode.appendChild(reasonCode);
            Element overseer = doc.createElementNS("urn:hl7-org:v3", "overseer");
            overseer.setPrefix("v3");
            overseer.setAttribute("typeCode", "RESP");
            overseer.setAttribute("xsi:nil", "false");
            Element assignedPerson = doc.createElementNS("urn:hl7-org:v3", "assignedPerson");
            assignedPerson.setPrefix("v3");
            overseer.appendChild(assignedPerson);
            Element representedOrganization = doc.createElementNS("urn:hl7-org:v3", "v3:representedOrganization");
            representedOrganization.setPrefix("v3");
            representedOrganization.setAttribute("xsi:nil", "false");
            assignedPerson.appendChild(representedOrganization);
            Element id = doc.createElementNS("urn:hl7-org:v3", "id");
            id.setPrefix("v3");
            id.setAttribute("root", documentData.getRepresentedOrganization());
            id.setAttribute("extension", documentData.getRepresentedOrganizationExt());
            representedOrganization.appendChild(id);
            Element regcode = doc.createElementNS("urn:hl7-org:v3", "code");
            regcode.setPrefix("v3");
            regcode.setAttribute("code", documentData.getRegistryCode());
            regcode.setAttribute("codeSystem", "1.2.246.537.5.40150.2009");
            representedOrganization.appendChild(regcode);
            cdaMainNode.appendChild(overseer);
            Element authorOrPerformer = doc.createElementNS("urn:hl7-org:v3", "authorOrPerformer");
            authorOrPerformer.setPrefix("v3");
            authorOrPerformer.setAttribute("typeCode", "PRF");
            Element assignedPerson2 = doc.createElementNS("urn:hl7-org:v3", "assignedPerson");
            assignedPerson2.setPrefix("v3");
            Element representedOrganization2 = doc.createElementNS("urn:hl7-org:v3", "v3:representedOrganization");
            representedOrganization2.setPrefix("v3");
            Element id3 = doc.createElementNS("urn:hl7-org:v3", "id");
            id3.setPrefix("v3");
            id3.setAttribute("root", documentData.getCustodian());
            representedOrganization2.appendChild(id3);
            assignedPerson2.appendChild(representedOrganization2);
            authorOrPerformer.appendChild(assignedPerson2);
            cdaMainNode.appendChild(authorOrPerformer);
            Element subject = doc.createElementNS("urn:hl7-org:v3", "subject");
            subject.setPrefix("v3");
            Element clinicalDocument = doc.createElementNS("urn:hl7-org:v3", "clinicalDocument");
            clinicalDocument.setPrefix("v3");
            Element realmCode = doc.createElementNS("urn:hl7-org:v3", "realmCode");
            realmCode.setPrefix("v3");
            realmCode.setAttribute("code", "FI");
            clinicalDocument.appendChild(realmCode);
            Element typeId = doc.createElementNS("urn:hl7-org:v3", "typeId");
            typeId.setPrefix("v3");
            typeId.setAttribute("root", "2.16.840.1.113883.1.3");
            typeId.setAttribute("extension", "POCD_HD000050");
            clinicalDocument.appendChild(typeId);
            Element id4 = doc.createElementNS("urn:hl7-org:v3", "id");
            id4.setPrefix("v3");
            id4.setAttribute("root", documentData.getLogId());
            clinicalDocument.appendChild(id4);
            Element code2 = doc.createElementNS("urn:hl7-org:v3", "code");
            code2.setPrefix("v3");
            code2.setAttribute("code", documentData.getRegistry());
            code2.setAttribute("codeSystem", "1.2.246.537.5.40150.2008");
            clinicalDocument.appendChild(code2);
            Element text = doc.createElementNS("urn:hl7-org:v3", "text");
            text.setPrefix("v3");
            text.setTextContent(new MimeHelper().encodeToMIME(this.logId, documentFile));
            clinicalDocument.appendChild(text);
            Element statusCode = doc.createElementNS("urn:hl7-org:v3", "statusCode");
            statusCode.setPrefix("v3");
            statusCode.setAttribute("code", "active");
            clinicalDocument.appendChild(statusCode);
            Element effectiveTime = doc.createElementNS("urn:hl7-org:v3", "effectiveTime");
            effectiveTime.setPrefix("v3");
            effectiveTime.setAttribute("value", documentData.getEffectiveTime());
            clinicalDocument.appendChild(effectiveTime);
            Element confidentialityCode = doc.createElementNS("urn:hl7-org:v3", "confidentialityCode");
            confidentialityCode.setPrefix("v3");
            confidentialityCode.setAttribute("code", "5");
            confidentialityCode.setAttribute("codeSystem", "1.2.246.777.5.99902.2006");
            clinicalDocument.appendChild(confidentialityCode);
            Element languageCode = doc.createElementNS("urn:hl7-org:v3", "languageCode");
            languageCode.setPrefix("v3");
            languageCode.setAttribute("code", "FI");
            clinicalDocument.appendChild(languageCode);
            Element setId = doc.createElementNS("urn:hl7-org:v3", "setId");
            setId.setPrefix("v3");
            setId.setAttribute("root", documentData.getSetId());
            clinicalDocument.appendChild(setId);
            Element recordTarget = doc.createElementNS("urn:hl7-org:v3", "recordTarget");
            recordTarget.setPrefix("v3");
            Element patient = doc.createElementNS("urn:hl7-org:v3", "patient");
            patient.setPrefix("v3");
            Element id5 = doc.createElementNS("urn:hl7-org:v3", "id");
            id5.setPrefix("v3");
            if (documentData.getPatientId().length() > 1) {
                id5.setAttribute("extension", documentData.getPatientId());
                id5.setAttribute("root", documentData.getPatientIdRoot());
            } else {
                id5.setAttribute("extension", documentData.getTempPatientId());
                id5.setAttribute("root", documentData.getTempPatientRoot());
            }
            patient.appendChild(id5);
            Element statusCode2 = doc.createElementNS("urn:hl7-org:v3", "statusCode");
            statusCode2.setPrefix("v3");
            statusCode2.setAttribute("code", "active");
            patient.appendChild(statusCode2);
            Element patientPerson = doc.createElementNS("urn:hl7-org:v3", "patientPerson");
            patientPerson.setPrefix("v3");
            Element name2 = doc.createElementNS("urn:hl7-org:v3", "name");
            name2.setPrefix("v3");
            String givenNames = documentData.getPatientGivenNames();
            String[] temp = givenNames.split(" ");
            for (int i = 0; i < temp.length; ++i) {
                Element given4 = doc.createElementNS("urn:hl7-org:v3", "given");
                given4.setPrefix("v3");
                given4.setTextContent(temp[i]);
                name2.appendChild(given4);
            }
            Element family2 = doc.createElementNS("urn:hl7-org:v3", "family");
            family2.setPrefix("v3");
            family2.setTextContent(documentData.getPatientFamilyName());
            name2.appendChild(family2);
            patientPerson.appendChild(name2);
            patient.appendChild(patientPerson);
            recordTarget.appendChild(patient);
            clinicalDocument.appendChild(recordTarget);
            Element author = doc.createElementNS("urn:hl7-org:v3", "author");
            author.setPrefix("v3");
            Element time = doc.createElementNS("urn:hl7-org:v3", "time");
            time.setPrefix("v3");
            time.setAttribute("value", documentData.getAuthorTime());
            author.appendChild(time);
            Element assignedAuthor = doc.createElementNS("urn:hl7-org:v3", "assignedAuthor");
            assignedAuthor.setPrefix("v3");
            Element id6 = doc.createElementNS("urn:hl7-org:v3", "id");
            id6.setPrefix("v3");
            id6.setAttribute("root", "1.2.246.537.6.24");
            id6.setAttribute("extension", "");
            assignedAuthor.appendChild(id6);
            Element representedOrganization3 = doc.createElementNS("urn:hl7-org:v3", "representedOrganization");
            representedOrganization3.setPrefix("v3");
            Element id7 = doc.createElementNS("urn:hl7-org:v3", "id");
            id7.setPrefix("v3");
            id7.setAttribute("root", "1.2.246.537.6.24");
            id7.setAttribute("extension", "");
            representedOrganization3.appendChild(id7);
            assignedAuthor.appendChild(representedOrganization3);
            author.appendChild(assignedAuthor);
            clinicalDocument.appendChild(author);
            Element custodian = doc.createElementNS("urn:hl7-org:v3", "custodian");
            custodian.setPrefix("v3");
            Element assignedCustodian = doc.createElementNS("urn:hl7-org:v3", "assignedCustodian");
            assignedCustodian.setPrefix("v3");
            Element representedOrganization4 = doc.createElementNS("urn:hl7-org:v3", "representedOrganization");
            representedOrganization4.setPrefix("v3");
            Element id8 = doc.createElementNS("urn:hl7-org:v3", "id");
            id8.setPrefix("v3");
            id8.setAttribute("root", documentData.getCustodian());
            representedOrganization4.appendChild(id8);
            assignedCustodian.appendChild(representedOrganization4);
            custodian.appendChild(assignedCustodian);
            clinicalDocument.appendChild(custodian);
            subject.appendChild(clinicalDocument);
            cdaMainNode.appendChild(subject);
            doc.appendChild(cdaMainNode);
            Document document = doc;
            return document;
        }
        catch (ParserConfigurationException e) {
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, e.getMessage()), (Throwable)e);
        }
        catch (DOMException e) {
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, e.getMessage()), (Throwable)e);
        }
        catch (ApplicationException e) {
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, e.getMessage()), (Throwable)e);
        }
        catch (MessagingException e) {
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, e.getMessage()), (Throwable)e);
        }
        finally {
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
            }
        }
        return null;
    }
}

