/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.tasks;

import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.exception.MessagingException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ValidatorException;
import fi.kanta.arkistopalvelu.olddocuments.filesystem.FileReader;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.ICompensateDocumentClient;
import fi.kanta.arkistopalvelu.olddocuments.interfaces.IOldDocumentArchiver;
import fi.kanta.arkistopalvelu.olddocuments.logging.DbLogger;
import fi.kanta.arkistopalvelu.olddocuments.logging.IProcessLogger;
import fi.kanta.arkistopalvelu.olddocuments.messaging.dto.ArchiveResponseDTO;
import fi.kanta.arkistopalvelu.olddocuments.metadata.ExecutionMode;
import fi.kanta.arkistopalvelu.olddocuments.metadata.Hoitoasiakirja;
import fi.kanta.arkistopalvelu.olddocuments.metadata.OldDocumentMetadataReader;
import fi.kanta.arkistopalvelu.olddocuments.sign.SignatureChecker;
import fi.kanta.arkistopalvelu.olddocuments.tasks.AsiakirjaData;
import fi.kanta.arkistopalvelu.olddocuments.tasks.HoitoasiakirjaTaskResult;
import fi.kanta.arkistopalvelu.olddocuments.tasks.LoaderClientProxies;
import fi.kanta.arkistopalvelu.olddocuments.utils.ErrorMessageHelper;
import fi.kanta.arkistopalvelu.olddocuments.utils.LoaderConstants;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.request.AsiakirjaHAReq;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.components.XMLValidator;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.exception.ValidationException;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.lokipalvelu.webservices.kayttoloki.arkisto.web.ArkistoKayttoLokiResponseDetailWeb;
import fi.kela.kanta.exceptions.XPathHelperVTDException;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class HoitoasiakirjaTask
implements Callable<HoitoasiakirjaTaskResult> {
    private Logger log4j = Logger.getLogger(HoitoasiakirjaTask.class);
    private static Logger ERROR_LOGGER = Logger.getLogger((String)"errorlog");
    private LogHelper logHelper;
    private volatile String logId;
    private IProcessLogger logger;
    private String subsystem;
    private AsiakirjaData asiakirjaData;
    private boolean checkSignatures;
    private ExecutionMode mode;
    private String palvelutapahtumaid;
    private String asiakirjanId;

    public HoitoasiakirjaTask(AsiakirjaData asiakirjaData, IProcessLogger processLogger, ExecutionMode mode, String palvelutapahtumaid) throws PropertyException, MalformedURLException, UtilException {
        PropertyHandler props = PropertyHandler.getInstance();
        this.asiakirjaData = asiakirjaData;
        this.logger = processLogger;
        this.logHelper = new LogHelper();
        this.logId = processLogger.getLogId();
        this.subsystem = props.getProperty(this.logId, "subsystem");
        this.checkSignatures = Boolean.parseBoolean(props.getProperty(this.logId, "checksignature"));
        this.mode = mode;
        this.palvelutapahtumaid = palvelutapahtumaid;
    }

    @Override
    public HoitoasiakirjaTaskResult call() throws IOException, PropertyException, InterruptedException, UtilException, ValidationException {
        DbLogger dblogger;
        Hoitoasiakirja hoitoasiakirja = this.asiakirjaData.getHoitoasiakirja();
        this.asiakirjanId = hoitoasiakirja.getOid();
        String logExtension = "_" + this.asiakirjanId;
        this.logId = this.asiakirjanId;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        if ((dblogger = new DbLogger()).onkoHoitoasiakirjaArkistoitu(this.asiakirjanId)) {
            HoitoasiakirjaTaskResult taskResult = new HoitoasiakirjaTaskResult();
            taskResult.setHoitoasiakirja(hoitoasiakirja);
            taskResult.setSuccess(true);
        }
        IOldDocumentArchiver archiver = null;
        FileReader reader = new FileReader(this.logId);
        XMLValidator schemaValidator = new XMLValidator();
        HoitoasiakirjaTaskResult taskResult = new HoitoasiakirjaTaskResult();
        taskResult.setHoitoasiakirja(hoitoasiakirja);
        String certificatedate = "2050-01-01T00:00:00Z";
        Object errorMsg = "";
        String errorCode = null;
        boolean error = false;
        try {
            archiver = LoaderClientProxies.getArkistoClient().getProxy();
            this.log4j.info((Object)("START THREAD hoitoasiakirja " + hoitoasiakirja.getOid()));
            File hoitoasiakirjaFile = hoitoasiakirja.getFile();
            String hoitoasiakirjaDocText = reader.getContent(hoitoasiakirjaFile);
            schemaValidator.validateXML(this.logId, reader.readXMLDoc(hoitoasiakirjaFile, true), PropertyHandler.getInstance().getCDASchema());
            if (this.checkSignatures) {
                this.log4j.info((Object)"Checking signatures");
                SignatureChecker checker = new SignatureChecker();
                certificatedate = checker.checkSignatures(this.logId, hoitoasiakirjaDocText, this.subsystem, hoitoasiakirjaFile);
            }
            OldDocumentMetadataReader metadataReader = new OldDocumentMetadataReader(this.logId);
            AsiakirjaHAReq haRequest = metadataReader.getHoitoasiakirjaReq(this.logId, hoitoasiakirjaFile, this.asiakirjaData.getAsiakirjaPTReq().getAsiakirja().get(0), certificatedate, this.asiakirjaData.getRekisterinpitaja());
            if (this.asiakirjaData.isTestMode()) {
                this.log4j.info((Object)"TESTMODE Hoitoasiakirjan tallennus");
                taskResult.setResultStatus("290000");
                taskResult.setResultDescription("TESTMODE OK");
                taskResult.setSuccess(true);
            } else {
                this.log4j.info((Object)"NOT a TEST MODE Hoitoasiakirja");
                ArchiveResponseDTO haResponseFromPtVak = archiver.sendHAToArchive(this.logId, haRequest, hoitoasiakirjaDocText, this.asiakirjaData.getAsiakirjaPTReq());
                this.log4j.info((Object)"received HA response");
                if (haResponseFromPtVak != null) {
                    taskResult.setResultStatus(haResponseFromPtVak.getCode());
                    if (this.mode.equals((Object)ExecutionMode.RERUN)) {
                        String resultCode = haResponseFromPtVak.getCode();
                        if (resultCode.equals(LoaderConstants.PT_VAK_ARKISTO_RETURN_CODE_SUCCESS) || resultCode.equals("291159")) {
                            dblogger.logOK(hoitoasiakirja.getOid(), hoitoasiakirja.getFile());
                            this.logArkistonKaytto(hoitoasiakirja, logExtension, taskResult, haRequest, haResponseFromPtVak);
                            if (resultCode.equals("291159")) {
                                ERROR_LOGGER.error((Object)(hoitoasiakirja.getOid() + " oli jo arkistoitu mutta sallitaan koska kyseess\u00e4 uudelleenajo"));
                            } else {
                                this.log4j.info((Object)("HA tallennus OK " + hoitoasiakirja.getOid()));
                            }
                        } else {
                            taskResult.setSuccess(false);
                            ERROR_LOGGER.error((Object)(hoitoasiakirja.getFile().getAbsolutePath() + "\n   + Hoitoasiakirjavirhe: " + haResponseFromPtVak.getCode() + ", selite: " + haResponseFromPtVak.getMessage() + "\n"));
                            dblogger.kirjaaVirhe(hoitoasiakirja.getOid(), haResponseFromPtVak.getCode(), haResponseFromPtVak.getMessage(), hoitoasiakirja.getFile());
                        }
                    } else if (haResponseFromPtVak.getCode().equals(LoaderConstants.PT_VAK_ARKISTO_RETURN_CODE_SUCCESS)) {
                        dblogger.logOK(hoitoasiakirja.getOid(), hoitoasiakirja.getFile());
                        this.logArkistonKaytto(hoitoasiakirja, logExtension, taskResult, haRequest, haResponseFromPtVak);
                        this.log4j.info((Object)("HA tallennus OK " + hoitoasiakirja.getOid()));
                    } else {
                        taskResult.setSuccess(false);
                        ERROR_LOGGER.error((Object)(hoitoasiakirja.getFile().getAbsolutePath() + "\n   + Hoitoasiakirjavirhe: " + haResponseFromPtVak.getCode() + ", selite: " + haResponseFromPtVak.getMessage() + "\n"));
                        dblogger.kirjaaVirhe(hoitoasiakirja.getOid(), haResponseFromPtVak.getCode(), haResponseFromPtVak.getMessage(), hoitoasiakirja.getFile());
                    }
                } else {
                    taskResult.setSuccess(false);
                }
            }
        }
        catch (ValidatorException e) {
            error = true;
            errorCode = ErrorMessageHelper.getInternalErrorCode(e.getError());
            errorMsg = "Hoitoasiakirjan validointi ep\u00e4onnistui: " + hoitoasiakirja.getOid() + ErrorMessageHelper.getInternalErrorMessage(e.getError());
            this.log4j.error((Object)this.logHelper.formatMsg(this.logId, e.getError()), (Throwable)e);
        }
        catch (ValidationException e) {
            error = true;
            errorCode = ErrorMessageHelper.getInternalErrorCode(e.getInternalServiceError());
            errorMsg = "Hoitokirjan validointivirhe: " + hoitoasiakirja.getOid() + ErrorMessageHelper.getInternalErrorMessage(e.getInternalServiceError());
            this.log4j.error(errorMsg, (Throwable)e);
            ArrayList<InternalServiceError> errors = new ArrayList<InternalServiceError>();
            InternalServiceError ise = new InternalServiceError();
            ise.setErrorDescription("XML validointi ep\u00e4onnistui");
            ise.setErrorMessage("XML validointi ep\u00e4onnistui");
            ise.setErrorCode(e.getInternalServiceError().getErrorCode());
            errors.add(ise);
            dblogger.kirjaaVirhe(this.asiakirjanId, errors, hoitoasiakirja.getFile());
        }
        catch (PropertyException e) {
            error = true;
            errorCode = ErrorMessageHelper.getInternalErrorCode(e.getInternalServiceError());
            errorMsg = "Hoitoasiakirjan k\u00e4sittelyss\u00e4 virhe: " + hoitoasiakirja.getOid() + ErrorMessageHelper.getInternalErrorMessage(e.getInternalServiceError());
            this.log4j.error(errorMsg, (Throwable)e);
        }
        catch (IOException e) {
            error = true;
            errorMsg = "Hoitoasiakirjatiedostoa ei l\u00f6ytynyt: " + hoitoasiakirja.getOid() + ", " + hoitoasiakirja.getFile().getAbsolutePath();
            this.log4j.error(errorMsg, (Throwable)e);
            this.logger.missingDoc(hoitoasiakirja.getOid(), hoitoasiakirja.getFile().getAbsolutePath());
            ArrayList<InternalServiceError> errors = new ArrayList<InternalServiceError>();
            InternalServiceError ise = new InternalServiceError();
            ise.setErrorMessage("Hoitoasiakirjatiedostoa ei l\u00f6ytynyt");
            ise.setErrorDescription("Hoitoasiakirjatiedostoa ei l\u00f6ytynyt " + hoitoasiakirja.getFile().getAbsolutePath());
            errors.add(ise);
            dblogger.kirjaaVirhe(this.asiakirjanId, errors, hoitoasiakirja.getFile());
        }
        catch (ConfigException e) {
            error = true;
            errorCode = ErrorMessageHelper.getInternalErrorCode(e.getError());
            errorMsg = "Hoitoasiakirjan k\u00e4sittelyvirhe: " + hoitoasiakirja.getOid() + ErrorMessageHelper.getInternalErrorMessage(e.getError());
            this.log4j.error(errorMsg, (Throwable)e);
        }
        catch (UtilException e) {
            error = true;
            errorCode = ErrorMessageHelper.getInternalErrorCode(e.getInternalServiceError());
            errorMsg = "Hoitoasiakirjan k\u00e4sittelyss\u00e4 virhe: " + hoitoasiakirja.getOid() + ErrorMessageHelper.getInternalErrorMessage(e.getInternalServiceError());
            this.log4j.error(errorMsg, (Throwable)e);
            throw e;
        }
        catch (MessagingException | XPathHelperVTDException e) {
            error = true;
            errorMsg = "Hoitoasiakirjan k\u00e4sittelyvirhe: " + hoitoasiakirja.getOid() + " " + e.getMessage();
            this.log4j.error(errorMsg, e);
        }
        catch (SOAPFaultException soapExp) {
            error = true;
            errorMsg = "Hoitoasiakirjan k\u00e4sittelyss\u00e4 virhe: " + hoitoasiakirja.getOid() + soapExp.getMessage();
            this.log4j.error(errorMsg, (Throwable)soapExp);
            throw soapExp;
        }
        finally {
            LoaderClientProxies.getArkistoClient().releaseProxy(archiver);
        }
        if (error) {
            String errCode = errorCode != null ? errorCode : "ERROR";
            taskResult.setResultStatus(errCode);
            taskResult.setResultDescription((String)errorMsg);
            taskResult.setSuccess(false);
            this.log4j.debug((Object)"hoitoasiakirjatask success = false");
            ERROR_LOGGER.error((Object)(hoitoasiakirja.getFile().getAbsolutePath() + "\n   + Hoitoasiakirjavirhe: " + errCode + ", selite: " + (String)errorMsg + "\n"));
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        this.log4j.info((Object)("END THREAD hoitoasiakirja " + hoitoasiakirja.getOid()));
        return taskResult;
    }

    private void logArkistonKaytto(Hoitoasiakirja hoitoasiakirja, String logExtension, HoitoasiakirjaTaskResult taskResult, AsiakirjaHAReq haRequest, ArchiveResponseDTO haResponse) throws IOException, InterruptedException, MessagingException {
        this.log4j.info((Object)"logArkistonKaytto begin");
        ArkistoKayttoLokiResponseDetailWeb usageLogResponse = this.logger.writeUsageLog(this.subsystem, haRequest, logExtension);
        if ("600000".equals(usageLogResponse.getResultCode())) {
            taskResult.setSuccess(true);
            this.log4j.debug((Object)("Asiakirja tallennettu k\u00e4ytt\u00f6lokille: " + hoitoasiakirja.getOid()));
        } else {
            this.logger.error("Asiakirjan tallennuksen k\u00e4ytt\u00f6lokitus ep\u00e4onnistui: " + hoitoasiakirja.getOid());
            this.log4j.error((Object)("Asiakirjan tallennuksen k\u00e4ytt\u00f6lokitus ep\u00e4onnistui: " + hoitoasiakirja.getOid()));
            taskResult.setResultStatus(usageLogResponse.getResultCode());
            taskResult.setResultDescription(usageLogResponse.getDescription());
            taskResult.setSuccess(false);
            ERROR_LOGGER.error((Object)(hoitoasiakirja.getFile().getAbsolutePath() + "\n   + Hoitoasiakirjavirhe: " + usageLogResponse.getResultCode() + ", selite: " + usageLogResponse.getDescription() + "\n"));
            ArchiveResponseDTO kompensointiResultDetails = this.kompensoiHoitoasiakirja(hoitoasiakirja);
            if (!LoaderConstants.PT_VAK_ARKISTO_RETURN_CODE_SUCCESS.equals(kompensointiResultDetails.getCode())) {
                this.logger.error("Asiakirjan tallennuksen kompensointi ep\u00e4onnistui: " + hoitoasiakirja.getOid());
            } else {
                DbLogger dblogger = new DbLogger();
                dblogger.kompensoiasiakirja(hoitoasiakirja.getOid());
            }
        }
        this.log4j.info((Object)"logArkistonKaytto end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchiveResponseDTO kompensoiHoitoasiakirja(Hoitoasiakirja hoitoasiakirja) throws InterruptedException, MessagingException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        ICompensateDocumentClient kompensointiClient = null;
        ArchiveResponseDTO kompensointiResultDetails = null;
        try {
            this.log4j.info((Object)("Kutsutaan kompensointia hoitoasiakirjalle: " + hoitoasiakirja.getOid()));
            kompensointiClient = LoaderClientProxies.getKompensointiClient().getProxy();
            kompensointiResultDetails = kompensointiClient.execute(this.logId, hoitoasiakirja.getOid(), "5");
        }
        catch (Throwable throwable) {
            LoaderClientProxies.getKompensointiClient().releaseProxy(kompensointiClient);
            throw throwable;
        }
        LoaderClientProxies.getKompensointiClient().releaseProxy(kompensointiClient);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        return kompensointiResultDetails;
    }
}

