/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.common.components;

import fi.kanta.common.components.IXPathHelper;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.components.XPathHelper;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import fi.kanta.common.util.RelatedDocumentInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class RelatedDocumentHelper {
    Logger log = LoggerFactory.getLogger(RelatedDocumentHelper.class);
    private LogHelper logHelper = new LogHelper();
    private IXPathHelper xpathHelper = new XPathHelper();

    public RelatedDocumentInfo getRelatedDocInfo(String logId, Document doc) throws UtilException {
        RelatedDocumentInfo rdi = new RelatedDocumentInfo();
        try {
            this.log.debug(this.logHelper.formatMsgBgn(logId));
            String versionNumber = this.xpathHelper.getCodeDN(logId, doc, "/ClinicalDocument/versionNumber/@value");
            if (versionNumber != null && versionNumber.length() > 0) {
                rdi.setNewVersionNumber(Integer.parseInt(versionNumber));
            }
            rdi.setApndId(this.xpathHelper.getCodeDN(logId, doc, "ClinicalDocument/relatedDocument[@typeCode=\"APND\"]/parentDocument/id/@root"));
            rdi.setApndCode(this.xpathHelper.getCodeDN(logId, doc, "ClinicalDocument/relatedDocument[@typeCode=\"APND\"]/parentDocument/code/@code"));
            rdi.setApndSetId(this.xpathHelper.getCodeDN(logId, doc, "ClinicalDocument/relatedDocument[@typeCode=\"APND\"]/parentDocument/setId/@root"));
            if (rdi.getApndId() != null && rdi.getApndId().length() > 0) {
                rdi.setHasAppendValues(true);
            }
            rdi.setRplcId(this.xpathHelper.getCodeDN(logId, doc, "ClinicalDocument/relatedDocument[@typeCode=\"RPLC\"]/parentDocument/id/@root"));
            rdi.setRplCode(this.xpathHelper.getCodeDN(logId, doc, "ClinicalDocument/relatedDocument[@typeCode=\"RPLC\"]/parentDocument/code/@code"));
            rdi.setRplcSetId(this.xpathHelper.getCodeDN(logId, doc, "ClinicalDocument/relatedDocument[@typeCode=\"RPLC\"]/parentDocument/setId/@root"));
            if (rdi.getRplcId() != null && rdi.getRplcId().length() > 0) {
                rdi.setHasReplaceValues(true);
            }
            this.log.debug(this.logHelper.formatMsgEnd(logId));
        }
        catch (UtilException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2005");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return rdi;
    }

    public RelatedDocumentInfo getRelatedDocInfoDN(String logId, Document doc) throws UtilException {
        RelatedDocumentInfo rdi = new RelatedDocumentInfo();
        try {
            this.log.debug(this.logHelper.formatMsgBgn(logId));
            String versionNumber = this.xpathHelper.getCodeDN(logId, doc, "/:ClinicalDocument/:versionNumber/@value");
            if (versionNumber != null && versionNumber.length() > 0) {
                rdi.setNewVersionNumber(Integer.parseInt(versionNumber));
            }
            rdi.setApndId(this.xpathHelper.getCodeDN(logId, doc, "/:ClinicalDocument/:relatedDocument[@typeCode=\"APND\"]/:parentDocument/:id/@root"));
            rdi.setApndCode(this.xpathHelper.getCodeDN(logId, doc, "/:ClinicalDocument/:relatedDocument[@typeCode=\"APND\"]/:parentDocument/:code/@code"));
            rdi.setApndSetId(this.xpathHelper.getCodeDN(logId, doc, "/:ClinicalDocument/:relatedDocument[@typeCode=\"APND\"]/:parentDocument/:setId/@root"));
            if (rdi.getApndId() != null && rdi.getApndId().length() > 0) {
                rdi.setHasAppendValues(true);
            }
            rdi.setRplcId(this.xpathHelper.getCodeDN(logId, doc, "/:ClinicalDocument/:relatedDocument[@typeCode=\"RPLC\"]/:parentDocument/:id/@root"));
            rdi.setRplCode(this.xpathHelper.getCodeDN(logId, doc, "/:ClinicalDocument/:relatedDocument[@typeCode=\"RPLC\"]/:parentDocument/:code/@code"));
            rdi.setRplcSetId(this.xpathHelper.getCodeDN(logId, doc, "/:ClinicalDocument/:relatedDocument[@typeCode=\"RPLC\"]/:parentDocument/:setId/@root"));
            if (rdi.getRplcId() != null && rdi.getRplcId().length() > 0) {
                rdi.setHasReplaceValues(true);
            }
            this.log.debug(this.logHelper.formatMsgEnd(logId));
        }
        catch (UtilException ex) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode("2005");
            error.setCommonError(true);
            throw new UtilException(error, (Throwable)ex);
        }
        return rdi;
    }
}

