/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.xmp.impl;

import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFXMPNode;
import org.verapdf.xmp.impl.XMPNode;
import org.verapdf.xmp.options.PropertyOptions;

public class VeraPDFExtensionSchemaProperty {
    private static final String NAME = "name";
    private static final String VALUE_TYPE = "valueType";
    private static final String CATEGORY = "category";
    private static final String DESCRIPTION = "description";
    private static final String PDFA_PROPERTY_PREFIX = "pdfaProperty";
    private final VeraPDFXMPNode xmpNode;

    public VeraPDFExtensionSchemaProperty(VeraPDFXMPNode xmpNode) {
        this.xmpNode = xmpNode;
    }

    public String getName() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/property#".equals(child.getNamespaceURI()) || !NAME.equals(child.getName())) continue;
            return child.getValue();
        }
        return null;
    }

    public XMPNode getXmpNode() {
        return this.xmpNode.getOriginalNode();
    }

    public static VeraPDFExtensionSchemaProperty createPropertyDefinitionNode(String name, String valueType, String category, String description) throws XMPException {
        XMPNode node = new XMPNode("[]", "", new PropertyOptions(256), "rdf");
        node.addChild(new XMPNode("pdfaProperty:name", name, new PropertyOptions(0), PDFA_PROPERTY_PREFIX));
        node.addChild(new XMPNode("pdfaProperty:valueType", valueType, new PropertyOptions(0), PDFA_PROPERTY_PREFIX));
        node.addChild(new XMPNode("pdfaProperty:category", category, new PropertyOptions(0), PDFA_PROPERTY_PREFIX));
        node.addChild(new XMPNode("pdfaProperty:description", description, new PropertyOptions(0), PDFA_PROPERTY_PREFIX));
        return new VeraPDFExtensionSchemaProperty(VeraPDFXMPNode.fromXMPNode(node));
    }
}

