/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosDict;
import org.verapdf.gf.model.impl.cos.GFCosInfo;
import org.verapdf.gf.model.impl.pd.GFPDEncryption;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosInfo;
import org.verapdf.model.coslayer.CosTrailer;
import org.verapdf.pd.encryption.PDEncryption;

public class GFCosTrailer
extends GFCosDict
implements CosTrailer {
    private static final Logger LOGGER = Logger.getLogger(GFCosTrailer.class.getCanonicalName());
    public static final String COS_TRAILER_TYPE = "CosTrailer";
    public static final String ENCRYPT = "Encrypt";
    public static final String INFO = "Info";
    private final boolean isEncrypted;

    public GFCosTrailer(COSDictionary dictionary) {
        super(dictionary, COS_TRAILER_TYPE);
        this.isEncrypted = dictionary.getKey(ASAtom.ENCRYPT).get() != null;
    }

    public Boolean getisEncrypted() {
        return this.isEncrypted;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "Encrypt": {
                return this.getEncrypt();
            }
            case "Info": {
                return this.getInfo();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDEncryption> getEncrypt() {
        COSObject object = this.baseObject.getKey(ASAtom.ENCRYPT);
        if (object != null && object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFPDEncryption> list = new ArrayList<GFPDEncryption>(1);
            list.add(new GFPDEncryption(new PDEncryption(object)));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosInfo> getInfo() {
        COSObject object = this.baseObject.getKey(ASAtom.INFO);
        if (object != null && object.getType() == COSObjType.COS_DICT) {
            ArrayList<GFCosInfo> list = new ArrayList<GFCosInfo>(1);
            list.add(new GFCosInfo((COSDictionary)object.getDirectBase()));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

