/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSTrailer;
import org.verapdf.external.ICCProfile;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.features.AbstractFeaturesExtractor;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesReporter;
import org.verapdf.features.gf.GFFeaturesObjectCreator;
import org.verapdf.features.objects.ActionFeaturesObjectAdapter;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDAppearanceEntry;
import org.verapdf.pd.PDAppearanceStream;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.pd.PDNamesDictionary;
import org.verapdf.pd.PDNavigationNode;
import org.verapdf.pd.PDOutlineDictionary;
import org.verapdf.pd.PDOutlineItem;
import org.verapdf.pd.PDOutputIntent;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.PDPageTree;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.PDSignature;
import org.verapdf.pd.actions.PDAction;
import org.verapdf.pd.actions.PDAnnotationAdditionalActions;
import org.verapdf.pd.actions.PDCatalogAdditionalActions;
import org.verapdf.pd.actions.PDFormFieldActions;
import org.verapdf.pd.actions.PDPageAdditionalActions;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDICCBased;
import org.verapdf.pd.encryption.StandardSecurityHandler;
import org.verapdf.pd.font.PDCIDFont;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDType0Font;
import org.verapdf.pd.font.type3.PDType3Font;
import org.verapdf.pd.form.PDAcroForm;
import org.verapdf.pd.form.PDFormField;
import org.verapdf.pd.form.PDSignatureField;
import org.verapdf.pd.images.PDXForm;
import org.verapdf.pd.images.PDXImage;
import org.verapdf.pd.images.PDXObject;
import org.verapdf.pd.patterns.PDPattern;
import org.verapdf.pd.patterns.PDShading;
import org.verapdf.pd.patterns.PDShadingPattern;
import org.verapdf.pd.patterns.PDTilingPattern;
import org.verapdf.tools.PageLabels;

public final class GFFeatureParser {
    private static final EnumSet<FeatureObjectType> XOBJECTS = EnumSet.of(FeatureObjectType.FORM_XOBJECT, FeatureObjectType.IMAGE_XOBJECT, FeatureObjectType.POSTSCRIPT_XOBJECT);
    private static final Logger LOGGER = Logger.getLogger(GFFeatureParser.class.getCanonicalName());
    private static final String ID = "id";
    private static final String DEVICEGRAY_ID = "devgray";
    private static final String DEVICERGB_ID = "devrgb";
    private static final String DEVICECMYK_ID = "devcmyk";
    private final FeaturesReporter reporter;
    private final FeatureExtractorConfig config;
    private final Set<String> processedIDs;

    private GFFeatureParser(FeaturesReporter reporter, FeatureExtractorConfig config) {
        this.reporter = reporter;
        this.config = config;
        this.processedIDs = new HashSet<String>();
    }

    public static FeatureExtractionResult getFeaturesCollection(PDDocument document, FeatureExtractorConfig config) {
        FeaturesReporter reporter = new FeaturesReporter(config);
        return GFFeatureParser.getFeatures(document, reporter, config);
    }

    public static FeatureExtractionResult getFeaturesCollection(PDDocument document, List<AbstractFeaturesExtractor> extractors, FeatureExtractorConfig config) {
        FeaturesReporter reporter = new FeaturesReporter(config, extractors);
        return GFFeatureParser.getFeatures(document, reporter, config);
    }

    private static FeatureExtractionResult getFeatures(PDDocument document, FeaturesReporter reporter, FeatureExtractorConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Features config can not be null");
        }
        if (document != null) {
            GFFeatureParser parser = new GFFeatureParser(reporter, config);
            parser.parseDocumentFeatures(document);
        }
        return reporter.getCollection();
    }

    private void parseDocumentFeatures(PDDocument document) {
        StandardSecurityHandler standardSecurityHandler;
        COSDocument cosDocument = document.getDocument();
        COSTrailer trailer = cosDocument.getTrailer();
        if (trailer != null) {
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createInfoDictFeaturesObject(trailer.getInfo()));
        }
        if ((standardSecurityHandler = cosDocument.getStandardSecurityHandler()) != null) {
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createDocSecurityFeaturesObject(standardSecurityHandler.getPdEncryption()));
        }
        try {
            PDCatalog catalog = document.getCatalog();
            if (catalog != null) {
                this.getCatalogFeatures(catalog);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Problem in parsing document catalog", e);
        }
        this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createLowLvlInfoFeaturesObject(cosDocument));
    }

    private void getCatalogFeatures(PDCatalog catalog) throws IOException {
        PDPageTree pageTree;
        PDAcroForm acroForm;
        PDNameTreeNode node;
        this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createMetadataFeaturesObject(catalog.getMetadata()));
        PDOutlineDictionary outlines = catalog.getOutlines();
        this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createOutlinesFeaturesObject(outlines));
        PDNamesDictionary namesDictionary = catalog.getNamesDictionary();
        if (this.config.isFeatureEnabled(FeatureObjectType.ACTION)) {
            Object javaScript;
            if (outlines != null) {
                this.reportOutlinesActions(outlines.getFirst());
            }
            this.reportAction(catalog.getOpenAction(), ActionFeaturesObjectAdapter.Location.DOCUMENT);
            PDCatalogAdditionalActions additionalActions = catalog.getAdditionalActions();
            if (additionalActions != null) {
                List actions = additionalActions.getActions();
                for (PDAction action : actions) {
                    this.reportAction(action, ActionFeaturesObjectAdapter.Location.DOCUMENT);
                }
            }
            if (namesDictionary != null && (javaScript = namesDictionary.getJavaScript()) != null) {
                this.reportJavaScripts((PDNameTreeNode)javaScript);
            }
        }
        if (this.config.isFeatureEnabled(FeatureObjectType.EMBEDDED_FILE) && namesDictionary != null && (node = namesDictionary.getEmbeddedFiles()) != null) {
            this.reportEmbeddedFileNode(node, 0);
        }
        if ((acroForm = catalog.getAcroForm()) != null) {
            this.getAcroFormFeatures(acroForm);
        }
        if (catalog.getOutputIntents() != null) {
            for (PDOutputIntent outInt : catalog.getOutputIntents()) {
                String iccProfileID = this.addICCProfileFromOutputIntent(outInt);
                if (!this.config.isFeatureEnabled(FeatureObjectType.ICCPROFILE)) {
                    iccProfileID = null;
                }
                this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createOutputIntentFeaturesObject(outInt, iccProfileID));
            }
        }
        if ((pageTree = catalog.getPageTree()) != null) {
            this.getPageTreeFeatures(pageTree, catalog.getPageLabels());
        }
    }

    private void reportOutlinesActions(PDOutlineItem outline) {
        if (outline != null) {
            this.reportAction(outline.getAction(), ActionFeaturesObjectAdapter.Location.OUTLINES);
            this.reportOutlinesActions(outline.getFirst());
            this.reportOutlinesActions(outline.getNext());
        }
    }

    private void reportAction(PDAction action, ActionFeaturesObjectAdapter.Location location) {
        if (action != null) {
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createActionFeaturesObject(action, location));
            for (PDAction next : action.getNext()) {
                this.reportAction(next, location);
            }
        }
    }

    private void getAcroFormFeatures(PDAcroForm acroForm) {
        List fields = acroForm.getFields();
        for (PDFormField field : fields) {
            this.getSignatureFeatures(field);
            this.getRootFormFieldFeatures(field);
        }
    }

    private void getRootFormFieldFeatures(PDFormField field) {
        if (field == null) {
            return;
        }
        if (this.config.isFeatureEnabled(FeatureObjectType.INTERACTIVE_FORM_FIELDS)) {
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createInteractiveFormFieldFeaturesObject(field));
        }
        if (this.config.isFeatureEnabled(FeatureObjectType.ACTION)) {
            this.getFormFieldActions(field);
        }
    }

    private void getFormFieldActions(PDFormField field) {
        PDFormFieldActions additionalActions = field.getActions();
        if (additionalActions != null) {
            List actions = additionalActions.getActions();
            for (PDAction action : actions) {
                this.reportAction(action, ActionFeaturesObjectAdapter.Location.INTERACTIVE_FORM_FIELD);
            }
        }
        for (PDFormField child : field.getChildFormFields()) {
            if (child == null) continue;
            this.getFormFieldActions(child);
        }
    }

    private void getSignatureFeatures(PDFormField field) {
        PDSignature signature;
        if (this.config.isFeatureEnabled(FeatureObjectType.SIGNATURE) && field.getFT() == ASAtom.SIG && (signature = ((PDSignatureField)field).getSignature()) != null) {
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createSignatureFeaturesObject(signature));
        }
    }

    private void getPageTreeFeatures(PDPageTree pageTree, PageLabels pageLabels) {
        for (int i = 0; i < pageTree.getPageCount(); ++i) {
            PDPage page = pageTree.getPage(i);
            this.reportPageActions(page);
            Set<String> annotsId = this.addAnnotsDependencies(page);
            annotsId = this.config.isFeatureEnabled(FeatureObjectType.ANNOTATION) ? annotsId : null;
            String thumbID = null;
            PDResources resources = page.getResources();
            COSObject thumb = page.getKey(ASAtom.THUMB);
            if (thumb != null && this.checkIDBeforeProcess(thumbID = this.getId(thumb, FeatureObjectType.IMAGE_XOBJECT))) {
                if (thumb.getType() == COSObjType.COS_STREAM) {
                    PDXImage img = new PDXImage(thumb, resources);
                    this.parseImageXObject(img, thumbID);
                } else {
                    this.xobjectCreationProblem(thumbID, "Thumb is not a stream");
                }
            }
            thumbID = this.config.isAnyFeatureEnabled(XOBJECTS) ? thumbID : null;
            Set<String> extGStateChild = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? this.parseExGStateFromResource(resources) : null;
            Set<String> colorSpaceChild = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? this.parseColorSpaceFromResources(resources) : null;
            Set<String> patternChild = this.config.isFeatureEnabled(FeatureObjectType.PATTERN) ? this.parsePatternFromResource(resources) : null;
            Set<String> shadingChild = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? this.parseShadingFromResource(resources) : null;
            Set<String> xobjectChild = this.config.isAnyFeatureEnabled(XOBJECTS) ? this.parseXObjectFromResources(resources) : null;
            Set<String> fontChild = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? this.parseFontFromResources(resources) : null;
            Set<String> propertiesChild = this.config.isFeatureEnabled(FeatureObjectType.PROPERTIES) ? this.parsePropertiesFromResources(resources) : null;
            int pageNumber = page.getPageNumber();
            String label = pageLabels == null ? null : pageLabels.getLabel(pageNumber);
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createPageFeaturesObject(page, label, thumbID, annotsId, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild, pageNumber));
        }
    }

    private void reportPageActions(PDPage page) {
        if (this.config.isFeatureEnabled(FeatureObjectType.ACTION)) {
            PDPageAdditionalActions additionalActions = page.getAdditionalActions();
            if (additionalActions != null) {
                List actions = additionalActions.getActions();
                for (PDAction action : actions) {
                    this.reportAction(action, ActionFeaturesObjectAdapter.Location.PAGE);
                }
            }
            HashSet<COSKey> visitedKeys = new HashSet<COSKey>();
            this.processNavigationNodeActions(page.getPresSteps(), visitedKeys);
        }
    }

    private void processNavigationNodeActions(PDNavigationNode navNode, Set<COSKey> visitedKeys) {
        if (navNode != null) {
            COSKey objectKey = navNode.getObject().getObjectKey();
            if (visitedKeys.contains(objectKey)) {
                return;
            }
            visitedKeys.add(objectKey);
            this.reportAction(navNode.getNA(), ActionFeaturesObjectAdapter.Location.PAGE);
            this.reportAction(navNode.getPA(), ActionFeaturesObjectAdapter.Location.PAGE);
            this.processNavigationNodeActions(navNode.getNext(), visitedKeys);
            this.processNavigationNodeActions(navNode.getPrev(), visitedKeys);
        }
    }

    private Set<String> addAnnotsDependencies(PDPage page) {
        HashSet<String> annotsId = new HashSet<String>();
        for (PDAnnotation annot : page.getAnnotations()) {
            this.reportAnnotationActions(annot);
            String id = this.getId(annot.getObject(), FeatureObjectType.ANNOTATION);
            annotsId.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            PDAnnotation popup = annot.getPopup();
            String popupID = null;
            if (popup != null) {
                popupID = this.addPopup(popup);
            }
            Set<String> formsIDs = this.getAnnotationResourcesDependencies(annot);
            popupID = this.config.isFeatureEnabled(FeatureObjectType.ANNOTATION) ? popupID : null;
            formsIDs = this.config.isAnyFeatureEnabled(XOBJECTS) ? formsIDs : null;
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createAnnotFeaturesObject(annot, id, popupID, formsIDs));
        }
        return annotsId;
    }

    private void reportAnnotationActions(PDAnnotation annot) {
        if (this.config.isFeatureEnabled(FeatureObjectType.ACTION) && annot != null) {
            this.reportAction(annot.getA(), ActionFeaturesObjectAdapter.Location.ANNOTATION);
            PDAnnotationAdditionalActions additionalActions = annot.getAdditionalActions();
            if (additionalActions != null) {
                List actions = additionalActions.getActions();
                for (PDAction action : actions) {
                    this.reportAction(action, ActionFeaturesObjectAdapter.Location.ANNOTATION);
                }
            }
        }
    }

    private String addPopup(PDAnnotation popup) {
        this.reportAnnotationActions(popup);
        String id = this.getId(popup.getObject(), FeatureObjectType.ANNOTATION);
        if (this.checkIDBeforeProcess(id)) {
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createAnnotFeaturesObject(popup, id, null, null));
        }
        return id;
    }

    private Set<String> getAnnotationResourcesDependencies(PDAnnotation annot) {
        PDAppearanceEntry downAppearance;
        PDAppearanceEntry rolloverAppearance;
        HashSet<String> appearances = new HashSet<String>();
        PDAppearanceEntry normalAppearance = annot.getNormalAppearance();
        if (normalAppearance != null) {
            appearances.addAll(this.getAppearanceEntryDependencies(normalAppearance));
        }
        if ((rolloverAppearance = annot.getRolloverAppearance()) != null) {
            appearances.addAll(this.getAppearanceEntryDependencies(rolloverAppearance));
        }
        if ((downAppearance = annot.getDownAppearance()) != null) {
            appearances.addAll(this.getAppearanceEntryDependencies(downAppearance));
        }
        return appearances;
    }

    private Set<String> getAppearanceEntryDependencies(PDAppearanceEntry entry) {
        HashSet<String> res = new HashSet<String>();
        if (entry.isSubDictionary()) {
            for (Map.Entry mapEntry : entry.getSubDictionary().entrySet()) {
                res.add(this.getAppearanceStreamDependencies((PDAppearanceStream)mapEntry.getValue()));
            }
        } else {
            res.add(this.getAppearanceStreamDependencies(entry.getAppearanceStream()));
        }
        return res;
    }

    private String getAppearanceStreamDependencies(PDAppearanceStream stream) {
        String id = this.getId(stream.getObject(), FeatureObjectType.FORM_XOBJECT);
        if (this.checkIDBeforeProcess(id)) {
            this.parseFormXObject((PDXForm)stream, id);
        }
        return id;
    }

    private void reportJavaScripts(PDNameTreeNode node) {
        Map names = node.getNames();
        for (COSObject value : names.values()) {
            if (value == null || !value.getType().isDictionaryBased()) continue;
            this.reportAction(new PDAction(value), ActionFeaturesObjectAdapter.Location.DOCUMENT);
        }
        for (PDNameTreeNode kid : node.getKids()) {
            this.reportJavaScripts(kid);
        }
    }

    private int reportEmbeddedFileNode(PDNameTreeNode node, int index) {
        int res = index;
        Map names = node.getNames();
        for (COSObject value : names.values()) {
            if (value == null || !value.getType().isDictionaryBased()) continue;
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createEmbeddedFileFeaturesObject(value, ++res));
        }
        for (PDNameTreeNode kid : node.getKids()) {
            res = this.reportEmbeddedFileNode(kid, res);
        }
        return res;
    }

    private String addICCProfileFromOutputIntent(PDOutputIntent outInt) {
        ICCProfile profile = outInt.getDestOutputProfile();
        if (profile != null) {
            String iccProfileID = this.getId(profile.getObject(), FeatureObjectType.ICCPROFILE);
            if (this.checkIDBeforeProcess(iccProfileID)) {
                this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createICCProfileFeaturesObject(profile, iccProfileID));
            }
            return iccProfileID;
        }
        return null;
    }

    private void xobjectCreationProblem(String nodeID, String errorMessage) {
        this.creationProblem(nodeID, errorMessage, FeatureObjectType.FORM_XOBJECT, false);
    }

    private void creationProblem(String nodeID, String errorMessage, FeatureObjectType type, boolean isTypeError) {
        if (this.config.isFeatureEnabled(type)) {
            if (!isTypeError) {
                FeatureTreeNode node = this.createNodeWithType(type);
                if (nodeID != null) {
                    node.setAttribute(ID, nodeID);
                }
                this.reporter.getCollection().addNewFeatureTree(type, node);
                ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)this.reporter.getCollection(), (FeatureTreeNode)node, (String)errorMessage);
            } else {
                String id = ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)this.reporter.getCollection(), null, (String)errorMessage);
                this.reporter.getCollection().addNewError(type, id);
            }
        }
    }

    private FeatureTreeNode createNodeWithType(FeatureObjectType type) {
        if (type == FeatureObjectType.FORM_XOBJECT) {
            FeatureTreeNode res = FeatureTreeNode.createRootNode((String)"xobject");
            res.setAttribute("type", "form");
            return res;
        }
        return FeatureTreeNode.createRootNode((String)type.getNodeName());
    }

    private Set<String> parseColorSpaceFromResources(PDResources resources) {
        if (resources == null || resources.getXObjectNames() == null) {
            return null;
        }
        HashSet<String> colorSpaceIDs = new HashSet<String>();
        for (ASAtom name : resources.getColorSpaceNames()) {
            PDColorSpace colorSpace = resources.getColorSpace(name);
            if (colorSpace == null) continue;
            String id = this.getId(colorSpace.getObject(), FeatureObjectType.COLORSPACE);
            id = GFFeatureParser.checkColorSpaceID(id, colorSpace);
            colorSpaceIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            this.parseColorSpace(colorSpace, id);
        }
        return colorSpaceIDs;
    }

    private Set<String> parseXObjectFromResources(PDResources resources) {
        if (resources == null || resources.getXObjectNames() == null) {
            return null;
        }
        HashSet<String> xobjectsIDs = new HashSet<String>();
        for (ASAtom name : resources.getXObjectNames()) {
            PDXObject xobj = resources.getXObject(name);
            if (xobj == null) continue;
            String id = this.getId(xobj.getObject(), FeatureObjectType.IMAGE_XOBJECT);
            xobjectsIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            if (xobj.getType() == ASAtom.IMAGE) {
                this.parseImageXObject((PDXImage)xobj, id);
                continue;
            }
            if (xobj.getType() == ASAtom.FORM) {
                this.parseFormXObject((PDXForm)xobj, id);
                continue;
            }
            if (xobj.getType() != ASAtom.PS) continue;
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createPostScriptXObjectFeaturesObject(id));
        }
        return xobjectsIDs;
    }

    private Set<String> parsePropertiesFromResources(PDResources resources) {
        if (resources == null || resources.getPropertiesNames() == null) {
            return null;
        }
        HashSet<String> propertiesIDs = new HashSet<String>();
        for (ASAtom name : resources.getPropertiesNames()) {
            COSObject propBase = resources.getKey(ASAtom.PROPERTIES);
            if (propBase.getType() != COSObjType.COS_DICT) continue;
            COSObject base = propBase.getKey(name);
            String id = this.getId(base, FeatureObjectType.PROPERTIES);
            propertiesIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createPropertiesDictFeaturesObject(base, id));
        }
        return propertiesIDs;
    }

    private Set<String> parseFontFromResources(PDResources resources) {
        if (resources == null || resources.getFontNames() == null) {
            return null;
        }
        HashSet<String> fontIDs = new HashSet<String>();
        for (ASAtom name : resources.getFontNames()) {
            PDFont font = resources.getFont(name);
            if (font == null) continue;
            String id = this.getId(font.getObject(), FeatureObjectType.FONT);
            fontIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            this.parseFont(font, id);
        }
        return fontIDs;
    }

    private Set<String> parseExGStateFromResource(PDResources resources) {
        if (resources == null || resources.getExtGStateNames() == null) {
            return null;
        }
        HashSet<String> gStatesIDs = new HashSet<String>();
        for (ASAtom name : resources.getExtGStateNames()) {
            PDExtGState exGState = resources.getExtGState(name);
            if (exGState == null) continue;
            String id = this.getId(exGState.getObject(), FeatureObjectType.EXT_G_STATE);
            gStatesIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            this.parseExGState(exGState, id);
        }
        return gStatesIDs;
    }

    private Set<String> parsePatternFromResource(PDResources resources) {
        if (resources == null || resources.getPatternNames() == null) {
            return null;
        }
        HashSet<String> patternIDs = new HashSet<String>();
        for (ASAtom name : resources.getPatternNames()) {
            PDPattern pattern = resources.getPattern(name);
            if (pattern == null) continue;
            String id = this.getId(pattern.getObject(), FeatureObjectType.PATTERN);
            patternIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            this.parsePattern(pattern, id);
        }
        return patternIDs;
    }

    private Set<String> parseShadingFromResource(PDResources resources) {
        if (resources == null || resources.getShadingNames() == null) {
            return null;
        }
        HashSet<String> shadingIDs = new HashSet<String>();
        for (ASAtom name : resources.getShadingNames()) {
            PDShading shading = resources.getShading(name);
            if (shading == null) continue;
            String id = this.getId(shading.getObject(), FeatureObjectType.SHADING);
            shadingIDs.add(id);
            if (!this.checkIDBeforeProcess(id)) continue;
            this.parseShading(shading, id);
        }
        return shadingIDs;
    }

    private void parseImageXObject(PDXImage xobj, String id) {
        COSObject baseColorSpace = xobj.getKey(ASAtom.CS);
        if (baseColorSpace.empty()) {
            baseColorSpace = xobj.getKey(ASAtom.COLORSPACE);
        }
        String idColorSpace = this.getId(baseColorSpace, FeatureObjectType.COLORSPACE);
        PDColorSpace colorSpace = ColorSpaceFactory.getColorSpace((COSObject)baseColorSpace);
        if (this.checkIDBeforeProcess(idColorSpace = GFFeatureParser.checkColorSpaceID(idColorSpace, colorSpace))) {
            this.parseColorSpace(colorSpace, idColorSpace);
        }
        String idMask = null;
        PDXImage xobjMask = xobj.getMask();
        if (xobjMask != null && this.checkIDBeforeProcess(idMask = this.getId(xobjMask.getObject(), FeatureObjectType.IMAGE_XOBJECT))) {
            this.parseImageXObject(xobjMask, idMask);
        }
        String idSMask = null;
        PDXImage xobjSMask = xobj.getSMask();
        if (xobjSMask != null && this.checkIDBeforeProcess(idSMask = this.getId(xobjSMask.getObject(), FeatureObjectType.IMAGE_XOBJECT))) {
            this.parseImageXObject(xobjSMask, idSMask);
        }
        HashSet<String> alternatesIDs = new HashSet<String>();
        for (PDXImage entry : xobj.getAlternates()) {
            String idImage = this.getId(entry.getObject(), FeatureObjectType.IMAGE_XOBJECT);
            alternatesIDs.add(idImage);
            if (!this.checkIDBeforeProcess(idImage)) continue;
            this.parseImageXObject(entry, idImage);
        }
        String string = idColorSpace = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? idColorSpace : null;
        if (!this.config.isAnyFeatureEnabled(XOBJECTS)) {
            idMask = null;
            idSMask = null;
            alternatesIDs = null;
        }
        this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createImageXObjectFeaturesObject(xobj, id, idColorSpace, idMask, idSMask, alternatesIDs));
    }

    private void parseFormXObject(PDXForm xobj, String id) {
        PDColorSpace colorSpace;
        PDGroup group = xobj.getGroup();
        String idColorSpace = null;
        if (group != null && ASAtom.TRANSPARENCY.equals((Object)group.getSubtype()) && (colorSpace = group.getColorSpace()) != null) {
            idColorSpace = this.getId(colorSpace.getObject(), FeatureObjectType.COLORSPACE);
            if (this.checkIDBeforeProcess(idColorSpace = GFFeatureParser.checkColorSpaceID(idColorSpace, colorSpace))) {
                this.parseColorSpace(colorSpace, idColorSpace);
            }
        }
        PDResources resources = xobj.getResources();
        Set<String> extGStateChild = this.parseExGStateFromResource(resources);
        extGStateChild = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? extGStateChild : null;
        Set<String> colorSpaceChild = this.parseColorSpaceFromResources(resources);
        if (!this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE)) {
            idColorSpace = null;
            colorSpaceChild = null;
        }
        Set<String> patternChild = this.config.isFeatureEnabled(FeatureObjectType.PATTERN) ? this.parsePatternFromResource(resources) : null;
        Set<String> shadingChild = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? this.parseShadingFromResource(resources) : null;
        Set<String> xobjectChild = this.config.isAnyFeatureEnabled(XOBJECTS) ? this.parseXObjectFromResources(resources) : null;
        Set<String> fontChild = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? this.parseFontFromResources(resources) : null;
        Set<String> propertiesChild = this.config.isFeatureEnabled(FeatureObjectType.PROPERTIES) ? this.parsePropertiesFromResources(resources) : null;
        this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createFormXObjectFeaturesObject(xobj, id, idColorSpace, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild));
    }

    private void parseExGState(PDExtGState exGState, String id) {
        String childFontID = null;
        PDFont font = exGState.getFont();
        if (font != null && this.checkIDBeforeProcess(childFontID = this.getId(font.getObject(), FeatureObjectType.FONT))) {
            this.parseFont(font, childFontID);
        }
        childFontID = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? childFontID : null;
        this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createExtGStateFeaturesObject(exGState, id, childFontID));
    }

    private void parsePattern(PDPattern pattern, String id) {
        if (pattern.getPatternType() == 1) {
            PDTilingPattern tilingPattern = (PDTilingPattern)pattern;
            PDResources resources = tilingPattern.getResources();
            Set<String> extGStateChild = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? this.parseExGStateFromResource(resources) : null;
            Set<String> colorSpaceChild = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? this.parseColorSpaceFromResources(resources) : null;
            Set<String> patternChild = this.config.isFeatureEnabled(FeatureObjectType.PATTERN) ? this.parsePatternFromResource(resources) : null;
            Set<String> shadingChild = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? this.parseShadingFromResource(resources) : null;
            Set<String> xobjectChild = this.config.isAnyFeatureEnabled(XOBJECTS) ? this.parseXObjectFromResources(resources) : null;
            Set<String> fontChild = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? this.parseFontFromResources(resources) : null;
            Set<String> propertiesChild = this.config.isFeatureEnabled(FeatureObjectType.PROPERTIES) ? this.parsePropertiesFromResources(resources) : null;
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createTilingPatternFeaturesObject(tilingPattern, id, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild));
        } else if (pattern.getPatternType() == 2) {
            PDShadingPattern shadingPattern = (PDShadingPattern)pattern;
            String shadingID = null;
            PDShading shading = shadingPattern.getShading();
            if (shading != null && this.checkIDBeforeProcess(shadingID = this.getId(shading.getObject(), FeatureObjectType.SHADING))) {
                this.parseShading(shading, shadingID);
            }
            String exGStateID = null;
            PDExtGState extGState = shadingPattern.getExtGState();
            if (extGState != null && this.checkIDBeforeProcess(exGStateID = this.getId(extGState.getObject(), FeatureObjectType.EXT_G_STATE))) {
                this.parseExGState(extGState, exGStateID);
            }
            shadingID = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? shadingID : null;
            exGStateID = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? exGStateID : null;
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createShadingPatternFeaturesObject(shadingPattern, id, shadingID, exGStateID));
        }
    }

    private void parseShading(PDShading shading, String id) {
        COSObject base = shading.getKey(ASAtom.CS);
        if (base.empty()) {
            base = shading.getKey(ASAtom.COLORSPACE);
        }
        String colorspaceID = this.getId(base, FeatureObjectType.COLORSPACE);
        PDColorSpace colorSpace = ColorSpaceFactory.getColorSpace((COSObject)base);
        if (this.checkIDBeforeProcess(colorspaceID = GFFeatureParser.checkColorSpaceID(colorspaceID, colorSpace))) {
            this.parseColorSpace(colorSpace, colorspaceID);
        }
        colorspaceID = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? colorspaceID : null;
        this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createShadingFeaturesObject(shading, id, colorspaceID));
    }

    private void parseFont(PDFont font, String id) {
        if (font.getSubtype() == ASAtom.TYPE3) {
            PDResources resources = ((PDType3Font)font).getResources();
            Set<String> extGStateChild = this.config.isFeatureEnabled(FeatureObjectType.EXT_G_STATE) ? this.parseExGStateFromResource(resources) : null;
            Set<String> colorSpaceChild = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? this.parseColorSpaceFromResources(resources) : null;
            Set<String> patternChild = this.config.isFeatureEnabled(FeatureObjectType.PATTERN) ? this.parsePatternFromResource(resources) : null;
            Set<String> shadingChild = this.config.isFeatureEnabled(FeatureObjectType.SHADING) ? this.parseShadingFromResource(resources) : null;
            Set<String> xobjectChild = this.config.isAnyFeatureEnabled(XOBJECTS) ? this.parseXObjectFromResources(resources) : null;
            Set<String> fontChild = this.config.isFeatureEnabled(FeatureObjectType.FONT) ? this.parseFontFromResources(resources) : null;
            Set<String> propertiesChild = this.config.isFeatureEnabled(FeatureObjectType.PROPERTIES) ? this.parsePropertiesFromResources(resources) : null;
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createFontFeaturesObject(font, id, extGStateChild, colorSpaceChild, patternChild, shadingChild, xobjectChild, fontChild, propertiesChild));
        } else if (font.getSubtype() == ASAtom.TYPE0) {
            PDType0Font type0 = (PDType0Font)font;
            COSObject descendantFontsBase = type0.getDescendantFontObject();
            if (descendantFontsBase != null) {
                String descendantID = this.getId(descendantFontsBase, FeatureObjectType.FONT);
                if (this.checkIDBeforeProcess(descendantID)) {
                    this.parseFont((PDFont)new PDCIDFont((COSDictionary)descendantFontsBase.getDirectBase(), type0.getCMap().getCMapFile()), descendantID);
                }
                HashSet<String> descendant = null;
                if (this.config.isFeatureEnabled(FeatureObjectType.FONT)) {
                    descendant = new HashSet<String>();
                    descendant.add(descendantID);
                }
                this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createFontFeaturesObject(font, id, null, null, null, null, null, descendant, null));
            }
        } else {
            this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createFontFeaturesObject(font, id, null, null, null, null, null, null, null));
        }
    }

    private void parseColorSpace(PDColorSpace colorSpace, String id) {
        String iccProfileID = null;
        String idAlt = null;
        ASAtom colorSpaceType = colorSpace.getType();
        if (colorSpaceType == ASAtom.ICCBASED) {
            PDColorSpace alternate;
            PDICCBased iccBased = (PDICCBased)colorSpace;
            ICCProfile iccProfile = iccBased.getICCProfile();
            if (iccProfile != null && this.checkIDBeforeProcess(iccProfileID = this.getId(iccProfile.getObject(), FeatureObjectType.ICCPROFILE))) {
                this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createICCProfileFeaturesObject(iccProfile, iccProfileID));
            }
            if ((alternate = iccBased.getAlternate()) != null) {
                idAlt = this.getId(alternate.getObject(), FeatureObjectType.COLORSPACE);
                if (this.checkIDBeforeProcess(idAlt = GFFeatureParser.checkColorSpaceID(idAlt, alternate))) {
                    this.parseColorSpace(alternate, idAlt);
                }
            }
        } else if (colorSpaceType == ASAtom.INDEXED || colorSpaceType == ASAtom.SEPARATION || colorSpaceType == ASAtom.DEVICEN) {
            int number = colorSpaceType == ASAtom.INDEXED ? 1 : 2;
            COSArray array = (COSArray)colorSpace.getObject().getDirectBase();
            COSObject base = array.at(number);
            idAlt = this.getId(base, FeatureObjectType.COLORSPACE);
            PDColorSpace alternate = ColorSpaceFactory.getColorSpace((COSObject)base);
            if (alternate != null && this.checkIDBeforeProcess(idAlt = GFFeatureParser.checkColorSpaceID(idAlt, alternate))) {
                this.parseColorSpace(alternate, idAlt);
            }
        }
        iccProfileID = this.config.isFeatureEnabled(FeatureObjectType.ICCPROFILE) ? iccProfileID : null;
        idAlt = this.config.isFeatureEnabled(FeatureObjectType.COLORSPACE) ? idAlt : null;
        this.reporter.report((FeaturesObject)GFFeaturesObjectCreator.createColorSpaceFeaturesObject(colorSpace, id, iccProfileID, idAlt));
    }

    private static String checkColorSpaceID(String prevID, PDColorSpace colorSpace) {
        if (colorSpace != null) {
            String id = prevID;
            ASAtom colorSpaceType = colorSpace.getType();
            if (colorSpaceType == ASAtom.DEVICEGRAY) {
                id = DEVICEGRAY_ID;
            } else if (colorSpaceType == ASAtom.DEVICERGB) {
                id = DEVICERGB_ID;
            } else if (colorSpaceType == ASAtom.DEVICECMYK) {
                id = DEVICECMYK_ID;
            }
            return id;
        }
        return null;
    }

    private String getId(COSObject base, FeatureObjectType objType) {
        if (base == null || base.empty()) {
            return null;
        }
        COSKey key = this.getObjectKey(base);
        long numb = this.processedIDs.size();
        String type = "Dir";
        if (key != null) {
            numb = key.getNumber();
            type = "Indir";
        }
        return objType.getIdPrefix() + type + numb;
    }

    private COSKey getObjectKey(COSObject base) {
        COSKey res = null;
        if (base.isIndirect().booleanValue()) {
            COSObject item = base;
            while (item.isIndirect().booleanValue()) {
                res = item.getObjectKey();
                item = base.getDirect();
            }
        } else {
            res = base.getObjectKey();
        }
        return res;
    }

    private boolean checkIDBeforeProcess(String id) {
        if (id == null || this.processedIDs.contains(id)) {
            return false;
        }
        this.processedIDs.add(id);
        return true;
    }
}

