/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSString;
import org.verapdf.features.objects.DocSecurityFeaturesObjectAdapter;
import org.verapdf.pd.encryption.AccessPermissions;
import org.verapdf.pd.encryption.PDEncryption;

public class GFDocSecurityFeaturesObjectAdapter
implements DocSecurityFeaturesObjectAdapter {
    private final PDEncryption encryption;

    public GFDocSecurityFeaturesObjectAdapter(PDEncryption encryption) {
        this.encryption = encryption;
    }

    public String getFilter() {
        if (this.encryption == null || this.encryption.empty()) {
            return null;
        }
        ASAtom filter = this.encryption.getFilter();
        return filter == null ? null : filter.getValue();
    }

    public String getSubFilter() {
        if (this.encryption == null || this.encryption.empty()) {
            return null;
        }
        ASAtom subFilter = this.encryption.getSubFilter();
        return subFilter == null ? null : subFilter.getValue();
    }

    public int getVersion() {
        return this.encryption == null || this.encryption.empty() ? 0 : this.encryption.getV();
    }

    public int getLength() {
        return this.encryption == null || this.encryption.empty() ? 0 : this.encryption.getLength();
    }

    public String getHexEncodedOwnerKey() {
        COSString ownerKey;
        if (this.encryption != null && !this.encryption.empty() && (ownerKey = this.encryption.getO()) != null) {
            return ownerKey.getHexString();
        }
        return null;
    }

    public String getHexEncodedUserKey() {
        COSString userKey;
        if (this.encryption != null && !this.encryption.empty() && (userKey = this.encryption.getU()) != null) {
            return userKey.getHexString();
        }
        return null;
    }

    public boolean isEncryptMetadata() {
        return this.encryption == null || this.encryption.empty() || this.encryption.isEncryptMetadata();
    }

    public boolean isUserPermissionsPresent() {
        return this.encryption != null && !this.encryption.empty() && this.encryption.getUserPermissions() != null;
    }

    public boolean isPrintAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canPrint();
        }
        return true;
    }

    public boolean isPrintDegradedAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canPrintDegraded();
        }
        return true;
    }

    public boolean isChangesAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canModify();
        }
        return true;
    }

    public boolean isModifyAnnotationsAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canModifyAnnotations();
        }
        return true;
    }

    public boolean isFillingSigningAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canFillInForm();
        }
        return true;
    }

    public boolean isDocumentAssemblyAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canAssembleDocument();
        }
        return true;
    }

    public boolean isExtractContentAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canExtractContent();
        }
        return true;
    }

    public boolean isExtractAccessibilityAllowed() {
        if (this.encryption != null && !this.encryption.empty()) {
            AccessPermissions perm = this.encryption.getUserPermissions();
            return perm == null || perm.canExtractForAccessibility();
        }
        return true;
    }

    public boolean isPDFObjectPresent() {
        return this.encryption != null && !this.encryption.empty();
    }

    public List<String> getErrors() {
        return Collections.emptyList();
    }
}

