/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.patterns;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;

public class PDPattern
extends PDColorSpace {
    public static final PDPattern INSTANCE = new PDPattern(COSName.construct(ASAtom.PATTERN));
    public static final int TYPE_PATTERN = 0;
    public static final int TYPE_TILING_PATTERN = 1;
    public static final int TYPE_SHADING_PATTERN = 2;
    private PDColorSpace underlyingColorSpace = null;

    protected PDPattern(COSObject obj) {
        super(obj);
    }

    private PDPattern(COSObject obj, PDColorSpace underlyingColorSpace) {
        super(obj);
        this.underlyingColorSpace = underlyingColorSpace;
    }

    public static PDPattern createPattern(COSObject underlyingColorSpace, PDResources resources) {
        if (underlyingColorSpace == null || underlyingColorSpace.empty()) {
            return INSTANCE;
        }
        return new PDPattern(COSName.construct(ASAtom.PATTERN), ColorSpaceFactory.getColorSpace(underlyingColorSpace, resources));
    }

    @Override
    public int getNumberOfComponents() {
        return -1;
    }

    @Override
    public ASAtom getType() {
        return ASAtom.PATTERN;
    }

    @Override
    public double[] toRGB(double[] value) {
        return null;
    }

    public int getPatternType() {
        return 0;
    }

    public PDColorSpace getUnderlyingColorSpace() {
        return this.underlyingColorSpace;
    }
}

