/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.constantPool;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.util.ByteVector;

public abstract class AttributeWriter {
    @Nonnull
    protected final ConstantPoolGeneration cp;
    @Nonnegative
    protected int attributeIndex;

    protected AttributeWriter(@Nonnull ConstantPoolGeneration cp) {
        this.cp = cp;
    }

    protected AttributeWriter(@Nonnull ConstantPoolGeneration cp, @Nonnull String attributeName) {
        this.cp = cp;
        this.setAttribute(attributeName);
    }

    protected final void setAttribute(@Nonnull String attributeName) {
        this.attributeIndex = this.cp.newUTF8(attributeName);
    }

    @Nonnegative
    public abstract int getSize();

    public void put(@Nonnull ByteVector out) {
        this.put(out, 2);
    }

    protected final void put(@Nonnull ByteVector out, @Nonnegative int size) {
        out.putShort(this.attributeIndex).putInt(size);
    }
}

