/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.methods;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.constantPool.AttributeWriter;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.util.ByteVector;

final class ExceptionsWriter
extends AttributeWriter {
    @Nonnull
    private final int[] exceptionIndices;

    ExceptionsWriter(@Nonnull ConstantPoolGeneration cp, @Nonnull String[] exceptionTypeDescs) {
        super(cp, "Exceptions");
        int n = exceptionTypeDescs.length;
        this.exceptionIndices = new int[n];
        for (int i = 0; i < n; ++i) {
            this.exceptionIndices[i] = cp.newClass(exceptionTypeDescs[i]);
        }
    }

    @Override
    @Nonnegative
    public int getSize() {
        return 8 + 2 * this.exceptionIndices.length;
    }

    @Override
    public void put(@Nonnull ByteVector out) {
        int n = this.exceptionIndices.length;
        this.put(out, 2 + 2 * n);
        out.putShort(n);
        for (int exceptionIndex : this.exceptionIndices) {
            out.putShort(exceptionIndex);
        }
    }
}

