/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.ReplayPhase;
import mockit.internal.expectations.UnorderedVerificationPhase;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.util.ClassLoad;

final class FullVerificationPhase
extends UnorderedVerificationPhase {
    @Nonnull
    private final Object[] mockedTypesAndInstancesToVerify;

    FullVerificationPhase(@Nonnull ReplayPhase replayPhase, @Nonnull Object[] mockedTypesAndInstancesToVerify) {
        super(replayPhase);
        this.mockedTypesAndInstancesToVerify = mockedTypesAndInstancesToVerify;
    }

    @Override
    @Nullable
    Error endVerification() {
        if (this.pendingError != null) {
            return this.pendingError;
        }
        List<Expectation> expectationsInReplayOrder = this.replayPhase.invocations;
        ArrayList<Expectation> notVerified = new ArrayList<Expectation>();
        int n = expectationsInReplayOrder.size();
        for (int i = 0; i < n; ++i) {
            Object[] replayArgs;
            Expectation replayExpectation = expectationsInReplayOrder.get(i);
            if (replayExpectation == null || !FullVerificationPhase.isEligibleForFullVerification(replayExpectation) || this.wasVerified(replayExpectation, replayArgs = this.replayPhase.invocationArguments.get(i), i)) continue;
            notVerified.add(replayExpectation);
        }
        if (!notVerified.isEmpty()) {
            if (this.mockedTypesAndInstancesToVerify.length == 0) {
                Expectation firstUnexpected = (Expectation)notVerified.get(0);
                return firstUnexpected.invocation.errorForUnexpectedInvocation();
            }
            return this.validateThatUnverifiedInvocationsAreAllowed(notVerified);
        }
        return null;
    }

    private static boolean isEligibleForFullVerification(@Nonnull Expectation replayExpectation) {
        return !replayExpectation.executedRealImplementation && replayExpectation.constraints.minInvocations <= 0;
    }

    private boolean wasVerified(@Nonnull Expectation replayExpectation, @Nonnull Object[] replayArgs, @Nonnegative int expectationIndex) {
        InvocationArguments invokedArgs = replayExpectation.invocation.arguments;
        List<VerifiedExpectation> verifiedExpectations = this.executionState.verifiedExpectations;
        for (VerifiedExpectation verified : verifiedExpectations) {
            if (verified.expectation != replayExpectation) continue;
            Object[] storedArgs = invokedArgs.prepareForVerification(verified.arguments, verified.argMatchers);
            boolean argumentsMatch = invokedArgs.isMatch(replayArgs, this.getInstanceMap());
            invokedArgs.setValuesWithNoMatchers(storedArgs);
            if (!argumentsMatch || !verified.matchesReplayIndex(expectationIndex)) continue;
            return true;
        }
        invokedArgs.setValuesWithNoMatchers(replayArgs);
        return false;
    }

    @Nullable
    private Error validateThatUnverifiedInvocationsAreAllowed(@Nonnull List<Expectation> unverified) {
        for (Expectation expectation : unverified) {
            ExpectedInvocation invocation = expectation.invocation;
            if (!this.isInvocationToBeVerified(invocation)) continue;
            return invocation.errorForUnexpectedInvocation();
        }
        return null;
    }

    private boolean isInvocationToBeVerified(@Nonnull ExpectedInvocation unverifiedInvocation) {
        String invokedClassName = unverifiedInvocation.getClassName();
        Object invokedInstance = unverifiedInvocation.instance;
        for (Object mockedTypeOrInstance : this.mockedTypesAndInstancesToVerify) {
            ClassLoader loader;
            Class invokedClass;
            Class mockedType;
            if (!(mockedTypeOrInstance instanceof Class ? invokedClassName.equals((mockedType = (Class)mockedTypeOrInstance).getName()) : (invokedInstance == null ? (invokedClass = ClassLoad.loadFromLoader(loader = mockedTypeOrInstance.getClass().getClassLoader(), invokedClassName)).isInstance(mockedTypeOrInstance) : (unverifiedInvocation.matchInstance ? mockedTypeOrInstance == invokedInstance : invokedInstance.getClass().isInstance(mockedTypeOrInstance))))) continue;
            return true;
        }
        return false;
    }
}

