/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Capturing;
import mockit.Injectable;
import mockit.Mocked;
import mockit.internal.expectations.MockingFilters;
import mockit.internal.expectations.state.CascadingTypes;
import mockit.internal.expectations.state.ExecutingTest;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.reflection.FieldReflection;
import mockit.internal.state.ParameterNames;
import mockit.internal.state.TestRun;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.TestMethod;
import mockit.internal.util.TypeConversion;
import mockit.internal.util.Utilities;

public final class MockedType
extends InjectionProvider {
    @Mocked
    private static final Object DUMMY = null;
    private static final int DUMMY_HASHCODE;
    @Nullable
    public final Field field;
    final boolean fieldFromTestClass;
    private final int accessModifiers;
    @Nullable
    private final Mocked mocked;
    @Nullable
    private final Capturing capturing;
    @Nullable
    private final Class<?> parameterImplementationClass;
    public final boolean injectable;
    @Nullable
    Object providedValue;

    public MockedType(@Nonnull Field field) {
        super(field.getGenericType(), field.getName());
        this.field = field;
        this.fieldFromTestClass = true;
        this.accessModifiers = field.getModifiers();
        this.mocked = field.getAnnotation(Mocked.class);
        this.capturing = field.getAnnotation(Capturing.class);
        this.parameterImplementationClass = null;
        Injectable injectableAnnotation = field.getAnnotation(Injectable.class);
        this.injectable = injectableAnnotation != null;
        this.providedValue = this.getProvidedInjectableValue(injectableAnnotation);
        this.registerCascadingAsNeeded();
    }

    @Nullable
    private Object getProvidedInjectableValue(@Nullable Injectable annotation) {
        Class<?> injectableClass;
        String value;
        if (annotation != null && !(value = annotation.value()).isEmpty() && (injectableClass = this.getClassType()) != TypeVariable.class) {
            return TypeConversion.convertFromString(injectableClass, value);
        }
        return null;
    }

    private void registerCascadingAsNeeded() {
        Type mockedType;
        if (this.isMockableType() && !((mockedType = this.declaredType) instanceof TypeVariable)) {
            ExecutingTest executingTest = TestRun.getExecutingTest();
            CascadingTypes types = executingTest.getCascadingTypes();
            types.add(this.fieldFromTestClass, mockedType);
        }
    }

    MockedType(@Nonnull TestMethod testMethod, @Nonnegative int paramIndex, @Nonnull Type parameterType, @Nonnull Annotation[] annotationsOnParameter, @Nullable Class<?> parameterImplementationClass) {
        super(parameterType, ParameterNames.getName(testMethod, paramIndex));
        Class parameterClass;
        this.field = null;
        this.fieldFromTestClass = false;
        this.accessModifiers = 0;
        this.mocked = MockedType.getAnnotation(annotationsOnParameter, Mocked.class);
        this.capturing = MockedType.getAnnotation(annotationsOnParameter, Capturing.class);
        this.parameterImplementationClass = parameterImplementationClass;
        Injectable injectableAnnotation = MockedType.getAnnotation(annotationsOnParameter, Injectable.class);
        this.injectable = injectableAnnotation != null;
        this.providedValue = this.getProvidedInjectableValue(injectableAnnotation);
        if (this.providedValue == null && parameterType instanceof Class && (parameterClass = (Class)parameterType).isPrimitive()) {
            this.providedValue = DefaultValues.defaultValueForPrimitiveType(parameterClass);
        }
        this.registerCascadingAsNeeded();
    }

    @Nullable
    private static <A extends Annotation> A getAnnotation(@Nonnull Annotation[] annotations, @Nonnull Class<A> annotation) {
        for (Annotation paramAnnotation : annotations) {
            if (paramAnnotation.annotationType() != annotation) continue;
            return (A)paramAnnotation;
        }
        return null;
    }

    MockedType(@Nonnull String cascadingMethodName, @Nonnull Type cascadedType) {
        super(cascadedType, cascadingMethodName);
        this.field = null;
        this.fieldFromTestClass = false;
        this.accessModifiers = 0;
        this.mocked = null;
        this.capturing = null;
        this.injectable = true;
        this.parameterImplementationClass = null;
    }

    @Override
    @Nonnull
    public Class<?> getClassOfDeclaredType() {
        return this.getClassType();
    }

    @Nonnull
    public Class<?> getClassType() {
        if (this.parameterImplementationClass != null) {
            return this.parameterImplementationClass;
        }
        Type mockedType = this.declaredType;
        if (mockedType instanceof Class) {
            return (Class)mockedType;
        }
        if (mockedType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)mockedType;
            return (Class)parameterizedType.getRawType();
        }
        return TypeVariable.class;
    }

    boolean isMockableType() {
        if (this.mocked == null && !this.injectable && this.capturing == null) {
            return false;
        }
        Class<?> classType = Utilities.getClassType(this.declaredType);
        if (MockedType.isUnmockableJREType(classType)) {
            return false;
        }
        MockingFilters.validateAsMockable(classType);
        if (this.injectable) {
            return !MockedType.isJREValueType(classType) && !classType.isEnum();
        }
        return true;
    }

    private static boolean isUnmockableJREType(@Nonnull Class<?> type) {
        return type.isPrimitive() || type.isArray() || type == Integer.class || type == String.class;
    }

    private static boolean isJREValueType(@Nonnull Class<?> type) {
        return type == String.class || type == Boolean.class || type == Character.class || Number.class.isAssignableFrom(type);
    }

    boolean isFinalFieldOrParameter() {
        return this.field == null || Modifier.isFinal(this.accessModifiers);
    }

    boolean withInstancesToCapture() {
        return this.capturing != null;
    }

    @Override
    @Nullable
    public Object getValue(@Nullable Object owner) {
        if (this.field == null) {
            return this.providedValue;
        }
        Object value = FieldReflection.getFieldValue(this.field, owner);
        if (!this.injectable) {
            return value;
        }
        Class<?> fieldType = this.field.getType();
        if (value == null) {
            if (this.providedValue != null) {
                return this.providedValue;
            }
            if (this.isFinalFieldOrParameter()) {
                return NULL;
            }
            if (fieldType == String.class) {
                return "";
            }
            return null;
        }
        if (this.providedValue == null) {
            return value;
        }
        if (!fieldType.isPrimitive()) {
            return value;
        }
        Object defaultValue = DefaultValues.defaultValueForPrimitiveType(fieldType);
        return value.equals(defaultValue) ? this.providedValue : value;
    }

    public int hashCode() {
        int h;
        int result = this.declaredType.hashCode();
        if (Modifier.isFinal(this.accessModifiers)) {
            result *= 31;
        }
        if (this.injectable) {
            result *= 37;
        }
        if (this.mocked != null && (h = this.mocked.hashCode()) != DUMMY_HASHCODE) {
            result = 31 * result + h;
        }
        return result;
    }

    static {
        int h = 0;
        try {
            Field dummyField = MockedType.class.getDeclaredField("DUMMY");
            Mocked mocked = dummyField.getAnnotation(Mocked.class);
            h = mocked.hashCode();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        DUMMY_HASHCODE = h;
    }
}

