/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.MetadataFeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.MetadataFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class MetadataFeaturesObject
extends FeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(MetadataFeaturesObject.class.getCanonicalName());
    private static final String METADATA = "metadata";

    public MetadataFeaturesObject(MetadataFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.METADATA;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        MetadataFeaturesObjectAdapter metadataAdapter = (MetadataFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(METADATA);
        try (InputStream stream = metadataAdapter.getData();){
            CreateNodeHelper.parseMetadata(stream, "xmpPackage", root, this);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error while obtaining unfiltered metadata stream", e);
            this.registerNewError(e.getMessage());
        }
        return root;
    }

    @Override
    public FeaturesData getData() {
        MetadataFeaturesObjectAdapter metadataAdapter = (MetadataFeaturesObjectAdapter)this.adapter;
        InputStream meta = metadataAdapter.getData();
        if (meta == null) {
            LOGGER.log(Level.FINE, "Missed metadata InputStream");
            return null;
        }
        return MetadataFeaturesData.newInstance(meta);
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Error IDs", MetadataFeaturesObject.generateAttributeXPath(METADATA, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

