/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.PostScriptFeaturesObjectAdapter;
import org.verapdf.features.tools.FeatureTreeNode;

public class PostScriptFeaturesObject
extends FeaturesObject {
    private static final String XOBJECT = "xobject";
    private static final String POSTSCRIPT = "postscript";
    private static final String XOBJECT_XPATH = "xobject[@type='postscript']";

    public PostScriptFeaturesObject(PostScriptFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.POSTSCRIPT_XOBJECT;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        PostScriptFeaturesObjectAdapter psAdapter = (PostScriptFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(XOBJECT);
        root.setAttribute("type", POSTSCRIPT);
        String id = psAdapter.getID();
        if (id != null) {
            root.setAttribute("id", id);
        }
        return root;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Error IDs", PostScriptFeaturesObject.generateAttributeXPath(XOBJECT_XPATH, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

