/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.axl.AXLExtensionSchemaField;
import org.verapdf.model.impl.axl.AXLExtensionSchemaObject;
import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.model.tools.xmp.validators.SimpleTypeValidator;
import org.verapdf.model.tools.xmp.validators.URITypeValidator;
import org.verapdf.model.xmplayer.ExtensionSchemaValueType;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class AXLExtensionSchemaValueType
extends AXLExtensionSchemaObject
implements ExtensionSchemaValueType {
    public static final String EXTENSION_SCHEMA_VALUE_TYPE = "ExtensionSchemaValueType";
    public static final String EXTENSION_SCHEMA_FIELDS = "ExtensionSchemaFields";
    private static final String NAMESPACE_URI = "namespaceURI";
    private static final String PREFIX = "prefix";
    private static final String FIELD = "field";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private static final Set<String> validChildNames = new HashSet<String>();

    public AXLExtensionSchemaValueType(VeraPDFXMPNode xmpNode, ValidatorsContainer containerForPDFA_1, ValidatorsContainer containerForPDFA_2_3, PDFAFlavour flavour) {
        super(EXTENSION_SCHEMA_VALUE_TYPE, xmpNode, containerForPDFA_1, containerForPDFA_2_3, flavour);
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "ExtensionSchemaFields": {
                return this.getExtensionSchemaFields();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AXLExtensionSchemaField> getExtensionSchemaFields() {
        if (this.xmpNode != null) {
            ArrayList<AXLExtensionSchemaField> res = new ArrayList<AXLExtensionSchemaField>();
            for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
                if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !FIELD.equals(child.getName())) continue;
                if (!child.getOptions().isArray()) break;
                for (VeraPDFXMPNode node : child.getChildren()) {
                    res.add(new AXLExtensionSchemaField(node, this.containerForPDFA_1, this.containerForPDFA_2_3, this.flavour));
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public Boolean getisDescriptionValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !DESCRIPTION.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisFieldValidSeq() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !FIELD.equals(child.getName())) continue;
            return child.getOptions().isArrayOrdered();
        }
        return Boolean.TRUE;
    }

    public Boolean getisNamespaceURIValidURI() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !NAMESPACE_URI.equals(child.getName())) continue;
            return new URITypeValidator().isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisPrefixValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !PREFIX.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisTypeValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !TYPE.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public String getdescriptionPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !DESCRIPTION.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getfieldPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !FIELD.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getnamespaceURIPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !NAMESPACE_URI.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getprefixPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !PREFIX.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String gettypePrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/type#".equals(child.getNamespaceURI()) || !TYPE.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    @Override
    protected String getValidNamespaceURI() {
        return "http://www.aiim.org/pdfa/ns/type#";
    }

    @Override
    protected Set<String> getValidChildNames() {
        return validChildNames;
    }

    static {
        validChildNames.add(NAMESPACE_URI);
        validChildNames.add(PREFIX);
        validChildNames.add(FIELD);
        validChildNames.add(DESCRIPTION);
        validChildNames.add(TYPE);
    }
}

