/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.verapdf.pdfa.AbstractFoundry;
import org.verapdf.pdfa.VeraFoundryProvider;
import org.verapdf.pdfa.VeraPDFFoundry;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class Foundries {
    private static final Map<URI, VeraFoundryProvider> providers = new ConcurrentHashMap<URI, VeraFoundryProvider>();
    public static final URI DEFAULT_PROVIDER_ID = URI.create("http://foundry.verapdf.org#default");

    private Foundries() {
    }

    public static void registerDefaultProvider(VeraFoundryProvider provider) {
        Foundries.registerProvider(DEFAULT_PROVIDER_ID, provider);
    }

    public static void registerProvider(URI id, VeraFoundryProvider provider) {
        if (provider == null) {
            throw new NullPointerException("Argument provider can not be null");
        }
        providers.put(id, provider);
    }

    public static VeraPDFFoundry defaultInstance() {
        return Foundries.newInstance(DEFAULT_PROVIDER_ID);
    }

    public static VeraPDFFoundry newInstance(URI id) {
        VeraFoundryProvider provider = providers.get(id);
        if (provider == null) {
            throw new IllegalArgumentException("No provider with URI:" + id);
        }
        return provider.getInstance();
    }

    public static Set<URI> getProviderIds() {
        return Collections.unmodifiableSet(providers.keySet());
    }

    public void setDefaultFlavour(PDFAFlavour defaultFlavour) {
        if (defaultFlavour != PDFAFlavour.NO_FLAVOUR) {
            AbstractFoundry.defaultFlavour = defaultFlavour;
        }
    }

    public static boolean defaultParserIsPDFBox() {
        VeraFoundryProvider provider = providers.get(DEFAULT_PROVIDER_ID);
        return provider != null && "PDFBox".equals(provider.getInstance().getParserId());
    }
}

