/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.filesystem;

import fi.kanta.common.components.LogHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ListSubDirectories {
    private Logger log4j = Logger.getLogger(ListSubDirectories.class);
    private LogHelper logHelper;
    private String logId;

    public ListSubDirectories(String logId) {
        this.logId = logId;
        this.logHelper = new LogHelper();
    }

    public List<String> listDirs(String path, String filename) throws IOException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)("Aineiston haku aloitetaan hakemistosta: " + path));
        }
        ArrayList<String> directories = new ArrayList<String>();
        File currentDir = new File(path);
        File[] files = null;
        if (currentDir.isDirectory()) {
            files = currentDir.listFiles();
            File candidate = null;
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        candidate = new File(file.getPath() + File.separatorChar + filename);
                        if (candidate.exists()) {
                            if (this.log4j.isDebugEnabled()) {
                                this.log4j.debug((Object)("L\u00f6ytyi hakemisto, jossa on koontitiedosto: " + file.getPath()));
                            }
                            directories.add(file.getPath());
                            continue;
                        }
                        directories.addAll(this.listDirs(file.getPath(), filename));
                        continue;
                    }
                    if (!file.getName().equals(filename)) continue;
                    directories.add(file.getParent());
                }
            } else {
                this.log4j.error((Object)("Hakemiston sis\u00e4lt\u00f6\u00e4 ei saatu listattua: " + currentDir.getPath()));
            }
        } else {
            this.log4j.error((Object)"Annettu polku ei ole hakemisto");
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        return directories;
    }
}

