/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.FastIntBuffer;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.IndexReadException;
import com.ximpleware.IndexWriteException;
import com.ximpleware.VTDGen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class IndexHandler {
    public static final int OFFSET_ADJUSTMENT = 32;

    IndexHandler() {
    }

    public static void writeIndex_L3(byte version2, int encodingType, boolean ns, boolean byteOrder, int nestDepth, int LCLevel, int rootIndex, byte[] xmlDoc, int docOffset, int docLen, FastLongBuffer vtdBuffer, FastLongBuffer l1Buffer, FastLongBuffer l2Buffer, FastIntBuffer l3Buffer, OutputStream os) throws IndexWriteException, IOException {
        int i;
        if (xmlDoc == null || docLen <= 0 || vtdBuffer == null || l1Buffer == null || l2Buffer == null || l3Buffer == null || LCLevel != 3) {
            throw new IndexWriteException("Invalid VTD index ");
        }
        if (vtdBuffer.size() == 0) {
            throw new IndexWriteException("VTDBuffer can't be zero length");
        }
        DataOutputStream dos = new DataOutputStream(os);
        byte[] ba = new byte[]{version2, (byte)encodingType, (byte)(ns ? 224 : 160), (byte)nestDepth};
        dos.write(ba);
        ba[0] = 0;
        ba[1] = 4;
        ba[2] = (byte)((rootIndex & 0xFF00) >> 8);
        ba[3] = (byte)(rootIndex & 0xFF);
        dos.write(ba);
        ba[3] = 0;
        ba[2] = 0;
        ba[1] = 0;
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.writeLong(docLen);
        dos.write(xmlDoc, docOffset, docLen);
        if ((docLen & 7) != 0) {
            for (int t = ((docLen >> 3) + 1 << 3) - docLen; t > 0; --t) {
                dos.write(0);
            }
        }
        dos.writeLong(vtdBuffer.size);
        if (docOffset == 0) {
            for (i = 0; i < vtdBuffer.size; ++i) {
                dos.writeLong(vtdBuffer.longAt(i));
            }
        } else {
            for (i = 0; i < vtdBuffer.size; ++i) {
                dos.writeLong(IndexHandler.adjust(vtdBuffer.longAt(i), -docOffset));
            }
        }
        dos.writeLong(l1Buffer.size);
        for (i = 0; i < l1Buffer.size; ++i) {
            dos.writeLong(l1Buffer.longAt(i));
        }
        dos.writeLong(l2Buffer.size);
        for (i = 0; i < l2Buffer.size; ++i) {
            dos.writeLong(l2Buffer.longAt(i));
        }
        dos.writeLong(l3Buffer.size);
        for (i = 0; i < l3Buffer.size; ++i) {
            dos.writeInt(l3Buffer.intAt(i));
        }
        if ((l3Buffer.size & 1) != 0) {
            dos.writeInt(0);
        }
        dos.close();
    }

    public static void writeIndex_L5(byte version2, int encodingType, boolean ns, boolean byteOrder, int nestDepth, int LCLevel, int rootIndex, byte[] xmlDoc, int docOffset, int docLen, FastLongBuffer vtdBuffer, FastLongBuffer l1Buffer, FastLongBuffer l2Buffer, FastLongBuffer l3Buffer, FastLongBuffer l4Buffer, FastIntBuffer l5Buffer, OutputStream os) throws IndexWriteException, IOException {
        int i;
        if (xmlDoc == null || docLen <= 0 || vtdBuffer == null || l1Buffer == null || l2Buffer == null || l3Buffer == null || l4Buffer == null || l5Buffer == null || LCLevel != 5) {
            throw new IndexWriteException("Invalid VTD index ");
        }
        if (vtdBuffer.size == 0) {
            throw new IndexWriteException("VTDBuffer can't be zero length");
        }
        DataOutputStream dos = new DataOutputStream(os);
        byte[] ba = new byte[]{version2, (byte)encodingType, (byte)(ns ? 224 : 160), (byte)nestDepth};
        dos.write(ba);
        ba[0] = 0;
        ba[1] = 6;
        ba[2] = (byte)((rootIndex & 0xFF00) >> 8);
        ba[3] = (byte)(rootIndex & 0xFF);
        dos.write(ba);
        ba[3] = 0;
        ba[2] = 0;
        ba[1] = 0;
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.writeLong(docLen);
        dos.write(xmlDoc, docOffset, docLen);
        if ((docLen & 7) != 0) {
            for (int t = ((docLen >> 3) + 1 << 3) - docLen; t > 0; --t) {
                dos.write(0);
            }
        }
        dos.writeLong(vtdBuffer.size);
        if (docOffset == 0) {
            for (i = 0; i < vtdBuffer.size; ++i) {
                dos.writeLong(vtdBuffer.longAt(i));
            }
        } else {
            for (i = 0; i < vtdBuffer.size; ++i) {
                dos.writeLong(IndexHandler.adjust(vtdBuffer.longAt(i), -docOffset));
            }
        }
        dos.writeLong(l1Buffer.size);
        for (i = 0; i < l1Buffer.size; ++i) {
            dos.writeLong(l1Buffer.longAt(i));
        }
        dos.writeLong(l2Buffer.size);
        for (i = 0; i < l2Buffer.size; ++i) {
            dos.writeLong(l2Buffer.longAt(i));
        }
        dos.writeLong(l3Buffer.size);
        for (i = 0; i < l3Buffer.size; ++i) {
            dos.writeLong(l3Buffer.longAt(i));
        }
        dos.writeLong(l4Buffer.size);
        for (i = 0; i < l4Buffer.size; ++i) {
            dos.writeLong(l4Buffer.longAt(i));
        }
        dos.writeLong(l5Buffer.size);
        for (i = 0; i < l5Buffer.size; ++i) {
            dos.writeInt(l5Buffer.intAt(i));
        }
        if ((l5Buffer.size & 1) != 0) {
            dos.writeInt(0);
        }
        dos.close();
    }

    public static void writeSeparateIndex_L3(byte version2, int encodingType, boolean ns, boolean byteOrder, int nestDepth, int LCLevel, int rootIndex, int docOffset, int docLen, FastLongBuffer vtdBuffer, FastLongBuffer l1Buffer, FastLongBuffer l2Buffer, FastIntBuffer l3Buffer, OutputStream os) throws IndexWriteException, IOException {
        int i;
        if (docLen <= 0 || vtdBuffer == null || l1Buffer == null || l2Buffer == null || l3Buffer == null || LCLevel != 3) {
            throw new IndexWriteException("Invalid VTD index ");
        }
        if (vtdBuffer.size == 0) {
            throw new IndexWriteException("VTDBuffer can't be zero length");
        }
        DataOutputStream dos = new DataOutputStream(os);
        byte[] ba = new byte[]{version2, (byte)encodingType, (byte)(ns ? 224 : 160), (byte)nestDepth};
        dos.write(ba);
        ba[0] = 0;
        ba[1] = 4;
        ba[2] = (byte)((rootIndex & 0xFF00) >> 8);
        ba[3] = (byte)(rootIndex & 0xFF);
        dos.write(ba);
        ba[3] = 0;
        ba[2] = 0;
        ba[1] = 0;
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.writeLong(docLen);
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.writeLong(vtdBuffer.size);
        if (docOffset == 0) {
            for (i = 0; i < vtdBuffer.size; ++i) {
                dos.writeLong(vtdBuffer.longAt(i));
            }
        } else {
            for (i = 0; i < vtdBuffer.size; ++i) {
                dos.writeLong(IndexHandler.adjust(vtdBuffer.longAt(i), -docOffset));
            }
        }
        dos.writeLong(l1Buffer.size);
        for (i = 0; i < l1Buffer.size; ++i) {
            dos.writeLong(l1Buffer.longAt(i));
        }
        dos.writeLong(l2Buffer.size);
        for (i = 0; i < l2Buffer.size(); ++i) {
            dos.writeLong(l2Buffer.longAt(i));
        }
        dos.writeLong(l3Buffer.size);
        for (i = 0; i < l3Buffer.size; ++i) {
            dos.writeInt(l3Buffer.intAt(i));
        }
        if ((l3Buffer.size & 1) != 0) {
            dos.writeInt(0);
        }
        dos.close();
    }

    public static void writeSeparateIndex_L5(byte version2, int encodingType, boolean ns, boolean byteOrder, int nestDepth, int LCLevel, int rootIndex, int docOffset, int docLen, FastLongBuffer vtdBuffer, FastLongBuffer l1Buffer, FastLongBuffer l2Buffer, FastLongBuffer l3Buffer, FastLongBuffer l4Buffer, FastIntBuffer l5Buffer, OutputStream os) throws IndexWriteException, IOException {
        int i;
        if (docLen <= 0 || vtdBuffer == null || l1Buffer == null || l2Buffer == null || l3Buffer == null || l4Buffer == null || l5Buffer == null || LCLevel != 5) {
            throw new IndexWriteException("Invalid VTD index ");
        }
        if (vtdBuffer.size == 0) {
            throw new IndexWriteException("VTDBuffer can't be zero length");
        }
        DataOutputStream dos = new DataOutputStream(os);
        byte[] ba = new byte[]{version2, (byte)encodingType, (byte)(ns ? 224 : 160), (byte)nestDepth};
        dos.write(ba);
        ba[0] = 0;
        ba[1] = 6;
        ba[2] = (byte)((rootIndex & 0xFF00) >> 8);
        ba[3] = (byte)(rootIndex & 0xFF);
        dos.write(ba);
        ba[3] = 0;
        ba[2] = 0;
        ba[1] = 0;
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.writeLong(docLen);
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.write(ba);
        dos.writeLong(vtdBuffer.size);
        if (docOffset == 0) {
            for (i = 0; i < vtdBuffer.size; ++i) {
                dos.writeLong(vtdBuffer.longAt(i));
            }
        } else {
            for (i = 0; i < vtdBuffer.size; ++i) {
                dos.writeLong(IndexHandler.adjust(vtdBuffer.longAt(i), -docOffset));
            }
        }
        dos.writeLong(l1Buffer.size);
        for (i = 0; i < l1Buffer.size; ++i) {
            dos.writeLong(l1Buffer.longAt(i));
        }
        dos.writeLong(l2Buffer.size);
        for (i = 0; i < l2Buffer.size(); ++i) {
            dos.writeLong(l2Buffer.longAt(i));
        }
        dos.writeLong(l3Buffer.size);
        for (i = 0; i < l3Buffer.size; ++i) {
            dos.writeLong(l3Buffer.longAt(i));
        }
        dos.writeLong(l4Buffer.size);
        for (i = 0; i < l4Buffer.size; ++i) {
            dos.writeLong(l4Buffer.longAt(i));
        }
        dos.writeLong(l5Buffer.size);
        for (i = 0; i < l5Buffer.size; ++i) {
            dos.writeInt(l5Buffer.intAt(i));
        }
        if ((l5Buffer.size & 1) != 0) {
            dos.writeInt(0);
        }
        dos.close();
    }

    public static void readIndex(byte[] ba, VTDGen vg) throws IndexReadException {
        if (ba == null || vg == null) {
            throw new IllegalArgumentException("Invalid argument(s) for readIndex()");
        }
        ByteBuffer bb = ByteBuffer.wrap(ba);
        byte b = bb.get();
        if (b != 1) {
            throw new IndexReadException("Invalid version number for readIndex()");
        }
        vg.encoding = bb.get();
        int adj = 32;
        if (vg.encoding >= 63) {
            adj = 16;
        }
        boolean intLongSwitch = ((b = bb.get()) & 0x80) != 0;
        vg.ns = (b & 0x40) != 0;
        boolean endian = (b & 0x20) != 0;
        if ((b & 0x1F) != 0) {
            throw new IndexReadException("Last 5 bits of the third byte should be zero");
        }
        vg.VTDDepth = bb.get();
        int LCLevel = bb.get() << 8 | bb.get();
        if (LCLevel != 4 && LCLevel != 6) {
            throw new IndexReadException("LC levels must be at least 3");
        }
        vg.shallowDepth = LCLevel == 4;
        vg.rootIndex = bb.get() << 8 | bb.get();
        bb.getLong();
        bb.getLong();
        int size = 0;
        size = endian ? (int)bb.getLong() : (int)IndexHandler.reverseLong(bb.getLong());
        int t = 0;
        if ((size & 7) != 0) {
            t = ((size >> 3) + 1 << 3) - size;
        }
        vg.setDoc_BR(ba, 32, size);
        bb = ByteBuffer.wrap(ba, 32 + size + t, ba.length - 32 - size - t);
        if (endian) {
            int l3Size;
            for (int vtdSize = (int)bb.getLong(); vtdSize > 0; --vtdSize) {
                vg.VTDBuffer.append(IndexHandler.adjust(bb.getLong(), adj));
            }
            for (int l1Size = (int)bb.getLong(); l1Size > 0; --l1Size) {
                long l = bb.getLong();
                vg.l1Buffer.append(l);
            }
            for (int l2Size = (int)bb.getLong(); l2Size > 0; --l2Size) {
                vg.l2Buffer.append(bb.getLong());
            }
            if (vg.shallowDepth) {
                if (intLongSwitch) {
                    for (l3Size = (int)bb.getLong(); l3Size > 0; --l3Size) {
                        vg.l3Buffer.append(bb.getInt());
                    }
                } else {
                    while (l3Size > 0) {
                        vg.l3Buffer.append((int)(bb.getLong() >> 32));
                        --l3Size;
                    }
                }
            } else {
                int l5Size;
                while (l3Size > 0) {
                    vg._l3Buffer.append(bb.getLong());
                    --l3Size;
                }
                for (int l4Size = (int)bb.getLong(); l4Size > 0; --l4Size) {
                    vg._l4Buffer.append(bb.getLong());
                }
                if (intLongSwitch) {
                    for (l5Size = (int)bb.getLong(); l5Size > 0; --l5Size) {
                        vg._l5Buffer.append(bb.getInt());
                    }
                } else {
                    while (l5Size > 0) {
                        vg._l5Buffer.append((int)(bb.getLong() >> 32));
                        --l5Size;
                    }
                }
            }
        } else {
            int l3Size;
            for (int vtdSize = (int)IndexHandler.reverseLong(bb.getLong()); vtdSize > 0; --vtdSize) {
                vg.VTDBuffer.append(IndexHandler.adjust(IndexHandler.reverseLong(bb.getLong()), adj));
            }
            for (int l1Size = (int)IndexHandler.reverseLong(bb.getLong()); l1Size > 0; --l1Size) {
                long l = IndexHandler.reverseLong(bb.getLong());
                vg.l1Buffer.append(l);
            }
            for (int l2Size = (int)IndexHandler.reverseLong(bb.getLong()); l2Size > 0; --l2Size) {
                long l = IndexHandler.reverseLong(bb.getLong());
                vg.l2Buffer.append(l);
            }
            if (vg.shallowDepth) {
                if (intLongSwitch) {
                    for (l3Size = (int)IndexHandler.reverseLong(bb.getLong()); l3Size > 0; --l3Size) {
                        vg.l3Buffer.append(IndexHandler.reverseInt(bb.getInt()));
                    }
                } else {
                    while (l3Size > 0) {
                        vg.l3Buffer.append(IndexHandler.reverseInt((int)(bb.getLong() >> 32)));
                        --l3Size;
                    }
                }
            } else {
                int l5Size;
                while (l3Size > 0) {
                    vg._l3Buffer.append(IndexHandler.reverseLong(bb.getLong()));
                    --l3Size;
                }
                for (int l4Size = (int)IndexHandler.reverseLong(bb.getLong()); l4Size > 0; --l4Size) {
                    vg._l4Buffer.append(IndexHandler.reverseLong(bb.getLong()));
                }
                if (intLongSwitch) {
                    for (l5Size = (int)IndexHandler.reverseLong(bb.getLong()); l5Size > 0; --l5Size) {
                        vg._l5Buffer.append(IndexHandler.reverseInt(bb.getInt()));
                    }
                } else {
                    while (l5Size > 0) {
                        vg._l5Buffer.append(IndexHandler.reverseInt((int)(bb.getLong() >> 32)));
                        --l5Size;
                    }
                }
            }
        }
    }

    public static void readIndex(InputStream is, VTDGen vg) throws IndexReadException, IOException {
        int vtdSize;
        if (is == null || vg == null) {
            throw new IndexReadException("Invalid argument(s) for readIndex()");
        }
        DataInputStream dis = new DataInputStream(is);
        byte b = dis.readByte();
        if (b != 1) {
            throw new IndexReadException("Invalid version number for readIndex()");
        }
        vg.encoding = dis.readByte();
        b = dis.readByte();
        boolean intLongSwitch = (b & 0x80) != 0;
        vg.ns = (b & 0x40) != 0;
        boolean endian = (b & 0x20) != 0;
        if ((b & 0x1F) != 0) {
            throw new IndexReadException("Last 5 bits of the third byte should be zero");
        }
        vg.VTDDepth = dis.readByte();
        int LCLevel = dis.readByte() << 8 | dis.readByte();
        if (LCLevel != 4 && LCLevel != 6) {
            throw new IndexReadException("LC levels must be at least 3");
        }
        vg.shallowDepth = LCLevel == 4;
        vg.rootIndex = dis.readByte() << 8 | dis.readByte();
        dis.readLong();
        dis.readLong();
        int size = 0;
        size = endian ? (int)dis.readLong() : (int)IndexHandler.reverseLong(dis.readLong());
        byte[] XMLDoc = new byte[size];
        dis.read(XMLDoc);
        if ((size & 7) != 0) {
            for (int t = ((size >> 3) + 1 << 3) - size; t > 0; --t) {
                dis.readByte();
            }
        }
        vg.setDoc(XMLDoc);
        if (endian) {
            int l3Size;
            for (vtdSize = (int)dis.readLong(); vtdSize > 0; --vtdSize) {
                vg.VTDBuffer.append(dis.readLong());
            }
            for (int l1Size = (int)dis.readLong(); l1Size > 0; --l1Size) {
                long l = dis.readLong();
                vg.l1Buffer.append(l);
            }
            for (int l2Size = (int)dis.readLong(); l2Size > 0; --l2Size) {
                vg.l2Buffer.append(dis.readLong());
            }
            if (vg.shallowDepth) {
                if (intLongSwitch) {
                    for (l3Size = (int)dis.readLong(); l3Size > 0; --l3Size) {
                        vg.l3Buffer.append(dis.readInt());
                    }
                } else {
                    while (l3Size > 0) {
                        vg.l3Buffer.append((int)(dis.readLong() >> 32));
                        --l3Size;
                    }
                }
            } else {
                int l5Size;
                while (l3Size > 0) {
                    vg._l3Buffer.append(dis.readLong());
                    --l3Size;
                }
                for (int l4Size = (int)dis.readLong(); l4Size > 0; --l4Size) {
                    vg._l4Buffer.append(dis.readLong());
                }
                if (intLongSwitch) {
                    for (l5Size = (int)dis.readLong(); l5Size > 0; --l5Size) {
                        vg._l5Buffer.append(dis.readInt());
                    }
                } else {
                    while (l5Size > 0) {
                        vg._l5Buffer.append((int)(dis.readLong() >> 32));
                        --l5Size;
                    }
                }
            }
        } else {
            int l3Size;
            for (vtdSize = (int)IndexHandler.reverseLong(dis.readLong()); vtdSize > 0; --vtdSize) {
                vg.VTDBuffer.append(IndexHandler.reverseLong(dis.readLong()));
            }
            for (int l1Size = (int)IndexHandler.reverseLong(dis.readLong()); l1Size > 0; --l1Size) {
                long l = IndexHandler.reverseLong(dis.readLong());
                vg.l1Buffer.append(l);
            }
            for (int l2Size = (int)IndexHandler.reverseLong(dis.readLong()); l2Size > 0; --l2Size) {
                long l = IndexHandler.reverseLong(dis.readLong());
                vg.l2Buffer.append(l);
            }
            if (vg.shallowDepth) {
                if (intLongSwitch) {
                    for (l3Size = (int)IndexHandler.reverseLong(dis.readLong()); l3Size > 0; --l3Size) {
                        vg.l3Buffer.append(IndexHandler.reverseInt(dis.readInt()));
                    }
                } else {
                    while (l3Size > 0) {
                        vg.l3Buffer.append(IndexHandler.reverseInt((int)(dis.readLong() >> 32)));
                        --l3Size;
                    }
                }
            } else {
                int l5Size;
                while (l3Size > 0) {
                    vg._l3Buffer.append(IndexHandler.reverseLong(dis.readLong()));
                    --l3Size;
                }
                for (int l4Size = (int)IndexHandler.reverseLong(dis.readLong()); l4Size > 0; --l4Size) {
                    long l = IndexHandler.reverseLong(dis.readLong());
                    vg._l4Buffer.append(l);
                }
                if (intLongSwitch) {
                    for (l5Size = (int)IndexHandler.reverseLong(dis.readLong()); l5Size > 0; --l5Size) {
                        vg._l5Buffer.append(IndexHandler.reverseInt(dis.readInt()));
                    }
                } else {
                    while (l5Size > 0) {
                        vg._l5Buffer.append(IndexHandler.reverseInt((int)(dis.readLong() >> 32)));
                        --l5Size;
                    }
                }
            }
        }
    }

    public static void readSeparateIndex(InputStream index, InputStream XMLBytes, int XMLSize, VTDGen vg) throws IndexReadException, IOException {
        if (index == null || vg == null || XMLBytes == null) {
            throw new IndexReadException("Invalid argument(s) for readSeparateIndex()");
        }
        DataInputStream dis = new DataInputStream(index);
        byte b = dis.readByte();
        if (b != 2) {
            throw new IndexReadException("Invalid version number for readIndex()");
        }
        vg.encoding = dis.readByte();
        b = dis.readByte();
        boolean intLongSwitch = (b & 0x80) != 0;
        vg.ns = (b & 0x40) != 0;
        boolean endian = (b & 0x20) != 0;
        if ((b & 0x1F) != 0) {
            throw new IndexReadException("Last 5 bits of the third byte should be zero");
        }
        vg.VTDDepth = dis.readByte();
        int LCLevel = dis.readByte() << 8 | dis.readByte();
        if (LCLevel != 4 && LCLevel != 6) {
            throw new IndexReadException("LC levels must be at least 3");
        }
        vg.shallowDepth = LCLevel == 4;
        vg.rootIndex = dis.readByte() << 8 | dis.readByte();
        dis.readLong();
        dis.readLong();
        int size = 0;
        size = endian ? (int)dis.readLong() : (int)IndexHandler.reverseLong(dis.readLong());
        if (size != XMLSize) {
            throw new IndexReadException("XML size mismatch");
        }
        byte[] XMLDoc = new byte[size];
        XMLBytes.read(XMLDoc);
        vg.setDoc(XMLDoc);
        dis.readLong();
        dis.readLong();
        if (endian) {
            int l3Size;
            int l2Size;
            for (int vtdSize = (int)dis.readLong(); vtdSize > 0; --vtdSize) {
                vg.VTDBuffer.append(dis.readLong());
            }
            for (int l1Size = (int)dis.readLong(); l1Size > 0; --l1Size) {
                long l = dis.readLong();
                vg.l1Buffer.append(l);
            }
            for (l2Size = (int)dis.readLong(); l2Size > 0; --l2Size) {
                vg.l2Buffer.append(dis.readLong());
            }
            if (vg.shallowDepth) {
                if (intLongSwitch) {
                    for (l3Size = (int)dis.readLong(); l3Size > 0; --l3Size) {
                        vg.l3Buffer.append(dis.readInt());
                    }
                } else {
                    while (l3Size > 0) {
                        vg.l3Buffer.append((int)(dis.readLong() >> 32));
                        --l3Size;
                    }
                }
            } else {
                int l5Size;
                while (l3Size > 0) {
                    vg._l3Buffer.append(dis.readLong());
                    --l3Size;
                }
                int l4Size = (int)dis.readLong();
                while (l2Size > 0) {
                    vg._l4Buffer.append(dis.readLong());
                    --l4Size;
                }
                if (intLongSwitch) {
                    while (l2Size > 0) {
                        vg._l5Buffer.append(dis.readInt());
                        --l5Size;
                    }
                } else {
                    for (l5Size = (int)dis.readLong(); l5Size > 0; --l5Size) {
                        vg._l5Buffer.append((int)(dis.readLong() >> 32));
                    }
                }
            }
        } else {
            int l3Size;
            for (int vtdSize = (int)IndexHandler.reverseLong(dis.readLong()); vtdSize > 0; --vtdSize) {
                vg.VTDBuffer.append(IndexHandler.reverseLong(dis.readLong()));
            }
            for (int l1Size = (int)IndexHandler.reverseLong(dis.readLong()); l1Size > 0; --l1Size) {
                long l = IndexHandler.reverseLong(dis.readLong());
                vg.l1Buffer.append(l);
            }
            for (int l2Size = (int)IndexHandler.reverseLong(dis.readLong()); l2Size > 0; --l2Size) {
                long l = IndexHandler.reverseLong(dis.readLong());
                vg.l2Buffer.append(l);
            }
            if (vg.shallowDepth) {
                if (intLongSwitch) {
                    for (l3Size = (int)IndexHandler.reverseLong(dis.readLong()); l3Size > 0; --l3Size) {
                        vg.l3Buffer.append(IndexHandler.reverseInt(dis.readInt()));
                    }
                } else {
                    while (l3Size > 0) {
                        vg.l3Buffer.append(IndexHandler.reverseInt((int)(dis.readLong() >> 32)));
                        --l3Size;
                    }
                }
            } else {
                int l5Size;
                while (l3Size > 0) {
                    vg._l3Buffer.append(IndexHandler.reverseLong(dis.readLong()));
                    --l3Size;
                }
                for (int l4Size = (int)IndexHandler.reverseLong(dis.readLong()); l4Size > 0; --l4Size) {
                    long l = IndexHandler.reverseLong(dis.readLong());
                    vg._l4Buffer.append(l);
                }
                if (intLongSwitch) {
                    for (l5Size = (int)IndexHandler.reverseLong(dis.readLong()); l5Size > 0; --l5Size) {
                        vg._l5Buffer.append(IndexHandler.reverseInt(dis.readInt()));
                    }
                } else {
                    while (l5Size > 0) {
                        vg._l5Buffer.append(IndexHandler.reverseInt((int)(dis.readLong() >> 32)));
                        --l5Size;
                    }
                }
            }
        }
    }

    private static long reverseLong(long l) {
        long t = (l & 0xFF00000000000000L) >>> 56 | (l & 0xFF000000000000L) >> 40 | (l & 0xFF0000000000L) >> 24 | (l & 0xFF00000000L) >> 8 | (l & 0xFF000000L) << 8 | (l & 0xFF0000L) << 24 | (l & 0xFF00L) << 40 | (l & 0xFFL) << 56;
        return t;
    }

    private static int reverseInt(int i) {
        int t = (i & 0xFF000000) >>> 24 | (i & 0xFF0000) >> 8 | (i & 0xFF00) << 8 | (i & 0xFF) << 24;
        return t;
    }

    private static long adjust(long l, int i) {
        long l1 = (l & 0xFFFFFFFFL) + (long)i;
        long l2 = l & 0xFFFFFFFF00000000L;
        return l1 | l2;
    }
}

