/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.EOFException;
import com.ximpleware.EncodingException;
import com.ximpleware.EntityException;
import com.ximpleware.FastIntBuffer;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.IReader;
import com.ximpleware.IndexHandler;
import com.ximpleware.IndexReadException;
import com.ximpleware.IndexWriteException;
import com.ximpleware.ParseException;
import com.ximpleware.UniByteBuffer;
import com.ximpleware.VTDNav;
import com.ximpleware.VTDNav_L5;
import com.ximpleware.parser.ISO8859_10;
import com.ximpleware.parser.ISO8859_11;
import com.ximpleware.parser.ISO8859_13;
import com.ximpleware.parser.ISO8859_14;
import com.ximpleware.parser.ISO8859_15;
import com.ximpleware.parser.ISO8859_2;
import com.ximpleware.parser.ISO8859_3;
import com.ximpleware.parser.ISO8859_4;
import com.ximpleware.parser.ISO8859_5;
import com.ximpleware.parser.ISO8859_6;
import com.ximpleware.parser.ISO8859_7;
import com.ximpleware.parser.ISO8859_8;
import com.ximpleware.parser.ISO8859_9;
import com.ximpleware.parser.UTF8Char;
import com.ximpleware.parser.WIN1250;
import com.ximpleware.parser.WIN1251;
import com.ximpleware.parser.WIN1252;
import com.ximpleware.parser.WIN1253;
import com.ximpleware.parser.WIN1254;
import com.ximpleware.parser.WIN1255;
import com.ximpleware.parser.WIN1256;
import com.ximpleware.parser.WIN1257;
import com.ximpleware.parser.WIN1258;
import com.ximpleware.parser.XMLChar;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;

public class VTDGen {
    private static final int ATTR_NAME_ARRAY_SIZE = 16;
    public static final int FORMAT_ASCII = 0;
    public static final int FORMAT_ISO_8859_1 = 1;
    public static final int FORMAT_ISO_8859_10 = 11;
    public static final int FORMAT_ISO_8859_11 = 12;
    public static final int FORMAT_ISO_8859_12 = 13;
    public static final int FORMAT_ISO_8859_13 = 14;
    public static final int FORMAT_ISO_8859_14 = 15;
    public static final int FORMAT_ISO_8859_15 = 16;
    public static final int FORMAT_ISO_8859_16 = 17;
    public static final int FORMAT_ISO_8859_2 = 3;
    public static final int FORMAT_ISO_8859_3 = 4;
    public static final int FORMAT_ISO_8859_4 = 5;
    public static final int FORMAT_ISO_8859_5 = 6;
    public static final int FORMAT_ISO_8859_6 = 7;
    public static final int FORMAT_ISO_8859_7 = 8;
    public static final int FORMAT_ISO_8859_8 = 9;
    public static final int FORMAT_ISO_8859_9 = 10;
    public static final int FORMAT_UTF_16BE = 63;
    public static final int FORMAT_UTF_16LE = 64;
    public static final int FORMAT_UTF8 = 2;
    public static final int FORMAT_WIN_1250 = 18;
    public static final int FORMAT_WIN_1251 = 19;
    public static final int FORMAT_WIN_1252 = 20;
    public static final int FORMAT_WIN_1253 = 21;
    public static final int FORMAT_WIN_1254 = 22;
    public static final int FORMAT_WIN_1255 = 23;
    public static final int FORMAT_WIN_1256 = 24;
    public static final int FORMAT_WIN_1257 = 25;
    public static final int FORMAT_WIN_1258 = 26;
    public static final int MAX_DEPTH = 254;
    public static final int MAX_PREFIX_LENGTH = 511;
    public static final int MAX_QNAME_LENGTH = 2047;
    public static final int MAX_TOKEN_LENGTH = 1048575;
    private static final int STATE_ATTR_NAME = 3;
    private static final int STATE_ATTR_VAL = 4;
    private static final int STATE_CDATA = 12;
    private static final int STATE_COMMENT = 11;
    private static final int STATE_DEC_ATTR_NAME = 10;
    private static final int STATE_DOC_END = 7;
    private static final int STATE_DOC_START = 6;
    private static final int STATE_DOCTYPE = 13;
    private static final int STATE_END_COMMENT = 14;
    private static final int STATE_END_PI = 15;
    private static final int STATE_END_TAG = 2;
    private static final int STATE_LT_SEEN = 0;
    private static final int STATE_PI_TAG = 8;
    private static final int STATE_PI_VAL = 9;
    private static final int STATE_START_TAG = 1;
    private static final int STATE_TEXT = 5;
    private static final int TAG_STACK_SIZE = 256;
    public static final int TOKEN_ATTR_NAME = 2;
    public static final int TOKEN_ATTR_NS = 3;
    public static final int TOKEN_ATTR_VAL = 4;
    public static final int TOKEN_CDATA_VAL = 11;
    public static final int TOKEN_CHARACTER_DATA = 5;
    public static final int TOKEN_COMMENT = 6;
    public static final int TOKEN_DEC_ATTR_NAME = 9;
    public static final int TOKEN_DEC_ATTR_VAL = 10;
    public static final int TOKEN_DOCUMENT = 13;
    public static final int TOKEN_DTD_VAL = 12;
    public static final int TOKEN_ENDING_TAG = 1;
    public static final int TOKEN_PI_NAME = 7;
    public static final int TOKEN_PI_VAL = 8;
    public static final int TOKEN_STARTING_TAG = 0;
    protected byte[] XMLDoc;
    protected IReader r;
    private int ch;
    private int ch_temp;
    protected int offset;
    protected int depth;
    private int length1;
    private int length2;
    protected boolean helper = false;
    protected boolean default_ns = false;
    protected boolean isXML = false;
    protected boolean singleByteEncoding = true;
    protected boolean shallowDepth = true;
    protected boolean ns;
    protected boolean is_ns;
    protected boolean br = false;
    private int temp_offset;
    protected int endOffset;
    protected int prev_offset;
    private int increment;
    protected long[] tag_stack;
    private long[] attr_name_array = new long[16];
    private int attr_count;
    private long[] prefixed_attr_name_array = new long[16];
    private int[] prefix_URL_array = new int[16];
    private int prefixed_attr_count;
    protected FastLongBuffer VTDBuffer;
    protected FastLongBuffer l1Buffer;
    protected FastLongBuffer l2Buffer;
    protected FastIntBuffer l3Buffer;
    protected FastLongBuffer _l3Buffer;
    protected FastLongBuffer _l4Buffer;
    protected FastIntBuffer _l5Buffer;
    protected FastIntBuffer nsBuffer1;
    protected FastLongBuffer nsBuffer2;
    protected FastLongBuffer nsBuffer3;
    private int last_depth;
    private int last_l1_index;
    private int last_l2_index;
    private int last_l3_index;
    private int last_l4_index;
    protected EOFException e;
    protected int docLen;
    protected int docOffset;
    protected int encoding;
    protected boolean ws = false;
    protected int rootIndex;
    protected int VTDDepth = 0;
    protected short LcDepth;
    protected long currentElementRecord = 0L;
    private boolean must_utf_8;
    private boolean BOM_detected;

    public VTDGen() {
        this.tag_stack = new long[256];
        this.LcDepth = (short)3;
        this.e = new EOFException("permature EOF reached, XML document incomplete");
        this.nsBuffer1 = new FastIntBuffer(4);
        this.nsBuffer2 = new FastLongBuffer(4);
        this.nsBuffer3 = new FastLongBuffer(4);
    }

    public void clear() {
        if (!this.br) {
            this.VTDBuffer = null;
            this.l1Buffer = null;
            this.l2Buffer = null;
            this.l3Buffer = null;
            this._l3Buffer = null;
            this._l4Buffer = null;
            this._l5Buffer = null;
        }
        this.XMLDoc = null;
        this.temp_offset = 0;
        this.offset = 0;
        this.last_l4_index = 0;
        this.last_l3_index = 0;
        this.last_l2_index = 0;
        this.last_l1_index = 0;
        this.last_depth = 0;
        this.rootIndex = 0;
        this.depth = -1;
        this.increment = 1;
        this.BOM_detected = false;
        this.must_utf_8 = false;
        this.ch_temp = 0;
        this.ch = 0;
        this.nsBuffer1.size = 0;
        this.nsBuffer2.size = 0;
        this.nsBuffer3.size = 0;
        this.currentElementRecord = 0L;
    }

    public void enableIgnoredWhiteSpace(boolean b) {
        this.ws = b;
    }

    public void selectLcDepth(int i) throws ParseException {
        if (i != 3 && i != 5) {
            throw new IllegalArgumentException("LcDepth can only take the value of 3 or 5");
        }
        if (i == 5) {
            this.shallowDepth = false;
        }
    }

    private void addWhiteSpaceRecord() {
        int length1;
        if (this.depth > -1 && (length1 = this.offset - this.increment - this.temp_offset) != 0) {
            if (this.singleByteEncoding) {
                this.writeVTDText(this.temp_offset, length1, 5, this.depth);
            } else {
                this.writeVTDText(this.temp_offset >> 1, length1 >> 1, 5, this.depth);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decide_encoding() throws EncodingException, ParseException {
        if (this.XMLDoc.length == 0) {
            throw new EncodingException("Document is zero sized ");
        }
        if (this.XMLDoc[this.offset] == -2) {
            this.increment = 2;
            if (this.XMLDoc[this.offset + 1] != -1) throw new EncodingException("Unknown Character encoding: should be 0xff 0xfe");
            this.offset += 2;
            this.encoding = 63;
            this.BOM_detected = true;
            this.r = new UTF16BEReader();
        } else if (this.XMLDoc[this.offset] == -1) {
            this.increment = 2;
            if (this.XMLDoc[this.offset + 1] != -2) throw new EncodingException("Unknown Character encoding: not UTF-16LE");
            this.offset += 2;
            this.encoding = 64;
            this.BOM_detected = true;
            this.r = new UTF16LEReader();
        } else if (this.XMLDoc[this.offset] == -17) {
            if (this.XMLDoc[this.offset + 1] != -69 || this.XMLDoc[this.offset + 2] != -65) throw new EncodingException("Unknown Character encoding: not UTF-8");
            this.offset += 3;
            this.must_utf_8 = true;
        } else if (this.XMLDoc[this.offset] == 0) {
            if (this.XMLDoc[this.offset + 1] != 60 || this.XMLDoc[this.offset + 2] != 0 || this.XMLDoc[this.offset + 3] != 63) throw new EncodingException("Unknown Character encoding: not UTF-16BE");
            this.encoding = 63;
            this.increment = 2;
            this.r = new UTF16BEReader();
        } else if (this.XMLDoc[this.offset] == 60 && this.XMLDoc[this.offset + 1] == 0 && this.XMLDoc[this.offset + 2] == 63 && this.XMLDoc[this.offset + 3] == 0) {
            this.increment = 2;
            this.encoding = 64;
            this.r = new UTF16LEReader();
        }
        if (this.encoding < 63) {
            if (this.ns) {
                if ((long)this.offset + (long)this.docLen >= 0x40000000L) {
                    throw new ParseException("Other error: file size too big >=1GB ");
                }
            } else if ((long)this.offset + (long)this.docLen >= 0x80000000L) {
                throw new ParseException("Other error: file size too big >=2GB ");
            }
        } else if ((long)this.offset + (long)this.docLen >= 0x80000000L) {
            throw new ParseException("Other error: file size too large >= 2GB");
        }
        if (this.encoding < 63) return;
        this.singleByteEncoding = false;
    }

    private int entityIdentifier() throws EntityException, EncodingException, EOFException, ParseException {
        int ch = this.r.getChar();
        int val = 0;
        switch (ch) {
            case 35: {
                ch = this.r.getChar();
                if (ch == 120) {
                    while (true) {
                        if ((ch = this.r.getChar()) >= 48 && ch <= 57) {
                            val = (val << 4) + (ch - 48);
                            continue;
                        }
                        if (ch >= 97 && ch <= 102) {
                            val = (val << 4) + (ch - 97 + 10);
                            continue;
                        }
                        if (ch < 65 || ch > 70) break;
                        val = (val << 4) + (ch - 65 + 10);
                    }
                    if (ch == 59) {
                        return val;
                    }
                    throw new EntityException("Errors in char reference: Illegal char following &#x.");
                }
                while (true) {
                    if (ch < 48 || ch > 57) {
                        if (ch == 59) break;
                        throw new EntityException("Errors in char reference: Illegal char following &#.");
                    }
                    val = val * 10 + (ch - 48);
                    ch = this.r.getChar();
                }
                if (!XMLChar.isValidChar(val)) {
                    throw new EntityException("Errors in entity reference: Invalid XML char.");
                }
                return val;
            }
            case 97: {
                ch = this.r.getChar();
                if (ch == 109) {
                    if (this.r.getChar() == 112 && this.r.getChar() == 59) {
                        return 38;
                    }
                    throw new EntityException("Errors in Entity: Illegal builtin reference");
                }
                if (ch == 112) {
                    if (this.r.getChar() == 111 && this.r.getChar() == 115 && this.r.getChar() == 59) {
                        return 39;
                    }
                    throw new EntityException("Errors in Entity: Illegal builtin reference");
                }
                throw new EntityException("Errors in Entity: Illegal builtin reference");
            }
            case 113: {
                if (this.r.getChar() == 117 && this.r.getChar() == 111 && this.r.getChar() == 116 && this.r.getChar() == 59) {
                    return 34;
                }
                throw new EntityException("Errors in Entity: Illegal builtin reference");
            }
            case 108: {
                if (this.r.getChar() == 116 && this.r.getChar() == 59) {
                    return 60;
                }
                throw new EntityException("Errors in Entity: Illegal builtin reference");
            }
            case 103: {
                if (this.r.getChar() == 116 && this.r.getChar() == 59) {
                    return 62;
                }
                throw new EntityException("Errors in Entity: Illegal builtin reference");
            }
        }
        throw new EntityException("Errors in Entity: Illegal entity char");
    }

    private void finishUp() {
        if (this.shallowDepth) {
            if (this.last_depth == 1) {
                this.l1Buffer.append((long)this.last_l1_index << 32 | 0xFFFFFFFFL);
            } else if (this.last_depth == 2) {
                this.l2Buffer.append((long)this.last_l2_index << 32 | 0xFFFFFFFFL);
            }
        } else if (this.last_depth == 1) {
            this.l1Buffer.append((long)this.last_l1_index << 32 | 0xFFFFFFFFL);
        } else if (this.last_depth == 2) {
            this.l2Buffer.append((long)this.last_l2_index << 32 | 0xFFFFFFFFL);
        } else if (this.last_depth == 3) {
            this._l3Buffer.append((long)this.last_l3_index << 32 | 0xFFFFFFFFL);
        } else if (this.last_depth == 4) {
            this._l4Buffer.append((long)this.last_l4_index << 32 | 0xFFFFFFFFL);
        }
    }

    private String formatLineNumber() {
        return this.formatLineNumber(this.offset);
    }

    private String formatLineNumber(int os) {
        int so;
        int lineNumber = 0;
        int lineOffset = 0;
        if (this.encoding < 63) {
            for (so = this.docOffset; so <= os - 1; ++so) {
                if (this.XMLDoc[so] != 10) continue;
                ++lineNumber;
                lineOffset = so;
            }
            lineOffset = os - lineOffset;
        } else if (this.encoding == 63) {
            while (so <= os - 2) {
                if (this.XMLDoc[so + 1] == 10 && this.XMLDoc[so] == 0) {
                    ++lineNumber;
                    lineOffset = so;
                }
                so += 2;
            }
            lineOffset = os - lineOffset >> 1;
        } else {
            while (so <= os - 2) {
                if (this.XMLDoc[so] == 10 && this.XMLDoc[so + 1] == 0) {
                    ++lineNumber;
                    lineOffset = so;
                }
                so += 2;
            }
            lineOffset = os - lineOffset >> 1;
        }
        return "\nLine Number: " + (lineNumber + 1) + " Offset: " + (lineOffset - 1);
    }

    private final int getCharAfterS() throws ParseException, EncodingException, EOFException {
        int n;
        do {
            if (!XMLChar.isSpaceChar(n = this.r.getChar())) {
                return n;
            }
            n = this.r.getChar();
        } while (XMLChar.isSpaceChar(n));
        return n;
    }

    public long getIndexSize() {
        int size = (this.docLen & 7) == 0 ? this.docLen : (this.docLen >> 3) + 1 << 3;
        size += (this.VTDBuffer.size << 3) + (this.l1Buffer.size << 3) + (this.l2Buffer.size << 3);
        size = (this.l3Buffer.size & 1) == 0 ? (size += this.l3Buffer.size << 2) : (size += this.l3Buffer.size + 1 << 2);
        return size + 64;
    }

    public VTDNav getNav() {
        VTDNav vn = this.shallowDepth ? new VTDNav(this.rootIndex, this.encoding, this.ns, this.VTDDepth, new UniByteBuffer(this.XMLDoc), this.VTDBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, this.docOffset, this.docLen) : new VTDNav_L5(this.rootIndex, this.encoding, this.ns, this.VTDDepth, new UniByteBuffer(this.XMLDoc), this.VTDBuffer, this.l1Buffer, this.l2Buffer, this._l3Buffer, this._l4Buffer, this._l5Buffer, this.docOffset, this.docLen);
        this.clear();
        this.r = new UTF8Reader();
        return vn;
    }

    private int getPrevOffset() throws ParseException {
        int prevOffset = this.offset;
        switch (this.encoding) {
            case 2: {
                while (this.XMLDoc[--prevOffset] < 0 && (this.XMLDoc[prevOffset] & 0xFFFFFFC0) == -128) {
                }
                return prevOffset;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return this.offset - 1;
            }
            case 64: {
                int temp = (this.XMLDoc[this.offset] & 0xFF) << 8 | this.XMLDoc[this.offset + 1] & 0xFF;
                if (temp < 55296 || temp > 57343) {
                    return this.offset - 2;
                }
                return this.offset - 4;
            }
            case 63: {
                int temp = (this.XMLDoc[this.offset] & 0xFF) << 8 | this.XMLDoc[this.offset + 1] & 0xFF;
                if (temp < 55296 || temp > 57343) {
                    return this.offset - 2;
                }
                return this.offset - 4;
            }
        }
        throw new ParseException("Other Error: Should never happen");
    }

    public VTDNav loadIndex(byte[] ba) throws IOException, IndexReadException {
        IndexHandler.readIndex(ba, this);
        return this.getNav();
    }

    public VTDNav loadIndex(InputStream is) throws IOException, IndexReadException {
        IndexHandler.readIndex(is, this);
        return this.getNav();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VTDNav loadIndex(String fileName) throws IOException, IndexReadException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            VTDNav vTDNav = this.loadIndex(fis);
            return vTDNav;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public VTDNav loadSeparateIndex(String XMLFileName, String VTDIndexName) throws IOException, IndexReadException {
        FileInputStream xfis = null;
        FileInputStream vfis = null;
        xfis = new FileInputStream(XMLFileName);
        int size = (int)new File(XMLFileName).length();
        vfis = new FileInputStream(VTDIndexName);
        IndexHandler.readSeparateIndex(vfis, xfis, size, this);
        return this.getNav();
    }

    private void matchCPEncoding() throws ParseException {
        if ((this.r.skipChar(112) || this.r.skipChar(80)) && this.r.skipChar(49) && this.r.skipChar(50) && this.r.skipChar(53)) {
            if (this.encoding <= 64) {
                if (this.must_utf_8) {
                    throw new EncodingException("Can't switch from UTF-8" + this.formatLineNumber());
                }
                if (this.r.skipChar(48)) {
                    this.encoding = 18;
                    this.r = new WIN1250Reader();
                    this._writeVTD(this.temp_offset, 6, 10, this.depth);
                } else if (this.r.skipChar(49)) {
                    this.encoding = 19;
                    this.r = new WIN1251Reader();
                    this._writeVTD(this.temp_offset, 6, 10, this.depth);
                } else if (this.r.skipChar(50)) {
                    this.encoding = 20;
                    this.r = new WIN1252Reader();
                    this._writeVTD(this.temp_offset, 6, 10, this.depth);
                } else if (this.r.skipChar(51)) {
                    this.encoding = 21;
                    this.r = new WIN1253Reader();
                    this._writeVTD(this.temp_offset, 6, 10, this.depth);
                } else if (this.r.skipChar(52)) {
                    this.encoding = 22;
                    this.r = new WIN1254Reader();
                    this._writeVTD(this.temp_offset, 6, 10, this.depth);
                } else if (this.r.skipChar(53)) {
                    this.encoding = 23;
                    this.r = new WIN1255Reader();
                    this._writeVTD(this.temp_offset, 6, 10, this.depth);
                } else if (this.r.skipChar(54)) {
                    this.encoding = 24;
                    this.r = new WIN1256Reader();
                    this._writeVTD(this.temp_offset, 6, 10, this.depth);
                } else if (this.r.skipChar(55)) {
                    this.encoding = 25;
                    this.r = new WIN1257Reader();
                    this._writeVTD(this.temp_offset, 6, 10, this.depth);
                } else if (this.r.skipChar(56)) {
                    this.encoding = 26;
                    this.r = new WIN1258Reader();
                    this._writeVTD(this.temp_offset, 6, 10, this.depth);
                } else {
                    throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
                }
                if (this.r.skipChar(this.ch_temp)) {
                    return;
                }
            } else {
                throw new ParseException("XML decl error: Can't switch encoding to ISO-8859" + this.formatLineNumber());
            }
        }
        throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void matchISOEncoding() throws ParseException {
        if (!this.r.skipChar(115) && !this.r.skipChar(83) || !this.r.skipChar(111) && !this.r.skipChar(79) || !this.r.skipChar(45) || !this.r.skipChar(56) || !this.r.skipChar(56) || !this.r.skipChar(53) || !this.r.skipChar(57) || !this.r.skipChar(45)) throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
        if (this.encoding > 64) throw new ParseException("XML decl error: Can't switch encoding to ISO-8859" + this.formatLineNumber());
        if (this.must_utf_8) {
            throw new EncodingException("Can't switch from UTF-8" + this.formatLineNumber());
        }
        if (this.r.skipChar(49)) {
            if (this.r.skipChar(this.ch_temp)) {
                this.encoding = 1;
                this.r = new ISO8859_1Reader();
                this._writeVTD(this.temp_offset, 10, 10, this.depth);
                return;
            }
            if (this.r.skipChar(48)) {
                this.encoding = 11;
                this.r = new ISO8859_10Reader();
                this._writeVTD(this.temp_offset, 11, 10, this.depth);
            } else if (this.r.skipChar(49)) {
                this.encoding = 12;
                this.r = new ISO8859_11Reader();
                this._writeVTD(this.temp_offset, 11, 10, this.depth);
            } else if (this.r.skipChar(51)) {
                this.encoding = 14;
                this.r = new ISO8859_13Reader();
                this._writeVTD(this.temp_offset, 11, 10, this.depth);
            } else if (this.r.skipChar(52)) {
                this.encoding = 15;
                this.r = new ISO8859_14Reader();
                this._writeVTD(this.temp_offset, 11, 10, this.depth);
            } else {
                if (!this.r.skipChar(53)) throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
                this.encoding = 16;
                this.r = new ISO8859_15Reader();
                this._writeVTD(this.temp_offset, 15, 10, this.depth);
            }
        } else if (this.r.skipChar(50)) {
            this.encoding = 3;
            this.r = new ISO8859_2Reader();
            this._writeVTD(this.temp_offset, 10, 10, this.depth);
        } else if (this.r.skipChar(51)) {
            this.r = new ISO8859_3Reader();
            this.encoding = 4;
            this._writeVTD(this.temp_offset, 10, 10, this.depth);
        } else if (this.r.skipChar(52)) {
            this.r = new ISO8859_4Reader();
            this.encoding = 5;
            this._writeVTD(this.temp_offset, 10, 10, this.depth);
        } else if (this.r.skipChar(53)) {
            this.encoding = 6;
            this.r = new ISO8859_5Reader();
            this._writeVTD(this.temp_offset, 10, 10, this.depth);
        } else if (this.r.skipChar(54)) {
            this.encoding = 7;
            this.r = new ISO8859_6Reader();
            this._writeVTD(this.temp_offset, 10, 10, this.depth);
        } else if (this.r.skipChar(55)) {
            this.encoding = 8;
            this.r = new ISO8859_7Reader();
            this._writeVTD(this.temp_offset, 10, 10, this.depth);
        } else if (this.r.skipChar(56)) {
            this.encoding = 9;
            this.r = new ISO8859_8Reader();
            this._writeVTD(this.temp_offset, 10, 10, this.depth);
        } else {
            if (!this.r.skipChar(57)) throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
            this.encoding = 10;
            this.r = new ISO8859_9Reader();
            this._writeVTD(this.temp_offset, 10, 10, this.depth);
        }
        if (!this.r.skipChar(this.ch_temp)) throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
    }

    private void matchUTFEncoding() throws ParseException {
        if (this.r.skipChar(115) || this.r.skipChar(83)) {
            if (this.r.skipChar(45) && (this.r.skipChar(97) || this.r.skipChar(65)) && (this.r.skipChar(115) || this.r.skipChar(83)) && (this.r.skipChar(99) || this.r.skipChar(67)) && (this.r.skipChar(105) || this.r.skipChar(73)) && (this.r.skipChar(105) || this.r.skipChar(73)) && this.r.skipChar(this.ch_temp)) {
                if (this.singleByteEncoding) {
                    if (this.must_utf_8) {
                        throw new EncodingException("Can't switch from UTF-8" + this.formatLineNumber());
                    }
                    this.encoding = 0;
                    this.r = new ASCIIReader();
                    this._writeVTD(this.temp_offset, 8, 10, this.depth);
                    return;
                }
                throw new ParseException("XML decl error: Can't switch encoding to US-ASCII" + this.formatLineNumber());
            }
            throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
        }
        if ((this.r.skipChar(116) || this.r.skipChar(84)) && (this.r.skipChar(102) || this.r.skipChar(70)) && this.r.skipChar(45)) {
            if (this.r.skipChar(56) && this.r.skipChar(this.ch_temp)) {
                if (this.singleByteEncoding) {
                    this._writeVTD(this.temp_offset, 5, 10, this.depth);
                    return;
                }
                throw new ParseException("XML decl error: Can't switch encoding to UTF-8" + this.formatLineNumber());
            }
            if (this.r.skipChar(49) && this.r.skipChar(54)) {
                if (this.r.skipChar(this.ch_temp)) {
                    if (!this.singleByteEncoding) {
                        if (!this.BOM_detected) {
                            throw new EncodingException("BOM not detected for UTF-16" + this.formatLineNumber());
                        }
                        this._writeVTD(this.temp_offset >> 1, 6, 10, this.depth);
                        return;
                    }
                    throw new ParseException("XML decl error: Can't switch encoding to UTF-16" + this.formatLineNumber());
                }
                if ((this.r.skipChar(108) || this.r.skipChar(76)) && (this.r.skipChar(101) || this.r.skipChar(69)) && this.r.skipChar(this.ch_temp)) {
                    if (this.encoding == 64) {
                        this.r = new UTF16LEReader();
                        this._writeVTD(this.temp_offset >> 1, 8, 10, this.depth);
                        return;
                    }
                    throw new ParseException("XML del error: Can't switch encoding to UTF-16LE" + this.formatLineNumber());
                }
                if ((this.r.skipChar(98) || this.r.skipChar(66)) && (this.r.skipChar(101) || this.r.skipChar(69)) && this.r.skipChar(this.ch_temp)) {
                    if (this.encoding == 63) {
                        this._writeVTD(this.temp_offset >> 1, 8, 10, this.depth);
                        return;
                    }
                    throw new ParseException("XML del error: Can't swtich encoding to UTF-16BE" + this.formatLineNumber());
                }
                throw new ParseException("XML decl error: Invalid encoding" + this.formatLineNumber());
            }
        }
    }

    private void matchWindowsEncoding() throws ParseException {
        if ((this.r.skipChar(105) || this.r.skipChar(73)) && (this.r.skipChar(110) || this.r.skipChar(78)) && (this.r.skipChar(100) || this.r.skipChar(68)) && (this.r.skipChar(111) || this.r.skipChar(79)) && (this.r.skipChar(119) || this.r.skipChar(87)) && (this.r.skipChar(115) || this.r.skipChar(83)) && this.r.skipChar(45) && this.r.skipChar(49) && this.r.skipChar(50) && this.r.skipChar(53)) {
            if (this.encoding <= 64) {
                if (this.must_utf_8) {
                    throw new EncodingException("Can't switch from UTF-8" + this.formatLineNumber());
                }
                if (this.r.skipChar(48)) {
                    this.encoding = 18;
                    this.r = new WIN1250Reader();
                    this._writeVTD(this.temp_offset, 12, 10, this.depth);
                } else if (this.r.skipChar(49)) {
                    this.encoding = 19;
                    this.r = new WIN1251Reader();
                    this._writeVTD(this.temp_offset, 12, 10, this.depth);
                } else if (this.r.skipChar(50)) {
                    this.encoding = 20;
                    this.r = new WIN1252Reader();
                    this._writeVTD(this.temp_offset, 12, 10, this.depth);
                } else if (this.r.skipChar(51)) {
                    this.encoding = 21;
                    this.r = new WIN1253Reader();
                    this._writeVTD(this.temp_offset, 12, 10, this.depth);
                } else if (this.r.skipChar(52)) {
                    this.encoding = 22;
                    this.r = new WIN1254Reader();
                    this._writeVTD(this.temp_offset, 12, 10, this.depth);
                } else if (this.r.skipChar(53)) {
                    this.encoding = 23;
                    this.r = new WIN1255Reader();
                    this._writeVTD(this.temp_offset, 12, 10, this.depth);
                } else if (this.r.skipChar(54)) {
                    this.encoding = 24;
                    this.r = new WIN1256Reader();
                    this._writeVTD(this.temp_offset, 12, 10, this.depth);
                } else if (this.r.skipChar(55)) {
                    this.encoding = 25;
                    this.r = new WIN1257Reader();
                    this._writeVTD(this.temp_offset, 12, 10, this.depth);
                } else if (this.r.skipChar(56)) {
                    this.encoding = 26;
                    this.r = new WIN1258Reader();
                    this._writeVTD(this.temp_offset, 12, 10, this.depth);
                } else {
                    throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
                }
                if (this.r.skipChar(this.ch_temp)) {
                    return;
                }
            } else {
                throw new ParseException("XML decl error: Can't switch encoding to ISO-8859" + this.formatLineNumber());
            }
        }
        throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(boolean NS) throws EncodingException, EOFException, EntityException, ParseException {
        this.ns = NS;
        this.length2 = 0;
        this.length1 = 0;
        this.prefixed_attr_count = 0;
        this.attr_count = 0;
        int parser_state = 6;
        this.is_ns = false;
        this.encoding = 2;
        this.helper = false;
        this.default_ns = false;
        this.isXML = false;
        this.singleByteEncoding = true;
        this.decide_encoding();
        try {
            this._writeVTD(0, 0, 13, this.depth);
            block20: while (true) {
                switch (parser_state) {
                    case 0: {
                        this.temp_offset = this.offset;
                        this.ch = this.r.getChar();
                        if (XMLChar.isNameStartChar(this.ch)) {
                            ++this.depth;
                            parser_state = 1;
                            continue block20;
                        }
                        if (this.ch == 47) {
                            parser_state = 2;
                            continue block20;
                        }
                        if (this.ch == 33) {
                            parser_state = this.process_ex_seen();
                            continue block20;
                        }
                        if (this.ch != 63) throw new ParseException("Other Error: Invalid char after <" + this.formatLineNumber());
                        parser_state = this.process_qm_seen();
                        continue block20;
                    }
                    case 1: {
                        long x;
                        while (true) {
                            this.ch = this.r.getChar();
                            if (!XMLChar.isNameChar(this.ch)) break;
                            if (this.ch != 58) continue;
                            this.length2 = this.offset - this.temp_offset - this.increment;
                            if (this.ns && this.checkPrefix2(this.temp_offset, this.length2)) throw new ParseException("xmlns can't be an element prefix " + this.formatLineNumber(this.offset));
                        }
                        this.length1 = this.offset - this.temp_offset - this.increment;
                        if (this.depth > 254) {
                            throw new ParseException("Other Error: Depth exceeds MAX_DEPTH" + this.formatLineNumber());
                        }
                        this.tag_stack[this.depth] = x = ((long)this.length1 << 32) + (long)this.temp_offset;
                        if (this.depth > this.VTDDepth) {
                            this.VTDDepth = this.depth;
                        }
                        if (this.singleByteEncoding) {
                            if (this.length2 > 511 || this.length1 > 2047) {
                                throw new ParseException("Token Length Error: Starting tag prefix or qname length too long" + this.formatLineNumber());
                            }
                            if (this.shallowDepth) {
                                this.writeVTD(this.temp_offset, this.length2 << 11 | this.length1, 0, this.depth);
                            } else {
                                this.writeVTD_L5(this.temp_offset, this.length2 << 11 | this.length1, 0, this.depth);
                            }
                        } else {
                            if (this.length2 > 1022 || this.length1 > 4094) {
                                throw new ParseException("Token Length Error: Starting tag prefix or qname length too long" + this.formatLineNumber());
                            }
                            if (this.shallowDepth) {
                                this.writeVTD(this.temp_offset >> 1, this.length2 << 10 | this.length1 >> 1, 0, this.depth);
                            } else {
                                this.writeVTD_L5(this.temp_offset >> 1, this.length2 << 10 | this.length1 >> 1, 0, this.depth);
                            }
                        }
                        if (this.ns) {
                            if (this.length2 != 0) {
                                this.length2 += this.increment;
                                this.currentElementRecord = (long)(this.length2 << 16 | this.length1) << 32 | (long)this.temp_offset;
                            } else {
                                this.currentElementRecord = 0L;
                            }
                            if (this.depth <= this.nsBuffer1.size - 1) {
                                int t;
                                this.nsBuffer1.size = this.depth;
                                this.nsBuffer2.size = t = this.nsBuffer1.intAt(this.depth - 1) + 1;
                                this.nsBuffer3.size = t;
                            }
                        }
                        this.length2 = 0;
                        if (XMLChar.isSpaceChar(this.ch)) {
                            this.ch = this.getCharAfterS();
                            if (XMLChar.isNameStartChar(this.ch)) {
                                this.temp_offset = this.getPrevOffset();
                                parser_state = 3;
                                continue block20;
                            }
                        }
                        this.helper = true;
                        if (this.ch == 47) {
                            --this.depth;
                            this.helper = false;
                            this.ch = this.r.getChar();
                        }
                        if (this.ch != 62) throw new ParseException("Starting tag Error: Invalid char in starting tag" + this.formatLineNumber());
                        if (this.ns) {
                            this.nsBuffer1.append(this.nsBuffer3.size - 1);
                            if (this.currentElementRecord != 0L) {
                                this.qualifyElement();
                            }
                        }
                        parser_state = this.processElementTail(this.helper);
                        continue block20;
                    }
                    case 2: {
                        this.temp_offset = this.offset;
                        int sos = (int)this.tag_stack[this.depth];
                        int sl = (int)(this.tag_stack[this.depth] >> 32);
                        this.offset = this.temp_offset + sl;
                        if (this.offset >= this.endOffset) {
                            throw new EOFException("permature EOF reached, XML document incomplete");
                        }
                        for (int i = 0; i < sl; ++i) {
                            if (this.XMLDoc[sos + i] == this.XMLDoc[this.temp_offset + i]) continue;
                            throw new ParseException("Ending tag error: Start/ending tag mismatch" + this.formatLineNumber());
                        }
                        --this.depth;
                        this.ch = this.getCharAfterS();
                        if (this.ch != 62) {
                            throw new ParseException("Ending tag error: Invalid char in ending tag " + this.formatLineNumber());
                        }
                        if (this.depth != -1) {
                            this.temp_offset = this.offset;
                            this.ch = this.getCharAfterS();
                            if (this.ch == 60) {
                                if (this.ws) {
                                    this.addWhiteSpaceRecord();
                                }
                                parser_state = 0;
                                continue block20;
                            }
                            if (XMLChar.isContentChar(this.ch)) {
                                parser_state = 5;
                                continue block20;
                            }
                            this.handleOtherTextChar2(this.ch);
                            parser_state = 5;
                            continue block20;
                        }
                        parser_state = 7;
                        continue block20;
                    }
                    case 3: {
                        this.process_attr_name();
                        parser_state = 4;
                        continue block20;
                    }
                    case 4: {
                        parser_state = this.process_attr_val();
                        continue block20;
                    }
                    case 5: {
                        if (this.depth == -1) {
                            throw new ParseException("Error in text content: Char data at the wrong place" + this.formatLineNumber());
                        }
                        while (true) {
                            this.ch = this.r.getChar();
                            if (!XMLChar.isContentChar(this.ch)) {
                                if (this.ch == 60) break;
                                this.handleOtherTextChar(this.ch);
                            }
                            this.ch = this.r.getChar();
                            if (XMLChar.isContentChar(this.ch)) continue;
                            if (this.ch == 60) break;
                            this.handleOtherTextChar(this.ch);
                        }
                        this.length1 = this.offset - this.increment - this.temp_offset;
                        if (this.singleByteEncoding) {
                            this.writeVTDText(this.temp_offset, this.length1, 5, this.depth);
                        } else {
                            this.writeVTDText(this.temp_offset >> 1, this.length1 >> 1, 5, this.depth);
                        }
                        parser_state = 0;
                        continue block20;
                    }
                    case 6: {
                        parser_state = this.process_start_doc();
                        continue block20;
                    }
                    case 7: {
                        parser_state = this.process_end_doc();
                        continue block20;
                    }
                    case 8: {
                        parser_state = this.process_pi_tag();
                        continue block20;
                    }
                    case 9: {
                        parser_state = this.process_pi_val();
                        continue block20;
                    }
                    case 10: {
                        parser_state = this.process_dec_attr();
                        continue block20;
                    }
                    case 11: {
                        parser_state = this.process_comment();
                        continue block20;
                    }
                    case 12: {
                        parser_state = this.process_cdata();
                        continue block20;
                    }
                    case 13: {
                        parser_state = this.process_doc_type();
                        continue block20;
                    }
                    case 14: {
                        parser_state = this.process_end_comment();
                        continue block20;
                    }
                    case 15: {
                        parser_state = this.process_end_pi();
                        continue block20;
                    }
                }
                break;
            }
            throw new ParseException("Other error: invalid parser state" + this.formatLineNumber());
        }
        catch (EOFException e) {
            if (parser_state != 7) {
                throw e;
            }
            this.finishUp();
            return;
        }
    }

    private void checkQualifiedAttributeUniqueness() throws ParseException {
        for (int i = 0; i < this.prefixed_attr_count; ++i) {
            int preLen1 = (int)((this.prefixed_attr_name_array[i] & 0xFFFF0000L) >> 16);
            int postLen1 = (int)(this.prefixed_attr_name_array[i] & 0xFFFFL) - preLen1 - this.increment;
            int os1 = (int)(this.prefixed_attr_name_array[i] >> 32) + preLen1 + this.increment;
            int URLLen1 = this.nsBuffer2.lower32At(this.prefix_URL_array[i]);
            int URLOs1 = this.nsBuffer2.upper32At(this.prefix_URL_array[i]);
            for (int j = i + 1; j < this.prefixed_attr_count; ++j) {
                int k;
                int preLen2 = (int)((this.prefixed_attr_name_array[j] & 0xFFFF0000L) >> 16);
                int postLen2 = (int)(this.prefixed_attr_name_array[j] & 0xFFFFL) - preLen2 - this.increment;
                int os2 = (int)(this.prefixed_attr_name_array[j] >> 32) + preLen2 + this.increment;
                if (postLen1 != postLen2) continue;
                for (k = 0; k < postLen1 && this.XMLDoc[os1 + k] == this.XMLDoc[os2 + k]; ++k) {
                }
                if (k != postLen1) continue;
                int URLLen2 = this.nsBuffer2.lower32At(this.prefix_URL_array[j]);
                int URLOs2 = this.nsBuffer2.upper32At(this.prefix_URL_array[j]);
                if (!this.matchURL(URLOs1, URLLen1, URLOs2, URLLen2)) continue;
                throw new ParseException(" qualified attribute names collide " + this.formatLineNumber(os2));
            }
        }
    }

    private void qualifyAttributes() throws ParseException {
        int i1 = this.nsBuffer3.size - 1;
        int i = 0;
        for (int j = 0; j < this.prefixed_attr_count; ++j) {
            int preLen = (int)((this.prefixed_attr_name_array[j] & 0xFFFF0000L) >> 16);
            int preOs = (int)(this.prefixed_attr_name_array[j] >> 32);
            for (i = i1; i >= 0; --i) {
                int k;
                int t = this.nsBuffer3.upper32At(i);
                if ((t & 0xFFFF) - (t >> 16) != preLen + this.increment) continue;
                int os = this.nsBuffer3.lower32At(i) + (t >> 16) + this.increment;
                for (k = 0; k < preLen && this.XMLDoc[os + k] == this.XMLDoc[preOs + k]; ++k) {
                }
                if (k == preLen) break;
            }
            if (i < 0) {
                throw new ParseException("Name space qualification Exception: prefixed attribute not qualified\n" + this.formatLineNumber(preOs));
            }
            this.prefix_URL_array[j] = i;
        }
    }

    private int identifyNsURL(int byte_offset, int length) {
        int i;
        long l;
        String URL1 = "2000/xmlns/";
        String URL2 = "http://www.w3.org/XML/1998/namespace";
        int g = byte_offset + length;
        int os = byte_offset;
        if (length < 29 || this.increment == 2 && length < 58) {
            return 0;
        }
        for (i = 0; i < 18 && os < g; os += (int)(l >> 32), ++i) {
            l = this._getCharResolved(os);
            if (URL2.charAt(i) == (int)l) continue;
            return 0;
        }
        int t = os;
        for (i = 0; i < 11 && os < g; os += (int)(l >> 32), ++i) {
            l = this._getCharResolved(os);
            if (URL1.charAt(i) != (int)l) break;
        }
        if (os == g) {
            return 2;
        }
        os = t;
        for (i = 18; i < 36 && os < g; os += (int)(l >> 32), ++i) {
            l = this._getCharResolved(os);
            if (URL2.charAt(i) == (int)l) continue;
            return 0;
        }
        if (os == g) {
            return 1;
        }
        return 0;
    }

    private boolean matchXML(int byte_offset) {
        return this.encoding < 63 ? this.XMLDoc[byte_offset] == 120 && this.XMLDoc[byte_offset + 1] == 109 && this.XMLDoc[byte_offset + 2] == 108 : (this.encoding == 64 ? this.XMLDoc[byte_offset] == 120 && this.XMLDoc[byte_offset + 1] == 0 && this.XMLDoc[byte_offset + 2] == 109 && this.XMLDoc[byte_offset + 3] == 0 && this.XMLDoc[byte_offset + 4] == 108 && this.XMLDoc[byte_offset + 5] == 0 : this.XMLDoc[byte_offset] == 0 && this.XMLDoc[byte_offset + 1] == 120 && this.XMLDoc[byte_offset + 2] == 0 && this.XMLDoc[byte_offset + 3] == 109 && this.XMLDoc[byte_offset + 4] == 0 && this.XMLDoc[byte_offset + 5] == 108);
    }

    private void disallow_xmlns(int byte_offset) throws ParseException {
        if (this.encoding < 63 ? this.XMLDoc[byte_offset] == 120 && this.XMLDoc[byte_offset + 1] == 109 && this.XMLDoc[byte_offset + 2] == 108 && this.XMLDoc[byte_offset + 3] == 110 && this.XMLDoc[byte_offset + 4] == 115 : (this.encoding == 64 ? this.XMLDoc[byte_offset] == 120 && this.XMLDoc[byte_offset + 1] == 0 && this.XMLDoc[byte_offset + 2] == 109 && this.XMLDoc[byte_offset + 3] == 0 && this.XMLDoc[byte_offset + 4] == 108 && this.XMLDoc[byte_offset + 5] == 0 && this.XMLDoc[byte_offset + 6] == 110 && this.XMLDoc[byte_offset + 7] == 0 && this.XMLDoc[byte_offset + 8] == 115 && this.XMLDoc[byte_offset + 9] == 0 : this.XMLDoc[byte_offset] == 0 && this.XMLDoc[byte_offset + 1] == 120 && this.XMLDoc[byte_offset + 2] == 0 && this.XMLDoc[byte_offset + 3] == 109 && this.XMLDoc[byte_offset + 4] == 0 && this.XMLDoc[byte_offset + 5] == 108 && this.XMLDoc[byte_offset + 6] == 0 && this.XMLDoc[byte_offset + 7] == 110 && this.XMLDoc[byte_offset + 8] == 0 && this.XMLDoc[byte_offset + 9] == 115)) {
            throw new ParseException("xmlns as a ns prefix can't be re-declared" + this.formatLineNumber(byte_offset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseFile(String fileName, boolean ns) {
        FileInputStream fis = null;
        File f = null;
        try {
            f = new File(fileName);
            fis = new FileInputStream(f);
            byte[] b = new byte[(int)f.length()];
            int offset = 0;
            int numRead = 0;
            int numOfBytes = 0x100000;
            if (b.length - offset < numOfBytes) {
                numOfBytes = b.length - offset;
            }
            while (offset < b.length && (numRead = fis.read(b, offset, numOfBytes)) >= 0) {
                if (b.length - (offset += numRead) >= numOfBytes) continue;
                numOfBytes = b.length - offset;
            }
            this.setDoc(b);
            this.parse(ns);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
        }
        catch (ParseException e) {
            System.out.println("ParserException: " + e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseGZIPFile(String GZIPfileName, boolean ns) {
        FileInputStream fis = null;
        try {
            int noRead;
            fis = new FileInputStream(GZIPfileName);
            GZIPInputStream in = new GZIPInputStream(fis);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] ba = new byte[65536];
            while ((noRead = ((InputStream)in).read(ba)) != -1) {
                baos.write(ba, 0, noRead);
            }
            this.setDoc(baos.toByteArray());
            this.parse(ns);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.out.println("ParserException: " + e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseZIPFile(String ZIPfileName, String XMLName, boolean ns) {
        InputStream is = null;
        ZipFile zf = null;
        try {
            int noRead;
            zf = new ZipFile(ZIPfileName);
            is = zf.getInputStream(zf.getEntry(XMLName));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] ba = new byte[65536];
            while ((noRead = is.read(ba)) != -1) {
                baos.write(ba, 0, noRead);
            }
            this.setDoc(baos.toByteArray());
            this.parse(ns);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.out.println("ParserException: " + e);
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseHttpUrl(String url, boolean ns) {
        block25: {
            boolean bl;
            URL url1 = null;
            InputStream in = null;
            HttpURLConnection urlConnection = null;
            try {
                url1 = new URL(url);
                in = url1.openStream();
                urlConnection = (HttpURLConnection)url1.openConnection();
                if (urlConnection.getResponseCode() != 200) break block25;
                int len = urlConnection.getContentLength();
                if (len > 0) {
                    byte[] ba = new byte[len];
                    int k = len;
                    int offset = 0;
                    while (offset < len & k > 0) {
                        k = in.read(ba, offset, len - offset);
                        offset += k;
                    }
                    this.setDoc(ba);
                    this.parse(ns);
                    boolean bl2 = true;
                    return bl2;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] ba = new byte[4096];
                int k = -1;
                while ((k = in.read(ba)) > 0) {
                    baos.write(ba, 0, k);
                }
                this.setDoc(baos.toByteArray());
                this.parse(ns);
                bl = true;
            }
            catch (IOException e) {
                break block25;
            }
            catch (ParseException e) {
                break block25;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (urlConnection != null) {
                        urlConnection.disconnect();
                    }
                }
                catch (Exception e) {}
            }
            return bl;
        }
        return false;
    }

    private int process_cdata() throws ParseException, EncodingException, EOFException {
        int parser_state;
        block17: {
            block16: {
                while (true) {
                    this.ch = this.r.getChar();
                    if (!XMLChar.isValidChar(this.ch)) break block16;
                    if (this.ch != 93 || !this.r.skipChar(93)) continue;
                    while (this.r.skipChar(93)) {
                    }
                    if (this.r.skipChar(62)) break;
                }
                break block17;
            }
            throw new ParseException("Error in CDATA: Invalid Char" + this.formatLineNumber());
        }
        this.length1 = this.offset - this.temp_offset - (this.increment << 1) - this.increment;
        if (this.singleByteEncoding) {
            this.writeVTDText(this.temp_offset, this.length1, 11, this.depth);
        } else {
            this.writeVTDText(this.temp_offset >> 1, this.length1 >> 1, 11, this.depth);
        }
        this.temp_offset = this.offset;
        this.ch = this.getCharAfterS();
        if (this.ch == 60) {
            if (this.ws) {
                this.addWhiteSpaceRecord();
            }
            parser_state = 0;
        } else if (XMLChar.isContentChar(this.ch)) {
            parser_state = 5;
        } else if (this.ch == 38) {
            this.entityIdentifier();
            parser_state = 5;
        } else if (this.ch == 93) {
            if (this.r.skipChar(93)) {
                while (this.r.skipChar(93)) {
                }
                if (this.r.skipChar(62)) {
                    throw new ParseException("Error in text content: ]]> in text content" + this.formatLineNumber());
                }
            }
            parser_state = 5;
        } else {
            throw new ParseException("Other Error: Invalid char in xml" + this.formatLineNumber());
        }
        return parser_state;
    }

    private int process_comment() throws ParseException, EncodingException, EOFException {
        block17: {
            block16: {
                do {
                    this.ch = this.r.getChar();
                    if (!XMLChar.isValidChar(this.ch)) break block16;
                } while (this.ch != 45 || !this.r.skipChar(45));
                break block17;
            }
            throw new ParseException("Error in comment: Invalid Char" + this.formatLineNumber());
        }
        this.length1 = this.offset - this.temp_offset - (this.increment << 1);
        if (this.r.getChar() == 62) {
            int parser_state;
            if (this.singleByteEncoding) {
                this.writeVTDText(this.temp_offset, this.length1, 6, this.depth);
            } else {
                this.writeVTDText(this.temp_offset >> 1, this.length1 >> 1, 6, this.depth);
            }
            this.temp_offset = this.offset;
            this.ch = this.getCharAfterS();
            if (this.ch == 60) {
                if (this.ws) {
                    this.addWhiteSpaceRecord();
                }
                parser_state = 0;
            } else if (XMLChar.isContentChar(this.ch)) {
                parser_state = 5;
            } else if (this.ch == 38) {
                this.entityIdentifier();
                parser_state = 5;
            } else if (this.ch == 93) {
                if (this.r.skipChar(93)) {
                    while (this.r.skipChar(93)) {
                    }
                    if (this.r.skipChar(62)) {
                        throw new ParseException("Error in text content: ]]> in text content" + this.formatLineNumber());
                    }
                }
                parser_state = 5;
            } else {
                throw new ParseException("Error in text content: Invalid char" + this.formatLineNumber());
            }
            return parser_state;
        }
        throw new ParseException("Error in comment: Invalid terminating sequence" + this.formatLineNumber());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int process_dec_attr() throws ParseException, EncodingException, EOFException {
        if (this.ch != 118) throw new ParseException("XML decl error: should be version" + this.formatLineNumber());
        if (!this.r.skipChar(101)) throw new ParseException("XML decl error: should be version" + this.formatLineNumber());
        if (!this.r.skipChar(114)) throw new ParseException("XML decl error: should be version" + this.formatLineNumber());
        if (!this.r.skipChar(115)) throw new ParseException("XML decl error: should be version" + this.formatLineNumber());
        if (!this.r.skipChar(105)) throw new ParseException("XML decl error: should be version" + this.formatLineNumber());
        if (!this.r.skipChar(111)) throw new ParseException("XML decl error: should be version" + this.formatLineNumber());
        if (!this.r.skipChar(110)) throw new ParseException("XML decl error: should be version" + this.formatLineNumber());
        this.ch = this.getCharAfterS();
        if (this.ch != 61) throw new ParseException("XML decl error: Invalid char" + this.formatLineNumber());
        if (this.singleByteEncoding) {
            this._writeVTD(this.temp_offset - 1, 7, 9, this.depth);
        } else {
            this._writeVTD(this.temp_offset - 2 >> 1, 7, 9, this.depth);
        }
        this.ch_temp = this.getCharAfterS();
        if (this.ch_temp != 39 && this.ch_temp != 34) {
            throw new ParseException("XML decl error: Invalid char to start attr name" + this.formatLineNumber());
        }
        this.temp_offset = this.offset;
        if (!this.r.skipChar(49)) throw new ParseException("XML decl error: Invalid version(other than 1.0 or 1.1) detected" + this.formatLineNumber());
        if (!this.r.skipChar(46)) throw new ParseException("XML decl error: Invalid version(other than 1.0 or 1.1) detected" + this.formatLineNumber());
        if (!this.r.skipChar(48)) {
            if (!this.r.skipChar(49)) throw new ParseException("XML decl error: Invalid version(other than 1.0 or 1.1) detected" + this.formatLineNumber());
        }
        if (this.singleByteEncoding) {
            this._writeVTD(this.temp_offset, 3, 10, this.depth);
        } else {
            this._writeVTD(this.temp_offset >> 1, 3, 10, this.depth);
        }
        if (!this.r.skipChar(this.ch_temp)) {
            throw new ParseException("XML decl error: version not terminated properly" + this.formatLineNumber());
        }
        this.ch = this.r.getChar();
        if (XMLChar.isSpaceChar(this.ch)) {
            this.ch = this.getCharAfterS();
            this.temp_offset = this.offset - this.increment;
            if (this.ch == 101) {
                if (!this.r.skipChar(110)) throw new ParseException("XML decl Error: Invalid char" + this.formatLineNumber());
                if (!this.r.skipChar(99)) throw new ParseException("XML decl Error: Invalid char" + this.formatLineNumber());
                if (!this.r.skipChar(111)) throw new ParseException("XML decl Error: Invalid char" + this.formatLineNumber());
                if (!this.r.skipChar(100)) throw new ParseException("XML decl Error: Invalid char" + this.formatLineNumber());
                if (!this.r.skipChar(105)) throw new ParseException("XML decl Error: Invalid char" + this.formatLineNumber());
                if (!this.r.skipChar(110)) throw new ParseException("XML decl Error: Invalid char" + this.formatLineNumber());
                if (!this.r.skipChar(103)) throw new ParseException("XML decl Error: Invalid char" + this.formatLineNumber());
                this.ch = this.r.getChar();
                if (XMLChar.isSpaceChar(this.ch)) {
                    this.ch = this.getCharAfterS();
                }
                if (this.ch != 61) throw new ParseException("XML decl error: Invalid char" + this.formatLineNumber());
                if (this.singleByteEncoding) {
                    this._writeVTD(this.temp_offset, 8, 9, this.depth);
                } else {
                    this._writeVTD(this.temp_offset >> 1, 8, 9, this.depth);
                }
                this.ch_temp = this.getCharAfterS();
                if (this.ch_temp != 34 && this.ch_temp != 39) {
                    throw new ParseException("XML decl error: Invalid char to start attr name" + this.formatLineNumber());
                }
                this.temp_offset = this.offset;
                this.ch = this.r.getChar();
                switch (this.ch) {
                    case 65: 
                    case 97: {
                        if (!this.r.skipChar(115)) {
                            if (!this.r.skipChar(83)) throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
                        }
                        if (!this.r.skipChar(99)) {
                            if (!this.r.skipChar(67)) throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
                        }
                        if (!this.r.skipChar(105)) {
                            if (!this.r.skipChar(73)) throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
                        }
                        if (!this.r.skipChar(105)) {
                            if (!this.r.skipChar(73)) throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
                        }
                        if (!this.r.skipChar(this.ch_temp)) throw new ParseException("XML decl error: Invalid Encoding" + this.formatLineNumber());
                        if (this.encoding == 64) throw new ParseException("XML decl error: Can't switch encoding to ASCII" + this.formatLineNumber());
                        if (this.encoding == 63) throw new ParseException("XML decl error: Can't switch encoding to ASCII" + this.formatLineNumber());
                        if (this.must_utf_8) {
                            throw new EncodingException("Can't switch from UTF-8" + this.formatLineNumber());
                        }
                        this.encoding = 0;
                        this.r = new ASCIIReader();
                        this._writeVTD(this.temp_offset, 5, 10, this.depth);
                        break;
                    }
                    case 67: 
                    case 99: {
                        this.matchCPEncoding();
                        break;
                    }
                    case 73: 
                    case 105: {
                        this.matchISOEncoding();
                        break;
                    }
                    case 85: 
                    case 117: {
                        this.matchUTFEncoding();
                        break;
                    }
                    case 87: 
                    case 119: {
                        this.matchWindowsEncoding();
                        break;
                    }
                    default: {
                        throw new ParseException("XML decl Error: invalid encoding" + this.formatLineNumber());
                    }
                }
                this.ch = this.r.getChar();
                if (XMLChar.isSpaceChar(this.ch)) {
                    this.ch = this.getCharAfterS();
                }
                this.temp_offset = this.offset - this.increment;
            }
            if (this.ch == 115) {
                if (!this.r.skipChar(116)) throw new ParseException("XML decl error" + this.formatLineNumber());
                if (!this.r.skipChar(97)) throw new ParseException("XML decl error" + this.formatLineNumber());
                if (!this.r.skipChar(110)) throw new ParseException("XML decl error" + this.formatLineNumber());
                if (!this.r.skipChar(100)) throw new ParseException("XML decl error" + this.formatLineNumber());
                if (!this.r.skipChar(97)) throw new ParseException("XML decl error" + this.formatLineNumber());
                if (!this.r.skipChar(108)) throw new ParseException("XML decl error" + this.formatLineNumber());
                if (!this.r.skipChar(111)) throw new ParseException("XML decl error" + this.formatLineNumber());
                if (!this.r.skipChar(110)) throw new ParseException("XML decl error" + this.formatLineNumber());
                if (!this.r.skipChar(101)) throw new ParseException("XML decl error" + this.formatLineNumber());
                this.ch = this.getCharAfterS();
                if (this.ch != 61) {
                    throw new ParseException("XML decl error: Invalid char" + this.formatLineNumber());
                }
                if (this.singleByteEncoding) {
                    this._writeVTD(this.temp_offset, 10, 9, this.depth);
                } else {
                    this._writeVTD(this.temp_offset >> 1, 10, 9, this.depth);
                }
                this.ch_temp = this.getCharAfterS();
                this.temp_offset = this.offset;
                if (this.ch_temp != 34 && this.ch_temp != 39) {
                    throw new ParseException("XML decl error: Invalid char to start attr name" + this.formatLineNumber());
                }
                this.ch = this.r.getChar();
                if (this.ch == 121) {
                    if (!this.r.skipChar(101)) throw new ParseException("XML decl error: invalid val for standalone" + this.formatLineNumber());
                    if (!this.r.skipChar(115)) throw new ParseException("XML decl error: invalid val for standalone" + this.formatLineNumber());
                    if (!this.r.skipChar(this.ch_temp)) throw new ParseException("XML decl error: invalid val for standalone" + this.formatLineNumber());
                    if (this.singleByteEncoding) {
                        this._writeVTD(this.temp_offset, 3, 10, this.depth);
                    } else {
                        this._writeVTD(this.temp_offset >> 1, 3, 10, this.depth);
                    }
                } else {
                    if (this.ch != 110) throw new ParseException("XML decl error: invalid val for standalone" + this.formatLineNumber());
                    if (!this.r.skipChar(111)) throw new ParseException("XML decl error: invalid val for standalone" + this.formatLineNumber());
                    if (!this.r.skipChar(this.ch_temp)) throw new ParseException("XML decl error: invalid val for standalone" + this.formatLineNumber());
                    if (this.singleByteEncoding) {
                        this._writeVTD(this.temp_offset, 2, 10, this.depth);
                    } else {
                        this._writeVTD(this.temp_offset >> 1, 2, 10, this.depth);
                    }
                }
                this.ch = this.r.getChar();
                if (XMLChar.isSpaceChar(this.ch)) {
                    this.ch = this.getCharAfterS();
                }
            }
        }
        if (this.ch != 63) throw new ParseException("XML decl Error: Invalid termination sequence" + this.formatLineNumber());
        if (!this.r.skipChar(62)) throw new ParseException("XML decl Error: Invalid termination sequence" + this.formatLineNumber());
        this.temp_offset = this.offset;
        this.ch = this.getCharAfterS();
        if (this.ch != 60) throw new ParseException("Other Error: Invalid Char in XML" + this.formatLineNumber());
        return 0;
    }

    private int process_doc_type() throws ParseException, EncodingException, EOFException {
        block8: {
            block7: {
                int z = 1;
                do {
                    this.ch = this.r.getChar();
                    if (!XMLChar.isValidChar(this.ch)) break block7;
                    if (this.ch == 62) {
                        --z;
                        continue;
                    }
                    if (this.ch != 60) continue;
                    ++z;
                } while (z != 0);
                break block8;
            }
            throw new ParseException("Error in DOCTYPE: Invalid char" + this.formatLineNumber());
        }
        this.length1 = this.offset - this.temp_offset - this.increment;
        if (this.singleByteEncoding) {
            if (this.length1 > 1048575) {
                throw new ParseException("Token Length Error: DTD val too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset, this.length1, 12, this.depth);
        } else {
            if (this.length1 > 0x1FFFFE) {
                throw new ParseException("Token Length Error: DTD val too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset >> 1, this.length1 >> 1, 12, this.depth);
        }
        this.ch = this.getCharAfterS();
        if (this.ch != 60) {
            throw new ParseException("Other Error: Invalid char in xml" + this.formatLineNumber());
        }
        int parser_state = 0;
        return parser_state;
    }

    private int process_end_comment() throws ParseException {
        block5: {
            block4: {
                do {
                    this.ch = this.r.getChar();
                    if (!XMLChar.isValidChar(this.ch)) break block4;
                } while (this.ch != 45 || !this.r.skipChar(45));
                break block5;
            }
            throw new ParseException("Error in comment: Invalid Char" + this.formatLineNumber());
        }
        this.length1 = this.offset - this.temp_offset - (this.increment << 1);
        if (this.r.getChar() == 62) {
            if (this.singleByteEncoding) {
                this.writeVTDText(this.temp_offset, this.length1, 6, this.depth);
            } else {
                this.writeVTDText(this.temp_offset >> 1, this.length1 >> 1, 6, this.depth);
            }
            int parser_state = 7;
            return parser_state;
        }
        throw new ParseException("Error in comment: '-->' expected" + this.formatLineNumber());
    }

    private int process_end_doc() throws ParseException, EncodingException, EOFException {
        this.ch = this.getCharAfterS();
        if (this.ch == 60) {
            if (this.r.skipChar(63)) {
                this.temp_offset = this.offset;
                int parser_state = 15;
                return parser_state;
            }
            if (this.r.skipChar(33) && this.r.skipChar(45) && this.r.skipChar(45)) {
                this.temp_offset = this.offset;
                int parser_state = 14;
                return parser_state;
            }
        }
        throw new ParseException("Other Error: XML not terminated properly" + this.formatLineNumber());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int process_end_pi() throws ParseException, EncodingException, EOFException {
        this.ch = this.r.getChar();
        if (!XMLChar.isNameStartChar(this.ch)) throw new ParseException("Error in PI: invalid char in PI target" + this.formatLineNumber());
        if ((this.ch == 120 || this.ch == 88) && (this.r.skipChar(109) || this.r.skipChar(77)) && this.r.skipChar(108) && this.r.skipChar(76)) {
            this.ch = this.r.getChar();
            if (XMLChar.isSpaceChar(this.ch)) throw new ParseException("Error in PI: [xX][mM][lL] not a valid PI target" + this.formatLineNumber());
            if (this.ch == 63) {
                throw new ParseException("Error in PI: [xX][mM][lL] not a valid PI target" + this.formatLineNumber());
            }
        }
        while (XMLChar.isNameChar(this.ch)) {
            this.ch = this.r.getChar();
        }
        this.length1 = this.offset - this.temp_offset - this.increment;
        if (this.singleByteEncoding) {
            if (this.length1 > 1048575) {
                throw new ParseException("Token Length Error:PI name too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset, this.length1, 7, this.depth);
        } else {
            if (this.length1 > 0x1FFFFE) {
                throw new ParseException("Token Length Error:PI name too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset >> 1, this.length1 >> 1, 7, this.depth);
        }
        this.temp_offset = this.offset;
        if (XMLChar.isSpaceChar(this.ch)) {
            block16: {
                this.ch = this.getCharAfterS();
                while (XMLChar.isValidChar(this.ch)) {
                    if (this.ch != 63) {
                        this.ch = this.r.getChar();
                        continue;
                    }
                    break block16;
                }
                throw new ParseException("Error in PI: Invalid char in PI val" + this.formatLineNumber());
            }
            if (!this.r.skipChar(62)) throw new ParseException("Error in PI: invalid termination sequence" + this.formatLineNumber());
            int parser_state = 7;
            this.length1 = this.offset - this.temp_offset - (this.increment << 1);
            if (this.singleByteEncoding) {
                if (this.length1 > 1048575) {
                    throw new ParseException("Token Length Error:PI val too long (>0xfffff)" + this.formatLineNumber());
                }
                this._writeVTD(this.temp_offset, this.length1, 8, this.depth);
                return parser_state;
            } else {
                if (this.length1 > 0x1FFFFE) {
                    throw new ParseException("Token Length Error:PI val too long (>0xfffff)" + this.formatLineNumber());
                }
                this._writeVTD(this.temp_offset >> 1, this.length1 >> 1, 8, this.depth);
            }
            return parser_state;
        }
        if (this.singleByteEncoding) {
            this._writeVTD(this.temp_offset, 0, 8, this.depth);
        } else {
            this._writeVTD(this.temp_offset >> 1, 0, 8, this.depth);
        }
        if (this.ch != 63) throw new ParseException("Error in PI: invalid termination sequence" + this.formatLineNumber());
        if (!this.r.skipChar(62)) throw new ParseException("Error in PI: invalid termination sequence" + this.formatLineNumber());
        return 7;
    }

    private int process_ex_seen() throws ParseException, EncodingException, EOFException {
        int parser_state;
        boolean hasDTD = false;
        this.ch = this.r.getChar();
        switch (this.ch) {
            case 45: {
                if (this.r.skipChar(45)) {
                    this.temp_offset = this.offset;
                    parser_state = 11;
                    break;
                }
                throw new ParseException("Error in comment: Invalid char sequence to start a comment" + this.formatLineNumber());
            }
            case 91: {
                if (this.r.skipChar(67) && this.r.skipChar(68) && this.r.skipChar(65) && this.r.skipChar(84) && this.r.skipChar(65) && this.r.skipChar(91) && this.depth != -1) {
                    this.temp_offset = this.offset;
                    parser_state = 12;
                    break;
                }
                if (this.depth == -1) {
                    throw new ParseException("Error in CDATA: Wrong place for CDATA" + this.formatLineNumber());
                }
                throw new ParseException("Error in CDATA: Invalid char sequence for CDATA" + this.formatLineNumber());
            }
            case 68: {
                if (this.r.skipChar(79) && this.r.skipChar(67) && this.r.skipChar(84) && this.r.skipChar(89) && this.r.skipChar(80) && this.r.skipChar(69) && this.depth == -1 && !hasDTD) {
                    hasDTD = true;
                    this.temp_offset = this.offset;
                    parser_state = 13;
                    break;
                }
                if (hasDTD) {
                    throw new ParseException("Error for DOCTYPE: Only DOCTYPE allowed" + this.formatLineNumber());
                }
                if (this.depth != -1) {
                    throw new ParseException("Error for DOCTYPE: DTD at wrong place" + this.formatLineNumber());
                }
                throw new ParseException("Error for DOCTYPE: Invalid char sequence for DOCTYPE" + this.formatLineNumber());
            }
            default: {
                throw new ParseException("Other Error: Unrecognized char after <!" + this.formatLineNumber());
            }
        }
        return parser_state;
    }

    private void process_attr_name() throws ParseException, EncodingException, EOFException {
        String s1 = null;
        String s2 = null;
        if (this.ch == 120 && this.r.skipChar(109) && this.r.skipChar(108) && this.r.skipChar(110) && this.r.skipChar(115)) {
            this.ch = this.r.getChar();
            if (this.ch == 61 || XMLChar.isSpaceChar(this.ch)) {
                this.default_ns = true;
                this.is_ns = true;
            } else if (this.ch == 58) {
                this.default_ns = false;
                this.is_ns = true;
            }
        }
        while (XMLChar.isNameChar(this.ch)) {
            if (this.ch == 58) {
                this.length2 = this.offset - this.temp_offset - this.increment;
            }
            this.ch = this.r.getChar();
        }
        this.length1 = this.getPrevOffset() - this.temp_offset;
        if (this.is_ns && this.ns && !this.default_ns) {
            if (this.increment == 1 && this.length1 - this.length2 == 6 || this.increment == 2 && this.length1 - this.length2 == 12) {
                this.disallow_xmlns(this.temp_offset + this.length2 + this.increment);
            }
            if (this.increment == 1 && this.length1 - this.length2 == 4 || this.increment == 2 && this.length1 - this.length2 == 8) {
                this.isXML = this.matchXML(this.temp_offset + this.length2 + this.increment);
            }
        }
        this.checkAttributeUniqueness();
        if (this.is_ns) {
            s1 = "Token length overflow error: Attr NS tag prefix or qname length too long";
            s2 = "Token length overflow error: Attr NS prefix or qname length too long";
            if (this.singleByteEncoding) {
                if (this.length2 > 511 || this.length1 > 2047) {
                    throw new ParseException(s1 + this.formatLineNumber());
                }
                this._writeVTD(this.temp_offset, this.length2 << 11 | this.length1, 3, this.depth);
            } else {
                if (this.length2 > 1022 || this.length1 > 4094) {
                    throw new ParseException(s2 + this.formatLineNumber());
                }
                this._writeVTD(this.temp_offset >> 1, this.length2 << 10 | this.length1 >> 1, 3, this.depth);
            }
            if (this.ns && this.length2 != 0 && !this.isXML) {
                long l = (long)(this.length2 << 16 | this.length1) << 32 | (long)this.temp_offset;
                this.nsBuffer3.append(l);
            }
        } else {
            s1 = "Token Length Error: Attr name prefix or qname length too long";
            s2 = "Token Length overflow error: Attr name prefix or qname length too long";
            if (this.singleByteEncoding) {
                if (this.length2 > 511 || this.length1 > 2047) {
                    throw new ParseException("Token Length Error: Attr name prefix or qname length too long" + this.formatLineNumber());
                }
                this._writeVTD(this.temp_offset, this.length2 << 11 | this.length1, 2, this.depth);
            } else {
                if (this.length2 > 1022 || this.length1 > 4094) {
                    throw new ParseException("Token Length overflow error: Attr name prefix or qname length too long" + this.formatLineNumber());
                }
                this._writeVTD(this.temp_offset >> 1, this.length2 << 10 | this.length1 >> 1, 2, this.depth);
            }
        }
        this.length2 = 0;
        if (XMLChar.isSpaceChar(this.ch)) {
            this.ch = this.getCharAfterS();
        }
        if (this.ch != 61) {
            throw new ParseException("Error in attr: invalid char" + this.formatLineNumber());
        }
        this.ch_temp = this.getCharAfterS();
        if (this.ch_temp != 34 && this.ch_temp != 39) {
            throw new ParseException("Error in attr: invalid char (should be ' or \" )" + this.formatLineNumber());
        }
        this.temp_offset = this.offset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int process_attr_val() throws ParseException, EncodingException, EOFException {
        block19: {
            do {
                this.ch = this.r.getChar();
                if (!XMLChar.isValidChar(this.ch) || this.ch == 60) throw new ParseException("Error in attr: Invalid XML char" + this.formatLineNumber());
                if (this.ch == this.ch_temp) break block19;
            } while (this.ch != 38 || XMLChar.isValidChar(this.entityIdentifier()));
            throw new ParseException("Error in attr: Invalid XML char" + this.formatLineNumber());
        }
        this.length1 = this.offset - this.temp_offset - this.increment;
        if (this.ns && this.is_ns) {
            if (!this.default_ns && this.length1 == 0) {
                throw new ParseException(" non-default ns URL can't be empty" + this.formatLineNumber());
            }
            int t = this.identifyNsURL(this.temp_offset, this.length1);
            if (this.isXML) {
                if (t != 1) {
                    throw new ParseException("xmlns:xml can only point to\"http://www.w3.org/XML/1998/namespace\"" + this.formatLineNumber());
                }
            } else {
                if (!this.default_ns) {
                    this.nsBuffer2.append((long)this.temp_offset << 32 | (long)this.length1);
                }
                if (t != 0) {
                    if (t != 1) throw new ParseException("namespace declaration can't point to \"http://www.w3.org/2000/xmlns/\"" + this.formatLineNumber());
                    throw new ParseException("namespace declaration can't point to \"http://www.w3.org/XML/1998/namespace\"" + this.formatLineNumber());
                }
            }
        }
        if (this.singleByteEncoding) {
            if (this.length1 > 1048575) {
                throw new ParseException("Token Length Error: Attr val too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset, this.length1, 4, this.depth);
        } else {
            if (this.length1 > 0x1FFFFE) {
                throw new ParseException("Token Length Error: Attr val too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset >> 1, this.length1 >> 1, 4, this.depth);
        }
        this.isXML = false;
        this.is_ns = false;
        this.ch = this.r.getChar();
        if (XMLChar.isSpaceChar(this.ch)) {
            this.ch = this.getCharAfterS();
            if (XMLChar.isNameStartChar(this.ch)) {
                this.temp_offset = this.offset - this.increment;
                return 3;
            }
        }
        this.helper = true;
        if (this.ch == 47) {
            --this.depth;
            this.helper = false;
            this.ch = this.r.getChar();
        }
        if (this.ch != 62) throw new ParseException("Starting tag Error: Invalid char in starting tag" + this.formatLineNumber());
        if (this.ns) {
            this.nsBuffer1.append(this.nsBuffer3.size - 1);
            if (this.prefixed_attr_count > 0) {
                this.qualifyAttributes();
            }
            if (this.prefixed_attr_count > 1) {
                this.checkQualifiedAttributeUniqueness();
            }
            if (this.currentElementRecord != 0L) {
                this.qualifyElement();
            }
            this.prefixed_attr_count = 0;
        }
        this.attr_count = 0;
        return this.processElementTail(this.helper);
    }

    private int process_pi_tag() throws ParseException, EncodingException, EOFException {
        do {
            this.ch = this.r.getChar();
        } while (XMLChar.isNameChar(this.ch));
        this.length1 = this.offset - this.temp_offset - this.increment;
        if (this.singleByteEncoding) {
            if (this.length1 > 1048575) {
                throw new ParseException("Token Length Error: PI name too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset, this.length1, 7, this.depth);
        } else {
            if (this.length1 > 0x1FFFFE) {
                throw new ParseException("Token Length Error: PI name too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset >> 1, this.length1 >> 1, 7, this.depth);
        }
        if (this.ch == 63) {
            if (this.singleByteEncoding) {
                this._writeVTD(this.temp_offset, 0, 8, this.depth);
            } else {
                this._writeVTD(this.temp_offset >> 1, 0, 8, this.depth);
            }
            if (this.r.skipChar(62)) {
                int parser_state;
                this.temp_offset = this.offset;
                this.ch = this.getCharAfterS();
                if (this.ch == 60) {
                    if (this.ws) {
                        this.addWhiteSpaceRecord();
                    }
                    parser_state = 0;
                } else if (XMLChar.isContentChar(this.ch)) {
                    parser_state = 5;
                } else if (this.ch == 38) {
                    this.entityIdentifier();
                    parser_state = 5;
                } else if (this.ch == 93) {
                    if (this.r.skipChar(93)) {
                        while (this.r.skipChar(93)) {
                        }
                        if (this.r.skipChar(62)) {
                            throw new ParseException("Error in text content: ]]> in text content" + this.formatLineNumber());
                        }
                    }
                    parser_state = 5;
                } else {
                    throw new ParseException("Error in text content: Invalid char" + this.formatLineNumber());
                }
                return parser_state;
            }
            throw new ParseException("Error in PI: invalid termination sequence" + this.formatLineNumber());
        }
        int parser_state = 9;
        return parser_state;
    }

    private int process_pi_val() throws ParseException, EncodingException, EOFException {
        int parser_state;
        if (!XMLChar.isSpaceChar(this.ch)) {
            throw new ParseException("Error in PI: invalid termination sequence" + this.formatLineNumber());
        }
        this.temp_offset = this.offset;
        this.ch = this.r.getChar();
        while (true) {
            if (XMLChar.isValidChar(this.ch)) {
                if (this.ch == 63 && this.r.skipChar(62)) {
                    break;
                }
            } else {
                throw new ParseException("Errors in PI: Invalid char in PI val" + this.formatLineNumber());
            }
            this.ch = this.r.getChar();
        }
        this.length1 = this.offset - this.temp_offset - (this.increment << 1);
        if (this.singleByteEncoding) {
            if (this.length1 > 1048575) {
                throw new ParseException("Token Length Error:PI VAL too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset, this.length1, 8, this.depth);
        } else {
            if (this.length1 > 0x1FFFFE) {
                throw new ParseException("Token Length Error:PI VAL too long (>0xfffff)" + this.formatLineNumber());
            }
            this._writeVTD(this.temp_offset >> 1, this.length1 >> 1, 8, this.depth);
        }
        this.temp_offset = this.offset;
        this.ch = this.getCharAfterS();
        if (this.ch == 60) {
            if (this.ws) {
                this.addWhiteSpaceRecord();
            }
            parser_state = 0;
        } else if (XMLChar.isContentChar(this.ch)) {
            parser_state = 5;
        } else if (this.ch == 38) {
            this.entityIdentifier();
            parser_state = 5;
        } else if (this.ch == 93) {
            if (this.r.skipChar(93)) {
                while (this.r.skipChar(93)) {
                }
                if (this.r.skipChar(62)) {
                    throw new ParseException("Error in text content: ]]> in text content" + this.formatLineNumber());
                }
            }
            parser_state = 5;
        } else {
            throw new ParseException("Error in text content: Invalid char" + this.formatLineNumber());
        }
        return parser_state;
    }

    private int process_qm_seen() throws ParseException, EncodingException, EOFException {
        this.temp_offset = this.offset;
        this.ch = this.r.getChar();
        if (XMLChar.isNameStartChar(this.ch)) {
            if ((this.ch == 120 || this.ch == 88) && (this.r.skipChar(109) || this.r.skipChar(77)) && (this.r.skipChar(108) || this.r.skipChar(76))) {
                this.ch = this.r.getChar();
                if (this.ch == 63 || XMLChar.isSpaceChar(this.ch)) {
                    throw new ParseException("Error in PI: [xX][mM][lL] not a valid PI targetname" + this.formatLineNumber());
                }
                this.offset = this.getPrevOffset();
            }
            return 8;
        }
        throw new ParseException("Other Error: First char after <? invalid" + this.formatLineNumber());
    }

    private int process_start_doc() throws ParseException, EncodingException, EOFException {
        int c = this.r.getChar();
        if (c == 60) {
            this.temp_offset = this.offset;
            if (this.r.skipChar(63) && (this.r.skipChar(120) || this.r.skipChar(88)) && (this.r.skipChar(109) || this.r.skipChar(77)) && (this.r.skipChar(108) || this.r.skipChar(76))) {
                if (this.r.skipChar(32) || this.r.skipChar(9) || this.r.skipChar(10) || this.r.skipChar(13)) {
                    this.ch = this.getCharAfterS();
                    this.temp_offset = this.offset;
                    return 10;
                }
                if (this.r.skipChar(63)) {
                    throw new ParseException("Error in XML decl: Premature ending" + this.formatLineNumber());
                }
            }
            this.offset = this.temp_offset;
            return 0;
        }
        if ((c == 32 || c == 10 || c == 13 || c == 9) && this.getCharAfterS() == 60) {
            return 0;
        }
        throw new ParseException("Other Error: XML not starting properly" + this.formatLineNumber());
    }

    public void setDoc(byte[] ba) {
        this.setDoc(ba, 0, ba.length);
    }

    public void setDoc(byte[] ba, int os, int len) {
        if (ba == null || os < 0 || len == 0 || ba.length < os + len) {
            throw new IllegalArgumentException("Illegal argument for setDoc");
        }
        this.br = false;
        this.depth = -1;
        this.increment = 1;
        this.BOM_detected = false;
        this.must_utf_8 = false;
        this.ch_temp = 0;
        this.ch = 0;
        this.temp_offset = 0;
        this.XMLDoc = ba;
        this.docOffset = this.offset = os;
        this.docLen = len;
        this.endOffset = os + len;
        this.last_depth = 0;
        this.last_l4_index = 0;
        this.last_l3_index = 0;
        this.last_l2_index = 0;
        this.last_l1_index = 0;
        this.currentElementRecord = 0L;
        this.nsBuffer1.size = 0;
        this.nsBuffer2.size = 0;
        this.nsBuffer3.size = 0;
        this.r = new UTF8Reader();
        if (this.shallowDepth) {
            int a;
            int i1 = 8;
            int i2 = 9;
            int i3 = 11;
            if (this.docLen <= 1024) {
                a = 6;
                i1 = 5;
                i2 = 5;
                i3 = 5;
            } else if (this.docLen <= 4096) {
                a = 7;
                i1 = 6;
                i2 = 6;
                i3 = 6;
            } else if (this.docLen <= 16384) {
                a = 8;
                i1 = 7;
                i2 = 7;
                i3 = 7;
            } else {
                a = this.docLen <= 65536 ? 11 : (this.docLen <= 262144 ? 12 : 15);
            }
            this.VTDBuffer = new FastLongBuffer(a, len >> a + 1);
            this.l1Buffer = new FastLongBuffer(i1);
            this.l2Buffer = new FastLongBuffer(i2);
            this.l3Buffer = new FastIntBuffer(i3);
        } else {
            int a;
            int i1 = 7;
            int i2 = 9;
            int i3 = 11;
            int i4 = 11;
            int i5 = 11;
            if (this.docLen <= 1024) {
                a = 6;
                i1 = 5;
                i2 = 5;
                i3 = 5;
                i4 = 5;
                i5 = 5;
            } else if (this.docLen <= 4096) {
                a = 7;
                i1 = 6;
                i2 = 6;
                i3 = 6;
                i4 = 6;
                i5 = 6;
            } else if (this.docLen <= 16384) {
                a = 8;
                i1 = 7;
                i2 = 7;
                i3 = 7;
                i4 = 7;
                i5 = 7;
            } else if (this.docLen <= 65536) {
                a = 11;
                i2 = 8;
                i3 = 8;
                i4 = 8;
                i5 = 8;
            } else if (this.docLen <= 262144) {
                a = 12;
                i1 = 8;
                i2 = 9;
                i3 = 9;
                i4 = 9;
                i5 = 9;
            } else {
                a = 15;
            }
            this.VTDBuffer = new FastLongBuffer(a, len >> a + 1);
            this.l1Buffer = new FastLongBuffer(i1);
            this.l2Buffer = new FastLongBuffer(i2);
            this._l3Buffer = new FastLongBuffer(i3);
            this._l4Buffer = new FastLongBuffer(i4);
            this._l5Buffer = new FastIntBuffer(i5);
        }
    }

    public void setDoc_BR(byte[] ba) {
        this.setDoc_BR(ba, 0, ba.length);
    }

    public void setDoc_BR(byte[] ba, int os, int len) {
        if (ba == null || os < 0 || len == 0 || ba.length < os + len) {
            throw new IllegalArgumentException("Illegal argument for setDoc_BR");
        }
        this.br = true;
        this.depth = -1;
        this.increment = 1;
        this.BOM_detected = false;
        this.must_utf_8 = false;
        this.ch_temp = 0;
        this.ch = 0;
        this.temp_offset = 0;
        this.XMLDoc = ba;
        this.docOffset = this.offset = os;
        this.docLen = len;
        this.endOffset = os + len;
        this.last_l4_index = 0;
        this.last_l3_index = 0;
        this.last_depth = 0;
        this.last_l2_index = 0;
        this.last_l1_index = 0;
        this.currentElementRecord = 0L;
        this.nsBuffer1.size = 0;
        this.nsBuffer2.size = 0;
        this.nsBuffer3.size = 0;
        this.r = new UTF8Reader();
        if (this.shallowDepth) {
            int a;
            int i1 = 8;
            int i2 = 9;
            int i3 = 11;
            if (this.docLen <= 1024) {
                a = 6;
                i1 = 5;
                i2 = 5;
                i3 = 5;
            } else if (this.docLen <= 4096) {
                a = 7;
                i1 = 6;
                i2 = 6;
                i3 = 6;
            } else if (this.docLen <= 16384) {
                a = 8;
                i1 = 7;
                i2 = 7;
                i3 = 7;
            } else if (this.docLen <= 65536) {
                a = 11;
                i2 = 8;
                i3 = 8;
            } else {
                a = this.docLen <= 262144 ? 12 : 15;
            }
            if (this.VTDBuffer == null) {
                this.VTDBuffer = new FastLongBuffer(a, len >> a + 1);
                this.l1Buffer = new FastLongBuffer(i1);
                this.l2Buffer = new FastLongBuffer(i2);
                this.l3Buffer = new FastIntBuffer(i3);
            } else {
                this.VTDBuffer.size = 0;
                this.l1Buffer.size = 0;
                this.l2Buffer.size = 0;
                this.l3Buffer.size = 0;
            }
        } else {
            int a;
            int i1 = 8;
            int i2 = 9;
            int i3 = 11;
            int i4 = 11;
            int i5 = 11;
            if (this.docLen <= 1024) {
                a = 6;
                i1 = 5;
                i2 = 5;
                i3 = 5;
                i4 = 5;
                i5 = 5;
            } else if (this.docLen <= 4096) {
                a = 7;
                i1 = 6;
                i2 = 6;
                i3 = 6;
                i4 = 6;
                i5 = 6;
            } else if (this.docLen <= 16384) {
                a = 8;
                i1 = 7;
                i2 = 7;
                i3 = 7;
            } else if (this.docLen <= 65536) {
                a = 11;
                i2 = 8;
                i3 = 8;
                i4 = 8;
                i5 = 8;
            } else if (this.docLen <= 262144) {
                a = 12;
                i1 = 8;
                i2 = 9;
                i3 = 9;
                i4 = 9;
                i5 = 9;
            } else if (this.docLen <= 0x100000) {
                a = 12;
                i1 = 8;
                i3 = 10;
                i4 = 10;
                i5 = 10;
            } else {
                a = 15;
                i1 = 8;
            }
            if (this.VTDBuffer == null) {
                this.VTDBuffer = new FastLongBuffer(a, len >> a + 1);
                this.l1Buffer = new FastLongBuffer(i1);
                this.l2Buffer = new FastLongBuffer(i2);
                this._l3Buffer = new FastLongBuffer(i3);
                this._l4Buffer = new FastLongBuffer(i4);
                this._l5Buffer = new FastIntBuffer(i5);
            } else {
                this.VTDBuffer.size = 0;
                this.l1Buffer.size = 0;
                this.l2Buffer.size = 0;
                this._l3Buffer.size = 0;
                this._l4Buffer.size = 0;
                this._l5Buffer.size = 0;
            }
        }
    }

    public void writeIndex(OutputStream os) throws IOException, IndexWriteException {
        if (this.shallowDepth) {
            IndexHandler.writeIndex_L3((byte)1, this.encoding, this.ns, true, this.VTDDepth, 3, this.rootIndex, this.XMLDoc, this.docOffset, this.docLen, this.VTDBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, os);
        } else {
            IndexHandler.writeIndex_L5((byte)1, this.encoding, this.ns, true, this.VTDDepth, 5, this.rootIndex, this.XMLDoc, this.docOffset, this.docLen, this.VTDBuffer, this.l1Buffer, this.l2Buffer, this._l3Buffer, this._l4Buffer, this._l5Buffer, os);
        }
    }

    public void writeSeparateIndex(OutputStream os) throws IOException, IndexWriteException {
        if (this.shallowDepth) {
            IndexHandler.writeSeparateIndex_L3((byte)2, this.encoding, this.ns, true, this.VTDDepth, 3, this.rootIndex, this.docOffset, this.docLen, this.VTDBuffer, this.l1Buffer, this.l2Buffer, this.l3Buffer, os);
        } else {
            IndexHandler.writeSeparateIndex_L5((byte)2, this.encoding, this.ns, true, this.VTDDepth, 5, this.rootIndex, this.docOffset, this.docLen, this.VTDBuffer, this.l1Buffer, this.l2Buffer, this._l3Buffer, this._l4Buffer, this._l5Buffer, os);
        }
    }

    public void writeIndex(String fileName) throws IOException, IndexWriteException {
        FileOutputStream fos = new FileOutputStream(fileName);
        this.writeIndex(fos);
        fos.close();
    }

    public void writeSeparateIndex(String fileName) throws IOException, IndexWriteException {
        FileOutputStream fos = new FileOutputStream(fileName);
        this.writeSeparateIndex(fos);
        fos.close();
    }

    private void writeVTD(int offset, int length, int token_type, int depth) {
        this.VTDBuffer.append((long)(token_type << 28 | (depth & 0xFF) << 20 | length) << 32 | (long)offset);
        switch (depth) {
            case 0: {
                this.rootIndex = this.VTDBuffer.size - 1;
                break;
            }
            case 1: {
                if (this.last_depth == 1) {
                    this.l1Buffer.append((long)this.last_l1_index << 32 | 0xFFFFFFFFL);
                } else if (this.last_depth == 2) {
                    this.l2Buffer.append((long)this.last_l2_index << 32 | 0xFFFFFFFFL);
                }
                this.last_l1_index = this.VTDBuffer.size - 1;
                this.last_depth = 1;
                break;
            }
            case 2: {
                if (this.last_depth == 1) {
                    this.l1Buffer.append(((long)this.last_l1_index << 32) + (long)this.l2Buffer.size);
                } else if (this.last_depth == 2) {
                    this.l2Buffer.append((long)this.last_l2_index << 32 | 0xFFFFFFFFL);
                }
                this.last_l2_index = this.VTDBuffer.size - 1;
                this.last_depth = 2;
                break;
            }
            case 3: {
                this.l3Buffer.append(this.VTDBuffer.size - 1);
                if (this.last_depth == 2) {
                    this.l2Buffer.append(((long)this.last_l2_index << 32) + (long)this.l3Buffer.size - 1L);
                }
                this.last_depth = 3;
                break;
            }
        }
    }

    private void _writeVTD(int offset, int length, int token_type, int depth) {
        this.VTDBuffer.append((long)(token_type << 28 | (depth & 0xFF) << 20 | length) << 32 | (long)offset);
    }

    private void writeVTDText(int offset, int length, int token_type, int depth) {
        if (length > 1048575) {
            int k;
            int r_offset = offset;
            for (k = length; k > 1048575; k -= 1048575) {
                this.VTDBuffer.append((long)(token_type << 28 | (depth & 0xFF) << 20 | 0xFFFFF) << 32 | (long)r_offset);
                r_offset += 1048575;
            }
            this.VTDBuffer.append((long)(token_type << 28 | (depth & 0xFF) << 20 | k) << 32 | (long)r_offset);
        } else {
            this.VTDBuffer.append((long)(token_type << 28 | (depth & 0xFF) << 20 | length) << 32 | (long)offset);
        }
    }

    private void writeVTD_L5(int offset, int length, int token_type, int depth) {
        this.VTDBuffer.append((long)(token_type << 28 | (depth & 0xFF) << 20 | length) << 32 | (long)offset);
        switch (depth) {
            case 0: {
                this.rootIndex = this.VTDBuffer.size - 1;
                break;
            }
            case 1: {
                if (this.last_depth == 1) {
                    this.l1Buffer.append((long)this.last_l1_index << 32 | 0xFFFFFFFFL);
                } else if (this.last_depth == 2) {
                    this.l2Buffer.append((long)this.last_l2_index << 32 | 0xFFFFFFFFL);
                } else if (this.last_depth == 3) {
                    this._l3Buffer.append((long)this.last_l3_index << 32 | 0xFFFFFFFFL);
                } else if (this.last_depth == 4) {
                    this._l4Buffer.append((long)this.last_l4_index << 32 | 0xFFFFFFFFL);
                }
                this.last_l1_index = this.VTDBuffer.size - 1;
                this.last_depth = 1;
                break;
            }
            case 2: {
                if (this.last_depth == 1) {
                    this.l1Buffer.append(((long)this.last_l1_index << 32) + (long)this.l2Buffer.size);
                } else if (this.last_depth == 2) {
                    this.l2Buffer.append((long)this.last_l2_index << 32 | 0xFFFFFFFFL);
                } else if (this.last_depth == 3) {
                    this._l3Buffer.append((long)this.last_l3_index << 32 | 0xFFFFFFFFL);
                } else if (this.last_depth == 4) {
                    this._l4Buffer.append((long)this.last_l4_index << 32 | 0xFFFFFFFFL);
                }
                this.last_l2_index = this.VTDBuffer.size - 1;
                this.last_depth = 2;
                break;
            }
            case 3: {
                if (this.last_depth == 2) {
                    this.l2Buffer.append(((long)this.last_l2_index << 32) + (long)this._l3Buffer.size);
                } else if (this.last_depth == 3) {
                    this._l3Buffer.append((long)this.last_l3_index << 32 | 0xFFFFFFFFL);
                } else if (this.last_depth == 4) {
                    this._l4Buffer.append((long)this.last_l4_index << 32 | 0xFFFFFFFFL);
                }
                this.last_l3_index = this.VTDBuffer.size - 1;
                this.last_depth = 3;
                break;
            }
            case 4: {
                if (this.last_depth == 3) {
                    this._l3Buffer.append(((long)this.last_l3_index << 32) + (long)this._l4Buffer.size);
                } else if (this.last_depth == 4) {
                    this._l4Buffer.append((long)this.last_l4_index << 32 | 0xFFFFFFFFL);
                }
                this.last_l4_index = this.VTDBuffer.size - 1;
                this.last_depth = 4;
                break;
            }
            case 5: {
                this._l5Buffer.append(this.VTDBuffer.size - 1);
                if (this.last_depth == 4) {
                    this._l4Buffer.append(((long)this.last_l4_index << 32) + (long)this._l5Buffer.size - 1L);
                }
                this.last_depth = 5;
            }
        }
    }

    private void qualifyElement() throws ParseException {
        int preLen = (int)((this.currentElementRecord & 0xFFFF000000000000L) >> 48);
        int preOs = (int)this.currentElementRecord;
        for (int i = this.nsBuffer3.size - 1; i >= 0; --i) {
            int k;
            int t = this.nsBuffer3.upper32At(i);
            if ((t & 0xFFFF) - (t >> 16) != preLen) continue;
            int os = this.nsBuffer3.lower32At(i) + (t >> 16) + this.increment;
            for (k = 0; k < preLen - this.increment && this.XMLDoc[os + k] == this.XMLDoc[preOs + k]; ++k) {
            }
            if (k != preLen - this.increment) continue;
            return;
        }
        if (this.checkPrefix(preOs, preLen)) {
            return;
        }
        throw new ParseException("Name space qualification Exception: Element not qualified\n" + this.formatLineNumber((int)this.currentElementRecord));
    }

    private boolean checkPrefix(int os, int len) {
        return this.encoding < 63 ? len == 4 && this.XMLDoc[os] == 120 && this.XMLDoc[os + 1] == 109 && this.XMLDoc[os + 2] == 108 : (this.encoding == 63 ? len == 8 && this.XMLDoc[os] == 0 && this.XMLDoc[os + 1] == 120 && this.XMLDoc[os + 2] == 0 && this.XMLDoc[os + 3] == 109 && this.XMLDoc[os + 4] == 0 && this.XMLDoc[os + 5] == 108 : len == 8 && this.XMLDoc[os] == 120 && this.XMLDoc[os + 1] == 0 && this.XMLDoc[os + 2] == 109 && this.XMLDoc[os + 3] == 0 && this.XMLDoc[os + 4] == 108 && this.XMLDoc[os + 5] == 0);
    }

    private boolean checkPrefix2(int os, int len) {
        return this.encoding < 63 ? len == 5 && this.XMLDoc[os] == 120 && this.XMLDoc[os + 1] == 109 && this.XMLDoc[os + 2] == 108 && this.XMLDoc[os + 3] == 110 && this.XMLDoc[os + 4] == 115 : (this.encoding == 63 ? len == 10 && this.XMLDoc[os] == 0 && this.XMLDoc[os + 1] == 120 && this.XMLDoc[os + 2] == 0 && this.XMLDoc[os + 3] == 109 && this.XMLDoc[os + 4] == 0 && this.XMLDoc[os + 5] == 108 && this.XMLDoc[os + 6] == 0 && this.XMLDoc[os + 7] == 110 && this.XMLDoc[os + 8] == 0 && this.XMLDoc[os + 9] == 115 : len == 10 && this.XMLDoc[os] == 120 && this.XMLDoc[os + 1] == 0 && this.XMLDoc[os + 2] == 109 && this.XMLDoc[os + 3] == 0 && this.XMLDoc[os + 4] == 108 && this.XMLDoc[os + 5] == 0 && this.XMLDoc[os + 6] == 110 && this.XMLDoc[os + 3] == 0 && this.XMLDoc[os + 8] == 115 && this.XMLDoc[os + 5] == 0);
    }

    private long _getCharResolved(int byte_offset) {
        int ch = 0;
        int val = 0;
        long inc = 2 << this.increment - 1;
        long l = this.r._getChar(byte_offset);
        ch = (int)l;
        if (ch != 38) {
            return l;
        }
        ch = this.getCharUnit(byte_offset += this.increment);
        byte_offset += this.increment;
        switch (ch) {
            case 35: {
                ch = this.getCharUnit(byte_offset);
                if (ch == 120) {
                    while (true) {
                        inc += (long)this.increment;
                        ch = this.getCharUnit(byte_offset += this.increment);
                        if (ch >= 48 && ch <= 57) {
                            val = (val << 4) + (ch - 48);
                            continue;
                        }
                        if (ch >= 97 && ch <= 102) {
                            val = (val << 4) + (ch - 97 + 10);
                            continue;
                        }
                        if (ch >= 65 && ch <= 70) {
                            val = (val << 4) + (ch - 65 + 10);
                            continue;
                        }
                        if (ch == 59) break;
                    }
                    inc += (long)this.increment;
                    break;
                }
                while (true) {
                    ch = this.getCharUnit(byte_offset);
                    byte_offset += this.increment;
                    inc += (long)this.increment;
                    if (ch >= 48 && ch <= 57) {
                        val = val * 10 + (ch - 48);
                        continue;
                    }
                    if (ch == 59) break;
                }
                break;
            }
            case 97: {
                ch = this.getCharUnit(byte_offset);
                if (this.encoding < 63) {
                    if (ch == 109) {
                        if (this.getCharUnit(byte_offset + 1) != 112 || this.getCharUnit(byte_offset + 2) != 59) break;
                        inc = 5L;
                        val = 38;
                        break;
                    }
                    if (ch != 112 || this.getCharUnit(byte_offset + 1) != 111 || this.getCharUnit(byte_offset + 2) != 115 || this.getCharUnit(byte_offset + 3) != 59) break;
                    inc = 6L;
                    val = 39;
                    break;
                }
                if (ch == 109) {
                    if (this.getCharUnit(byte_offset + 2) != 112 || this.getCharUnit(byte_offset + 4) != 59) break;
                    inc = 10L;
                    val = 38;
                    break;
                }
                if (ch != 112 || this.getCharUnit(byte_offset + 2) != 111 || this.getCharUnit(byte_offset + 4) != 115 || this.getCharUnit(byte_offset + 6) != 59) break;
                inc = 12L;
                val = 39;
                break;
            }
            case 113: {
                if (this.encoding < 63) {
                    if (this.getCharUnit(byte_offset) != 117 || this.getCharUnit(byte_offset + 1) != 111 || this.getCharUnit(byte_offset + 2) != 116 || this.getCharUnit(byte_offset + 3) != 59) break;
                    inc = 6L;
                    val = 34;
                    break;
                }
                if (this.getCharUnit(byte_offset) != 117 || this.getCharUnit(byte_offset + 2) != 111 || this.getCharUnit(byte_offset + 4) != 116 || this.getCharUnit(byte_offset + 6) != 59) break;
                inc = 12L;
                val = 34;
                break;
            }
            case 108: {
                if (this.encoding < 63) {
                    if (this.getCharUnit(byte_offset) != 116 || this.getCharUnit(byte_offset + 1) != 59) break;
                    inc = 4L;
                    val = 60;
                    break;
                }
                if (this.getCharUnit(byte_offset) != 116 || this.getCharUnit(byte_offset + 2) != 59) break;
                inc = 8L;
                val = 60;
                break;
            }
            case 103: {
                if (this.encoding < 63) {
                    if (this.getCharUnit(byte_offset) != 116 || this.getCharUnit(byte_offset + 1) != 59) break;
                    inc = 4L;
                    val = 62;
                    break;
                }
                if (this.getCharUnit(byte_offset) != 116 || this.getCharUnit(byte_offset + 2) != 59) break;
                inc = 8L;
                val = 62;
            }
        }
        return (long)val | inc << 32;
    }

    private int getCharUnit(int byte_offset) {
        return this.encoding <= 2 ? this.XMLDoc[byte_offset] & 0xFF : (this.encoding < 63 ? (int)this.r.decode(byte_offset) : (this.encoding == 63 ? this.XMLDoc[byte_offset] << 8 | this.XMLDoc[byte_offset + 1] : this.XMLDoc[byte_offset + 1] << 8 | this.XMLDoc[byte_offset]));
    }

    private boolean matchURL(int bos1, int len1, int bos2, int len2) {
        int i2;
        long l2;
        long l1;
        int i1 = bos1;
        int i3 = bos1 + len1;
        int i4 = bos2 + len2;
        for (i2 = bos2; i1 < i3 && i2 < i4; i1 += (int)(l1 >> 32), i2 += (int)(l2 >> 32)) {
            l1 = this._getCharResolved(i1);
            if ((int)l1 == (int)(l2 = this._getCharResolved(i2))) continue;
            return false;
        }
        return i1 == i3 && i2 == i4;
    }

    private void checkAttributeUniqueness() throws ParseException {
        boolean unique = true;
        for (int i = 0; i < this.attr_count; ++i) {
            boolean unequal = false;
            int prevLen = (int)this.attr_name_array[i];
            if (this.length1 == prevLen) {
                int prevOffset = (int)(this.attr_name_array[i] >> 32);
                for (int j = 0; j < prevLen; ++j) {
                    if (this.XMLDoc[prevOffset + j] == this.XMLDoc[this.temp_offset + j]) continue;
                    unequal = true;
                    break;
                }
            } else {
                unequal = true;
            }
            unique = unique && unequal;
        }
        if (!unique && this.attr_count != 0) {
            throw new ParseException("Error in attr: Attr name not unique" + this.formatLineNumber());
        }
        unique = true;
        if (this.attr_count < this.attr_name_array.length) {
            this.attr_name_array[this.attr_count] = (long)this.temp_offset << 32 | (long)this.length1;
            ++this.attr_count;
        } else {
            long[] temp_array = this.attr_name_array;
            this.attr_name_array = new long[this.attr_count + 16];
            System.arraycopy(temp_array, 0, this.attr_name_array, 0, this.attr_count);
            this.attr_name_array[this.attr_count] = (long)this.temp_offset << 32 | (long)this.length1;
            ++this.attr_count;
        }
        if (this.ns && !this.is_ns && this.length2 != 0) {
            if (this.increment == 1 && this.length2 == 3 && this.matchXML(this.temp_offset) || this.increment == 2 && this.length2 == 6 && this.matchXML(this.temp_offset)) {
                return;
            }
            if (this.prefixed_attr_count < this.prefixed_attr_name_array.length) {
                this.prefixed_attr_name_array[this.prefixed_attr_count] = (long)this.temp_offset << 32 | (long)(this.length2 << 16) | (long)this.length1;
                ++this.prefixed_attr_count;
            } else {
                long[] temp_array1 = this.prefixed_attr_name_array;
                this.prefixed_attr_name_array = new long[this.prefixed_attr_count + 16];
                this.prefix_URL_array = new int[this.prefixed_attr_count + 16];
                System.arraycopy(temp_array1, 0, this.prefixed_attr_name_array, 0, this.prefixed_attr_count);
                this.prefixed_attr_name_array[this.prefixed_attr_count] = (long)this.temp_offset << 32 | (long)(this.length2 << 16) | (long)this.length1;
                ++this.prefixed_attr_count;
            }
        }
    }

    private void handleOtherTextChar(int ch) throws ParseException {
        if (ch == 38) {
            if (!XMLChar.isValidChar(this.entityIdentifier())) {
                throw new ParseException("Error in text content: Invalid char in text content " + this.formatLineNumber());
            }
        } else if (ch == 93) {
            if (this.r.skipChar(93)) {
                while (this.r.skipChar(93)) {
                }
                if (this.r.skipChar(62)) {
                    throw new ParseException("Error in text content: ]]> in text content" + this.formatLineNumber());
                }
            }
        } else {
            throw new ParseException("Error in text content: Invalid char in text content " + this.formatLineNumber());
        }
    }

    private void handleOtherTextChar2(int ch) throws ParseException {
        if (ch == 38) {
            this.entityIdentifier();
        } else if (ch == 93) {
            if (this.r.skipChar(93)) {
                while (this.r.skipChar(93)) {
                }
                if (this.r.skipChar(62)) {
                    throw new ParseException("Error in text content: ]]> in text content" + this.formatLineNumber());
                }
            }
        } else {
            throw new ParseException("Error in text content: Invalid char" + this.formatLineNumber());
        }
    }

    private int processElementTail(boolean helper) throws ParseException, EncodingException, EOFException {
        if (this.depth != -1) {
            this.temp_offset = this.offset;
            this.ch = this.getCharAfterS();
            if (this.ch == 60) {
                if (this.ws) {
                    this.addWhiteSpaceRecord();
                }
                if (this.r.skipChar(47)) {
                    if (helper) {
                        this.length1 = this.offset - this.temp_offset - (this.increment << 1);
                        if (this.singleByteEncoding) {
                            this.writeVTDText(this.temp_offset, this.length1, 5, this.depth);
                        } else {
                            this.writeVTDText(this.temp_offset >> 1, this.length1 >> 1, 5, this.depth);
                        }
                    }
                    return 2;
                }
                return 0;
            }
            if (XMLChar.isContentChar(this.ch)) {
                return 5;
            }
            this.handleOtherTextChar2(this.ch);
            return 5;
        }
        return 7;
    }

    class WIN1258Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return WIN1258.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == WIN1258.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = WIN1258.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return WIN1258.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class WIN1257Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return WIN1257.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == WIN1257.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = WIN1257.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return WIN1257.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class WIN1256Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return WIN1256.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == WIN1256.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = WIN1256.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return WIN1256.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class WIN1255Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return WIN1255.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == WIN1255.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = WIN1255.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return WIN1255.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class WIN1254Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return WIN1254.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == WIN1254.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = WIN1254.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return WIN1254.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class WIN1253Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return WIN1253.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == WIN1253.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = WIN1253.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return WIN1253.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class WIN1252Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return WIN1252.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == WIN1252.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = WIN1252.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return WIN1252.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class WIN1251Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return WIN1251.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == WIN1251.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = WIN1251.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return WIN1251.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class WIN1250Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return WIN1250.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == WIN1250.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = WIN1250.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return WIN1250.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class UTF8Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            byte temp = VTDGen.this.XMLDoc[VTDGen.this.offset];
            if (temp >= 0) {
                ++VTDGen.this.offset;
                return temp;
            }
            return this.handleUTF8(temp);
        }

        private int handleUTF8(int temp) throws EncodingException, ParseException {
            int a;
            int d;
            int c;
            switch (UTF8Char.byteCount(temp &= 0xFF)) {
                case 2: {
                    c = 31;
                    d = 6;
                    a = 1;
                    break;
                }
                case 3: {
                    c = 15;
                    d = 12;
                    a = 2;
                    break;
                }
                case 4: {
                    c = 7;
                    d = 18;
                    a = 3;
                    break;
                }
                case 5: {
                    c = 3;
                    d = 24;
                    a = 4;
                    break;
                }
                case 6: {
                    c = 1;
                    d = 30;
                    a = 5;
                    break;
                }
                default: {
                    throw new ParseException("UTF 8 encoding error: should never happen");
                }
            }
            int val = (temp & c) << d;
            for (int i = a - 1; i >= 0; --i) {
                temp = VTDGen.this.XMLDoc[VTDGen.this.offset + a - i];
                if ((temp & 0xC0) != 128) {
                    throw new ParseException("UTF 8 encoding error: should never happen");
                }
                val |= (temp & 0x3F) << (i << 2) + (i << 1);
            }
            VTDGen.this.offset += a + 1;
            return val;
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, EncodingException, ParseException {
            byte temp = VTDGen.this.XMLDoc[VTDGen.this.offset];
            if (temp >= 0) {
                if (ch == temp) {
                    ++VTDGen.this.offset;
                    return true;
                }
                return false;
            }
            return this.skipUTF8(temp, ch);
        }

        private boolean skipUTF8(int temp, int ch) throws EncodingException, ParseException {
            int a;
            int d;
            int c;
            switch (UTF8Char.byteCount(temp &= 0xFF)) {
                case 2: {
                    c = 31;
                    d = 6;
                    a = 1;
                    break;
                }
                case 3: {
                    c = 15;
                    d = 12;
                    a = 2;
                    break;
                }
                case 4: {
                    c = 7;
                    d = 18;
                    a = 3;
                    break;
                }
                case 5: {
                    c = 3;
                    d = 24;
                    a = 4;
                    break;
                }
                case 6: {
                    c = 1;
                    d = 30;
                    a = 5;
                    break;
                }
                default: {
                    throw new ParseException("UTF 8 encoding error: should never happen");
                }
            }
            int val = (temp & c) << d;
            for (int i = a - 1; i >= 0; --i) {
                temp = VTDGen.this.XMLDoc[VTDGen.this.offset + a - i];
                if ((temp & 0xC0) != 128) {
                    throw new ParseException("UTF 8 encoding error: should never happen");
                }
                val |= (temp & 0x3F) << (i << 2) + (i << 1);
            }
            if (val == ch) {
                VTDGen.this.offset += a + 1;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            byte temp = VTDGen.this.XMLDoc[offset];
            if (temp >= 0) {
                if (temp == 13) {
                    if (VTDGen.this.XMLDoc[offset + 1] == 10) {
                        return 0x20000000AL;
                    }
                    return 0x10000000AL;
                }
                return (long)temp | 0x100000000L;
            }
            return this.handle_utf8(temp, offset);
        }

        private long handle_utf8(int temp, int offset) {
            int c = 0;
            int d = 0;
            int a = 0;
            switch (UTF8Char.byteCount(temp & 0xFF)) {
                case 2: {
                    c = 31;
                    d = 6;
                    a = 1;
                    break;
                }
                case 3: {
                    c = 15;
                    d = 12;
                    a = 2;
                    break;
                }
                case 4: {
                    c = 7;
                    d = 18;
                    a = 3;
                    break;
                }
                case 5: {
                    c = 3;
                    d = 24;
                    a = 4;
                    break;
                }
                case 6: {
                    c = 1;
                    d = 30;
                    a = 5;
                }
            }
            long val = (temp & c) << d;
            for (int i = a - 1; i >= 0; --i) {
                temp = VTDGen.this.XMLDoc[offset + a - i];
                val |= (long)((temp & 0x3F) << (i << 2) + (i << 1));
            }
            return val | (long)(a + 1) << 32;
        }

        @Override
        public final char decode(int offset) {
            return '\u0000';
        }
    }

    class UTF16LEReader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            int val = 0;
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            int temp = (VTDGen.this.XMLDoc[VTDGen.this.offset + 1] & 0xFF) << 8 | VTDGen.this.XMLDoc[VTDGen.this.offset] & 0xFF;
            if (temp < 55296 || temp > 57343) {
                VTDGen.this.offset += 2;
                return temp;
            }
            if (temp < 55296 || temp > 56319) {
                throw new EncodingException("UTF 16 LE encoding error: should never happen");
            }
            val = temp;
            temp = (VTDGen.this.XMLDoc[VTDGen.this.offset + 3] & 0xFF) << 8 | VTDGen.this.XMLDoc[VTDGen.this.offset + 2] & 0xFF;
            if (temp < 56320 || temp > 57343) {
                throw new EncodingException("UTF 16 LE encoding error: should never happen");
            }
            val = (val - 55296 << 10) + (temp - 56320) + 65536;
            VTDGen.this.offset += 4;
            return val;
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, EncodingException, ParseException {
            int temp = (VTDGen.this.XMLDoc[VTDGen.this.offset + 1] & 0xFF) << 8 | VTDGen.this.XMLDoc[VTDGen.this.offset] & 0xFF;
            if (temp < 55296 || temp > 57343) {
                if (temp == ch) {
                    VTDGen.this.offset += 2;
                    return true;
                }
                return false;
            }
            if (temp < 55296 || temp > 56319) {
                throw new EncodingException("UTF 16 LE encoding error: should never happen");
            }
            int val = temp;
            temp = (VTDGen.this.XMLDoc[VTDGen.this.offset + 3] & 0xFF) << 8 | VTDGen.this.XMLDoc[VTDGen.this.offset + 2] & 0xFF;
            if (temp < 56320 || temp > 57343) {
                throw new EncodingException("UTF 16 LE encoding error: should never happen");
            }
            if ((val = (val - 55296 << 10) + (temp - 56320) + 65536) == ch) {
                VTDGen.this.offset += 4;
                return true;
            }
            return false;
        }

        @Override
        public final char decode(int offset) {
            return '\u0000';
        }

        @Override
        public final long _getChar(int offset) {
            int temp = (VTDGen.this.XMLDoc[offset + 1] & 0xFF) << 8 | VTDGen.this.XMLDoc[offset] & 0xFF;
            if (temp < 56320 || temp > 57343) {
                if (temp == 13) {
                    if (VTDGen.this.XMLDoc[offset + 2] == 10 && VTDGen.this.XMLDoc[offset + 3] == 0) {
                        return 0x40000000AL;
                    }
                    return 0x20000000AL;
                }
                return (long)temp | 0x200000000L;
            }
            int val = temp;
            temp = (VTDGen.this.XMLDoc[offset + 3] & 0xFF) << 8 | VTDGen.this.XMLDoc[offset + 2] & 0xFF;
            val = (temp - 55296 << 10) + (val - 56320) + 65536;
            return (long)val | 0x400000000L;
        }
    }

    class UTF16BEReader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            int val = 0;
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            int temp = (VTDGen.this.XMLDoc[VTDGen.this.offset] & 0xFF) << 8 | VTDGen.this.XMLDoc[VTDGen.this.offset + 1] & 0xFF;
            if (temp < 55296 || temp > 57343) {
                VTDGen.this.offset += 2;
                return temp;
            }
            if (temp < 55296 || temp > 56319) {
                throw new EncodingException("UTF 16 BE encoding error: should never happen");
            }
            val = temp;
            temp = (VTDGen.this.XMLDoc[VTDGen.this.offset + 2] & 0xFF) << 8 | VTDGen.this.XMLDoc[VTDGen.this.offset + 3] & 0xFF;
            if (temp < 56320 || temp > 57343) {
                throw new EncodingException("UTF 16 BE encoding error: should never happen");
            }
            val = (val - 55296 << 10) + (temp - 56320) + 65536;
            VTDGen.this.offset += 4;
            return val;
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            int temp = (VTDGen.this.XMLDoc[VTDGen.this.offset] & 0xFF) << 8 | VTDGen.this.XMLDoc[VTDGen.this.offset + 1] & 0xFF;
            if (temp < 55296 || temp > 57343) {
                if (temp == ch) {
                    VTDGen.this.offset += 2;
                    return true;
                }
                return false;
            }
            if (temp < 55296 || temp > 56319) {
                throw new EncodingException("UTF 16 BE encoding error: should never happen");
            }
            int val = temp;
            temp = (VTDGen.this.XMLDoc[VTDGen.this.offset + 2] & 0xFF) << 8 | VTDGen.this.XMLDoc[VTDGen.this.offset + 3] & 0xFF;
            if (temp < 56320 || temp > 57343) {
                throw new EncodingException("UTF 16 BE encoding error: should never happen");
            }
            if ((val = (val - 55296 << 10) + (temp - 56320) + 65536) == ch) {
                VTDGen.this.offset += 4;
                return true;
            }
            return false;
        }

        @Override
        public final char decode(int offset) {
            return '\u0000';
        }

        @Override
        public final long _getChar(int offset) {
            int temp = (VTDGen.this.XMLDoc[offset] & 0xFF) << 8 | VTDGen.this.XMLDoc[offset + 1] & 0xFF;
            if (temp < 55296 || temp > 57343) {
                if (temp == 13) {
                    if (VTDGen.this.XMLDoc[offset + 3] == 10 && VTDGen.this.XMLDoc[offset + 2] == 0) {
                        return 0x40000000AL;
                    }
                    return 0x20000000AL;
                }
                return (long)temp | 0x200000000L;
            }
            long val = temp;
            temp = (VTDGen.this.XMLDoc[offset + 2] & 0xFF) << 8 | VTDGen.this.XMLDoc[offset + 3] & 0xFF;
            val = (long)(temp - 55296 << 10) + (val - 56320L) + 65536L;
            return val | 0x400000000L;
        }
    }

    class ISO8859_15Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_15.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_15.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_15.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_15.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_14Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_14.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_14.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_14.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_14.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_13Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_13.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_13.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_13.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_13.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_11Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_11.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_11.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_11.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_11.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_9Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_9.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_9.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_9.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_9.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_8Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_8.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_8.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_8.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_8.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_7Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_7.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_7.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_7.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_7.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_6Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_6.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_6.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_6.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_6.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_5Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_5.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_5.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_5.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_5.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_4Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_4.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_4.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_4.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_4.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_3Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_3.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_3.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_3.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_3.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_2Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_2.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_2.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_2.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_2.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ISO8859_1Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return VTDGen.this.XMLDoc[VTDGen.this.offset++] & 0xFF;
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == VTDGen.this.XMLDoc[VTDGen.this.offset]) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            int c = 0xFF & VTDGen.this.XMLDoc[offset];
            if (c == 13 && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return (char)(VTDGen.this.XMLDoc[offset] & 0xFF);
        }
    }

    class ISO8859_10Reader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            return ISO8859_10.decode(VTDGen.this.XMLDoc[VTDGen.this.offset++]);
        }

        @Override
        public final boolean skipChar(int ch) throws EOFException, ParseException, EncodingException {
            if (ch == ISO8859_10.decode(VTDGen.this.XMLDoc[VTDGen.this.offset])) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            char c = ISO8859_10.decode(VTDGen.this.XMLDoc[offset]);
            if (c == '\r' && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return ISO8859_10.decode(VTDGen.this.XMLDoc[offset]);
        }
    }

    class ASCIIReader
    implements IReader {
        @Override
        public final int getChar() throws EOFException, ParseException, EncodingException {
            byte a;
            if (VTDGen.this.offset >= VTDGen.this.endOffset) {
                throw VTDGen.this.e;
            }
            if ((a = VTDGen.this.XMLDoc[VTDGen.this.offset++]) < 0) {
                throw new ParseException("ASCII encoding error: invalid ASCII Char");
            }
            return a;
        }

        @Override
        public final boolean skipChar(int ch) throws ParseException, EOFException, EncodingException {
            if (ch == VTDGen.this.XMLDoc[VTDGen.this.offset]) {
                ++VTDGen.this.offset;
                return true;
            }
            return false;
        }

        @Override
        public final long _getChar(int offset) {
            byte c = VTDGen.this.XMLDoc[offset];
            if (c == 13 && VTDGen.this.XMLDoc[offset + 1] == 10) {
                return 0x20000000AL;
            }
            return 0x100000000L | (long)c;
        }

        @Override
        public final char decode(int offset) {
            return (char)VTDGen.this.XMLDoc[offset];
        }
    }
}

