/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class LiteralExpr
extends Expr {
    public String s;

    public LiteralExpr(String st) {
        this.s = st;
    }

    @Override
    public String toString() {
        boolean b = true;
        for (int i = 0; i < this.s.length(); ++i) {
            if (this.s.charAt(i) != '\'') continue;
            b = false;
            break;
        }
        if (b) {
            return "\"" + this.s + "\"";
        }
        return "'" + this.s + "'";
    }

    @Override
    public boolean evalBoolean(VTDNavHuge vn) {
        return this.s.length() != 0;
    }

    @Override
    public double evalNumber(VTDNavHuge vn) {
        try {
            double dval = Double.parseDouble(this.s);
            return dval;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @Override
    public int evalNodeSet(VTDNavHuge vn) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("LiteralExpr can't eval to a node set!");
    }

    @Override
    public String evalString(VTDNavHuge vn) {
        return this.s;
    }

    @Override
    public void reset(VTDNavHuge vn) {
    }

    @Override
    public boolean isNodeSet() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean requireContextSize() {
        return false;
    }

    @Override
    public void setContextSize(int size) {
    }

    @Override
    public void setPosition(int pos) {
    }

    @Override
    public int adjust(int n) {
        return 0;
    }
}

