/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.parser.FunctionParser;
import org.verapdf.parser.postscript.PSOperator;
import org.verapdf.parser.postscript.PSProcedure;
import org.verapdf.parser.postscript.PostScriptException;
import org.verapdf.pd.function.PDFunction;

public class PDType4Function
extends PDFunction {
    private List<COSObject> operators;
    private List<COSObject> modifiedOperators;
    private static final Logger LOGGER = Logger.getLogger(PDType4Function.class.getCanonicalName());
    private FunctionParser parser;

    protected PDType4Function(COSObject obj) {
        super(obj);
    }

    public List<COSObject> getOperators() {
        if (this.operators == null) {
            this.operators = this.parseOperators();
        }
        return this.operators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseStream() throws IOException {
        try (ASInputStream functionStream = this.getObject().getData(COSStream.FilterFlags.DECODE);){
            this.parser = new FunctionParser(functionStream, this.getObject().getKey());
            this.parser.parse();
        }
        finally {
            if (this.parser != null) {
                this.parser.closeInputStream();
            }
        }
    }

    public List<COSObject> parseOperators() {
        COSObject obj = this.getObject();
        if (obj.getType() != COSObjType.COS_STREAM) {
            return Collections.emptyList();
        }
        if (this.parser == null) {
            try {
                this.parseStream();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Can not parse function", e);
                return Collections.emptyList();
            }
        }
        return Collections.unmodifiableList(this.parser.getOperators());
    }

    public void setOperators(List<COSObject> operators) {
        this.operators = operators;
        this.modifiedOperators = null;
    }

    private List<COSObject> getOperatorsWithProcedures() {
        if (this.modifiedOperators == null) {
            this.modifiedOperators = new ArrayList<COSObject>();
            Iterator<COSObject> ops = this.getOperators().iterator();
            if ("{".equals(this.getOperators().get(0).getString())) {
                ops.next();
            }
            while (ops.hasNext()) {
                COSObject obj = ops.next();
                if (obj == null) continue;
                if (obj instanceof PSOperator && "{".equals(((PSOperator)obj).getOperator())) {
                    this.recursiveProcedure(ops, this.modifiedOperators);
                    continue;
                }
                this.modifiedOperators.add(obj);
            }
        }
        return this.modifiedOperators;
    }

    private void recursiveProcedure(Iterator<COSObject> ops, List<COSObject> modifiedOperators) {
        COSObject obj;
        ArrayList<COSObject> proc = new ArrayList<COSObject>();
        while (!(!ops.hasNext() || (obj = ops.next()) instanceof PSOperator && "}".equals(((PSOperator)obj).getOperator()))) {
            if (obj instanceof PSOperator && "{".equals(((PSOperator)obj).getOperator())) {
                this.recursiveProcedure(ops, proc);
            }
            proc.add(obj);
        }
        modifiedOperators.add(new PSProcedure(new COSArray(proc)));
    }

    @Override
    public List<COSObject> getResult(List<COSObject> operands) {
        try {
            Stack<COSObject> operandStack = new Stack<COSObject>();
            operandStack.addAll(this.getValuesInIntervals(operands, this.getDomain()));
            for (COSObject obj : this.getOperatorsWithProcedures()) {
                if (obj == null) continue;
                if (obj instanceof PSOperator) {
                    ((PSOperator)obj).execute(operandStack, new HashMap<ASAtom, COSObject>());
                    continue;
                }
                operandStack.push(obj);
            }
            ArrayList<COSObject> operandsInRange = new ArrayList<COSObject>(operandStack);
            return Collections.unmodifiableList(this.getValuesInIntervals(operandsInRange, this.getRange()));
        }
        catch (PostScriptException e) {
            LOGGER.log(Level.WARNING, "Invalid operators stream", e);
            return null;
        }
    }
}

