/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.validation;

import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.arkistopalvelu.olddocuments.exception.ValidatorException;
import fi.kanta.arkistopalvelu.olddocuments.logging.DbLogger;
import fi.kanta.arkistopalvelu.olddocuments.logging.RunMode;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.common.components.DateHelper;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.exception.UtilException;
import fi.kanta.common.util.InternalServiceError;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Validator;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.tika.Tika;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.core.ValidationException;
import org.verapdf.gf.foundry.VeraGreenfieldFoundryProvider;
import org.verapdf.pdfa.Foundries;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.VeraPDFFoundry;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OldDocumentValidator {
    private static final String[] CHECKTABLE = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "H", "J", "K", "L", "M", "N", "P", "R", "S", "T", "U", "V", "W", "X", "Y"};
    private LogHelper logHelper;
    private ErrorWrapperLoader errorWrapper;
    Logger log4j = Logger.getLogger(OldDocumentValidator.class);
    private DateHelper dateHelper;
    private List<InternalServiceError> errorList = new ArrayList<InternalServiceError>();
    private ErrorHandler defaultXhtmlParserErrorHandler = new ErrorHandler(){

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }
    };

    public OldDocumentValidator(String logId) {
        this.logHelper = new LogHelper();
        this.errorWrapper = ErrorWrapperLoader.getInstance();
        this.dateHelper = new DateHelper();
    }

    public void checkEffectiveTime(String logId, String dateString) throws UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (dateString != null && dateString.length() > 0) {
            InternalServiceError error;
            DateHelper dh = new DateHelper();
            Date effectiveDate = dh.toDate(logId, dateString);
            Calendar cal = Calendar.getInstance();
            int offset = 5;
            try {
                offset = Integer.parseInt(PropertyHandler.getInstance().getProperty(logId, "offset"));
            }
            catch (PropertyException | NumberFormatException e) {
                error = this.errorWrapper.getError("0011");
                error.setErrorDescription("Konfigurointitiedoston offset-arvo virheellinen.");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error), e);
                this.errorList.add(error);
            }
            cal.add(13, offset);
            Date now = cal.getTime();
            if (effectiveDate.after(now)) {
                error = this.errorWrapper.getError("0032");
                error.setErrorDescription("Asiakirjan luontiaika tulevaisuudessa.");
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                this.errorList.add(error);
            }
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void checkPatientId(String logId, String patientId, boolean commonCheck) throws UtilException {
        InternalServiceError error = this.errorWrapper.getError("0002");
        if (commonCheck) {
            error.setErrorDescription("Ty\u00f6terveyshuollon rekisterin tarkenne: " + patientId);
        }
        try {
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
            }
            if (patientId != null) {
                if (patientId.length() != 11) {
                    this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                    this.errorList.add(error);
                    return;
                }
                if (!Pattern.matches("^[0-3][0-9][0-1][0-9][0-9][0-9][+-A][0-9][0-9][0-9][0-9A-Y]", patientId)) {
                    this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                    this.errorList.add(error);
                }
                int number = 0;
                try {
                    number = Integer.parseInt(patientId.substring(0, 6) + patientId.substring(7, 10));
                }
                catch (NumberFormatException ex) {
                    this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                    this.errorList.add(error);
                }
                int leftOver = number % 31;
                String check = CHECKTABLE[leftOver];
                if (!check.equalsIgnoreCase(patientId.substring(10, 11))) {
                    this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                    this.errorList.add(error);
                }
            } else {
                this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
                this.errorList.add(error);
            }
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
        }
        catch (NumberFormatException e) {
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
            this.errorList.add(error);
        }
    }

    public String parseYTunnusString(String logId, String root, String extension) {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        StringBuffer valueBuff = new StringBuffer();
        if (extension != null && extension.length() > 0) {
            if (root != null && root.length() > 0) {
                if (extension.startsWith("0")) {
                    extension = extension.substring(1);
                }
                if (extension.contains("-")) {
                    extension = extension.replaceAll("-", "");
                }
                valueBuff.append(root).append(".").append(extension);
            }
        } else {
            valueBuff.append(root);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return valueBuff.toString();
    }

    public String parseHetuString(String logId, String root, String extension) throws UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        this.checkPatientId(logId, extension, true);
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return new StringBuffer().append(root).append(".").append(extension).toString();
    }

    public boolean checkNameAndBirthTime(String logId, String givenName, String familyName, String birthTime) throws UtilException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = null;
        if (givenName == null || givenName.trim().length() == 0 || familyName == null || familyName.trim().length() == 0) {
            error = this.errorWrapper.getError("0007");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (birthTime == null || birthTime.length() != 8) {
            error = this.errorWrapper.getError("0008");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        } else {
            this.dateHelper.parseDate(logId, birthTime, "yyyyMMdd");
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
        return this.errorList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String probeForFileType(String logId, String b64Text, File hoitoasiakirja) {
        String fileType = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            byte[] decodedBytes = Base64.decodeBase64((byte[])b64Text.getBytes(StandardCharsets.UTF_8));
            is = new ByteArrayInputStream(decodedBytes);
            File file = File.createTempFile("temp-file-name", ".tmp");
            os = new FileOutputStream(file);
            Tika tika = new Tika();
            fileType = tika.detect(decodedBytes);
            this.log4j.debug((Object)("fileType:" + fileType));
            boolean success = file.delete();
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)("tmp file delete success: " + success));
            }
        }
        catch (IOException e) {
            this.log4j.error((Object)"IO-virhe", (Throwable)e);
            InternalServiceError error = this.errorWrapper.getError("0031");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
            DbLogger logger = new DbLogger();
            logger.kirjaaVirhe(logId, "0031", error.getErrorMessage(), hoitoasiakirja);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
        return fileType;
    }

    public void validateTextPlainBase64(String logId, String b64PlainText, File hoitoasiakirja) throws ValidatorException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        String fileType = this.probeForFileType(logId, b64PlainText, hoitoasiakirja);
        if (!ProbedFileType.TEXT_PLAIN.getFileType().equalsIgnoreCase(fileType)) {
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)this.logHelper.formatMsg("mime-type: " + fileType));
            }
            this.handleValidatorTextPlainException(logId, hoitoasiakirja, null, "vaan '" + fileType + "'");
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void validatePatientIdAndBirthDate(String logId, String patientid, String birthtime) throws UtilException {
        Calendar cal;
        Date now;
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        InternalServiceError error = null;
        Date birthDate = this.dateHelper.parseDate(logId, birthtime, "yyyyMMdd");
        if (birthDate.after(now = (cal = Calendar.getInstance()).getTime())) {
            error = this.errorWrapper.getError("0008");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        String centuryIndicator = patientid.substring(6, 7);
        StringBuilder birthTimefromPatientID = new StringBuilder();
        if ("-".equals(centuryIndicator)) {
            birthTimefromPatientID.append("19");
        } else if ("A".equals(centuryIndicator)) {
            birthTimefromPatientID.append("20");
        } else if ("+".equals(centuryIndicator)) {
            birthTimefromPatientID.append("18");
        }
        birthTimefromPatientID.append(patientid.substring(4, 6));
        birthTimefromPatientID.append(patientid.substring(2, 4));
        birthTimefromPatientID.append(patientid.substring(0, 2));
        if (!birthTimefromPatientID.toString().equals(birthtime)) {
            error = this.errorWrapper.getError("0028");
            this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
            this.errorList.add(error);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    public void validatePdfA(String logId, String b64Pdf, boolean validatePdf, File hoitoasiakirja) throws ValidatorException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        if (b64Pdf == null) {
            if (this.log4j.isDebugEnabled()) {
                this.log4j.debug((Object)("b64Pdf == null logId:" + logId));
                this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
            }
            return;
        }
        VeraPDFFoundry foundry = Foundries.defaultInstance();
        try (ByteArrayInputStream is = new ByteArrayInputStream(Base64.decodeBase64((byte[])b64Pdf.getBytes()));
             PDFAParser pdfAparser = foundry.createParser((InputStream)is, PDFAFlavour.PDFA_1_B);
             PDFAValidator validator = foundry.createValidator(PDFAFlavour.PDFA_1_B, false);){
            if (validatePdf) {
                ValidationResult result = validator.validate(pdfAparser);
                if (!result.isCompliant()) {
                    StringBuilder errors = new StringBuilder();
                    for (TestAssertion testAssertion : result.getTestAssertions()) {
                        errors.append(testAssertion.toString());
                    }
                    this.log4j.error((Object)(logId + ", PDF-validointivirhe: " + String.valueOf(errors)));
                    this.validatePdfAErrorHandling(logId, "Virheellinen pdf-asiakirja, ei ole PDF/A-1b", hoitoasiakirja, null);
                } else {
                    this.log4j.debug((Object)(logId + " is PDFA_1_B compliant"));
                }
            }
        }
        catch (EncryptedPdfException | ModelParsingException | ValidationException createParserException) {
            this.validatePdfAErrorHandling(logId, "Virheellinen pdf-asiakirja, syntaksivirhe.", hoitoasiakirja, (Exception)createParserException);
        }
        catch (IOException e) {
            this.log4j.error((Object)"virhe input-streamin sulkemisessa", (Throwable)e);
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgEnd(logId));
        }
    }

    private void validatePdfAErrorHandling(String logId, String msg, File hoitoasiakirja, Exception exception) throws ValidatorException {
        if (exception != null) {
            this.log4j.error((Object)this.logHelper.formatMsg(logId, exception.toString()));
        }
        InternalServiceError error = this.errorWrapper.getError("0003");
        error.setErrorDescription(msg);
        this.log4j.error((Object)this.logHelper.formatMsg(logId, error));
        this.errorList.add(error);
        DbLogger logger = new DbLogger();
        logger.kirjaaVirhe(logId, "0003", msg, hoitoasiakirja);
        RunMode executionMode = new RunMode();
        if (executionMode.getMode().equals("ARKISTOINTI")) {
            this.log4j.error((Object)"throw pdf exception");
            throw new ValidatorException(error);
        }
    }

    public List<InternalServiceError> getErrorList() {
        return this.errorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadXMLFromString(String logId, String xmlAsText, File hoitoasiakirja) throws ValidatorException {
        DocumentBuilder builder = null;
        Document xmlDocument = null;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(xmlAsText.getBytes());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(this.defaultXhtmlParserErrorHandler);
            xmlDocument = builder.parse(is);
        }
        catch (SAXException e) {
            this.handleValidatorXhtmlException(logId, hoitoasiakirja, e, "xhtml tiedoston muodostaminen ei onnistu");
        }
        catch (ParserConfigurationException e) {
            this.handleValidatorXhtmlException(logId, hoitoasiakirja, e, "xml parser poikkeus");
        }
        catch (IOException e) {
            this.handleValidatorXhtmlException(logId, hoitoasiakirja, e, "io-virhe");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return xmlDocument;
    }

    private void handleValidatorException(String logId, File hoitoasiakirja, Exception e, String errorDescription, String code, String logMsg) throws ValidatorException {
        InternalServiceError error = this.errorWrapper.getError(code);
        error.setErrorDescription(errorDescription);
        this.log4j.error((Object)this.logHelper.formatMsg(logId, error), (Throwable)e);
        this.errorList.add(error);
        DbLogger logger = new DbLogger();
        logger.kirjaaVirhe(logId, code, errorDescription, hoitoasiakirja);
        RunMode executionMode = new RunMode();
        if (executionMode.getMode().equals("ARKISTOINTI")) {
            this.log4j.error((Object)logMsg);
            throw new ValidatorException(error);
        }
    }

    private void handleValidatorPdfException(String logId, File hoitoasiakirja, Exception e, String errorDescription) throws ValidatorException {
        this.handleValidatorException(logId, hoitoasiakirja, e, "Virheellinen pdf-asiakirja, " + errorDescription, "0003", "throw pdf exception");
    }

    private void handleValidatorTextPlainException(String logId, File hoitoasiakirja, Exception e, String errorDescription) throws ValidatorException {
        this.handleValidatorException(logId, hoitoasiakirja, e, "Ei ole text plain " + errorDescription, "0031", "throw text plain exception");
    }

    private void handleValidatorXhtmlException(String logId, File hoitoasiakirja, Exception e, String errorDescription) throws ValidatorException {
        this.handleValidatorException(logId, hoitoasiakirja, e, "Virheellinen xhtml-asiakirja  " + errorDescription, "0030", "throw xhtml exception");
    }

    public void validateXhtml(String logId, String b64Xhtml, File hoitoasiakirja) throws ValidatorException {
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
        try {
            byte[] decodedBytes = Base64.decodeBase64((byte[])b64Xhtml.getBytes("UTF-8"));
            Document xmlDocument = this.loadXMLFromString(logId, new String(decodedBytes), hoitoasiakirja);
            Validator schemaValidator = PropertyHandler.getInstance().getXHTMLSchema().newValidator();
            schemaValidator.validate(new DOMSource(xmlDocument));
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            this.handleValidatorXhtmlException(logId, hoitoasiakirja, e, "ei b64");
        }
        catch (SAXException e) {
            this.handleValidatorXhtmlException(logId, hoitoasiakirja, e, "xhtml tiedoston muodostaminen ei onnistu");
        }
        catch (IOException e) {
            this.handleValidatorXhtmlException(logId, hoitoasiakirja, e, "io-virhe");
        }
        if (this.log4j.isDebugEnabled()) {
            this.log4j.debug((Object)this.logHelper.formatMsgBgn(logId));
        }
    }

    static {
        VeraGreenfieldFoundryProvider.initialise();
    }

    public static enum ProbedFileType {
        TEXT_PLAIN("text/plain"),
        TEXT_HTML("text/html"),
        APP_XML("application/xml"),
        APP_PDF("application/pdf"),
        APP_OCTET_STREAM("application/octet-stream");

        private String fileType;

        private ProbedFileType(String fileType) {
            this.fileType = fileType;
        }

        public String getFileType() {
            return this.fileType;
        }
    }
}

