/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class UnaryExpr
extends Expr {
    public int op;
    public Expr operand;

    public UnaryExpr(int o, Expr e) {
        this.op = o;
        this.operand = e;
    }

    @Override
    public String toString() {
        return "-" + this.operand;
    }

    @Override
    public boolean evalBoolean(VTDNavHuge vn) {
        return this.operand.evalBoolean(vn);
    }

    @Override
    public double evalNumber(VTDNavHuge vn) {
        return -1.0 * this.operand.evalNumber(vn);
    }

    @Override
    public int evalNodeSet(VTDNavHuge vn) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("UnaryExpr can't eval to a node set!");
    }

    @Override
    public String evalString(VTDNavHuge vn) {
        double dval = this.operand.evalNumber(vn);
        if (dval == (double)((int)dval)) {
            return "" + (int)dval;
        }
        return "" + dval;
    }

    @Override
    public void reset(VTDNavHuge vn) {
        this.operand.reset(vn);
    }

    @Override
    public boolean isNodeSet() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean requireContextSize() {
        return this.operand.requireContextSize();
    }

    @Override
    public void setContextSize(int size) {
        this.operand.setContextSize(size);
    }

    @Override
    public void setPosition(int pos) {
        this.operand.setPosition(pos);
    }

    @Override
    public int adjust(int n) {
        return 0;
    }
}

