/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.exception;

import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorMessages;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.util.InternalServiceError;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ErrorWrapperLoader {
    private static ErrorWrapperLoader me = null;
    private Map<String, InternalServiceError> internalErrors = null;
    Logger log = Logger.getLogger(ErrorWrapperLoader.class);
    private LogHelper logHelper = new LogHelper();

    public static final ErrorWrapperLoader getInstance() {
        return me;
    }

    private ErrorWrapperLoader() {
        this.init();
    }

    private void init() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsgBgn(""));
        }
        this.internalErrors = new HashMap<String, InternalServiceError>(ErrorMessages.LoaderErrors.values().length);
        for (ErrorMessages.LoaderErrors errorCode : ErrorMessages.LoaderErrors.values()) {
            InternalServiceError error = new InternalServiceError();
            error.setErrorCode(errorCode.getErrorCode());
            error.setErrorMessage(errorCode.getInternalMessage());
            error.setErrorLevel(errorCode.getErrorLevel());
            this.internalErrors.put(error.getErrorCode(), error);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.logHelper.formatMsgEnd(""));
        }
    }

    public InternalServiceError getError(String errorCode) {
        InternalServiceError error = this.internalErrors.get(errorCode);
        InternalServiceError retError = new InternalServiceError();
        if (error == null) {
            retError.setErrorCode("2T02001");
            retError.setErrorMessage("Sis\u00e4inen tekninen virhe.");
            retError.setErrorLevel("1");
            retError.setErrorDescription(new StringBuffer("Koodia '").append(errorCode).append("' ei l\u00f6ytynyt!"));
        } else {
            retError.setErrorCode(error.getErrorCode());
            retError.setErrorMessage(error.getErrorMessage());
            retError.setErrorLevel(error.getErrorLevel());
            retError.setErrorDescription(error.getErrorDescription());
            retError.setErrorCause(error.getErrorCause());
            retError.setCommonError(error.isCommonError());
        }
        return retError;
    }

    static {
        me = new ErrorWrapperLoader();
    }
}

