/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.filesystem;

import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.exception.ErrorWrapperLoader;
import fi.kanta.common.components.LogHelper;
import fi.kanta.common.util.InternalServiceError;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FileReader {
    public static final String UTF8_BOM = "\ufeff";
    private static final Logger LOGGER = Logger.getLogger(FileReader.class);
    private String logId;
    private LogHelper logHelper;
    private ErrorWrapperLoader errorWrapper;

    public FileReader(String logId) {
        this.logId = logId;
        this.logHelper = new LogHelper();
        this.errorWrapper = ErrorWrapperLoader.getInstance();
    }

    public Document readXMLDoc(File file) throws ParserConfigurationException, SAXException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgEnd(this.logId));
        }
        return document;
    }

    public Document readXMLDoc(File file, boolean namespaceaware) throws ConfigException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(namespaceaware);
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(this.logId));
            }
        }
        catch (IOException | ParserConfigurationException e) {
            InternalServiceError error = this.errorWrapper.getError("0017");
            error.setErrorMessage(error.getErrorMessage() + ": " + e.getMessage());
            LOGGER.error((Object)this.logHelper.formatMsg(this.logId, error), (Throwable)e);
            throw new ConfigException(error);
        }
        catch (SAXException e) {
            InternalServiceError error = this.errorWrapper.getError("0017");
            error.setErrorMessage(error.getErrorMessage() + ". XML ei hyvin muodostettu: " + e.getMessage());
            LOGGER.error((Object)this.logHelper.formatMsg(this.logId, error), (Throwable)e);
            throw new ConfigException(error);
        }
        return document;
    }

    public String getContent(File file) throws IOException {
        return this.removeUTF8BOM(new String(this.readFully(new FileInputStream(file)), "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFully(InputStream inputStream) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.logHelper.formatMsgBgn(this.logId));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            baos.close();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logHelper.formatMsgEnd(this.logId));
            }
        }
    }

    private String removeUTF8BOM(String s) {
        return s.startsWith(UTF8_BOM) ? s.substring(1) : s;
    }
}

