/*
 * Decompiled with CFR 0.152.
 */
package fi.kanta.arkistopalvelu.olddocuments.tasks;

import fi.kanta.arkistopalvelu.olddocuments.Scheduler;
import fi.kanta.arkistopalvelu.olddocuments.exception.ConfigException;
import fi.kanta.arkistopalvelu.olddocuments.logging.DbLogger;
import fi.kanta.arkistopalvelu.olddocuments.logging.IProcessLogger;
import fi.kanta.arkistopalvelu.olddocuments.logging.ProcessLoggerSynchronized;
import fi.kanta.arkistopalvelu.olddocuments.manifest.Manifest;
import fi.kanta.arkistopalvelu.olddocuments.messaging.RequestPermissionChecker;
import fi.kanta.arkistopalvelu.olddocuments.metadata.ExecutionMode;
import fi.kanta.arkistopalvelu.olddocuments.metadata.Hoitoasiakirja;
import fi.kanta.arkistopalvelu.olddocuments.metadata.Palvelutapahtuma;
import fi.kanta.arkistopalvelu.olddocuments.tasks.DirectoryData;
import fi.kanta.arkistopalvelu.olddocuments.tasks.HoitoasiakirjaTaskResult;
import fi.kanta.arkistopalvelu.olddocuments.tasks.PalvelutapahtumaData;
import fi.kanta.arkistopalvelu.olddocuments.tasks.PalvelutapahtumaTask;
import fi.kanta.arkistopalvelu.olddocuments.tasks.TaskResult;
import fi.kanta.arkistopalvelu.olddocuments.utils.PropertyHandler;
import fi.kanta.arkistopalvelu.webservices.olddocumentwithcontent.request.AsiakirjaPTReq;
import fi.kanta.common.exception.PropertyException;
import fi.kanta.common.exception.UtilException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class DirectoryTask
implements Callable<TaskResult> {
    private static Logger log4j = Logger.getLogger(DirectoryTask.class);
    private static Logger ERROR_LOGGER = Logger.getLogger((String)"errorlog");
    private DirectoryData dirData;
    private ExecutorService palvelutapahtumaPool;
    private ExecutorService hoitoasiakirjaPool;
    private ExecutionMode mode;
    private boolean hakemistoarkistoitu = true;

    public DirectoryTask(DirectoryData dirData, ExecutorService executorService, ExecutorService hoitoasiakirjaPool, ExecutionMode mode) {
        this.dirData = dirData;
        this.palvelutapahtumaPool = executorService;
        this.hoitoasiakirjaPool = hoitoasiakirjaPool;
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() throws Exception {
        log4j.debug((Object)("call START with directory: " + this.dirData.getDirectory()));
        TaskResult taskResult = new TaskResult();
        taskResult.setSuccess(true);
        DbLogger dblogger = new DbLogger();
        String dirPath = this.dirData.getDirectory();
        String dirLogId = PropertyHandler.getInstance().getProperty("NULL", "logId");
        ProcessLoggerSynchronized logger = new ProcessLoggerSynchronized(dirLogId);
        try {
            Manifest manifest = new Manifest(dirPath, this.dirData.getManifestFile());
            DirectoryTask.startDirLogging(manifest, logger, this.dirData.getLogPath(), this.dirData.getDataPath());
            if (!DirectoryTask.checkPermission(this.dirData.getPalvelunantaja(), manifest, logger, dirLogId)) {
                taskResult.setSuccess(false);
                TaskResult taskResult2 = taskResult;
                return taskResult2;
            }
            ExecutorCompletionService<TaskResult> pool = new ExecutorCompletionService<TaskResult>(this.palvelutapahtumaPool);
            ArrayList<Future<TaskResult>> ptFutures = new ArrayList<Future<TaskResult>>();
            for (Palvelutapahtuma pt : manifest.haePalvelutapahtumat()) {
                PalvelutapahtumaData ptData = new PalvelutapahtumaData(pt, dirPath, this.dirData.getLap(), this.dirData.getThreadTimeout(), this.dirData.getRekisterinpitaja(), this.dirData.isTestMode(), this.dirData.isBruteForceMode());
                if (dblogger.onkoPalvelutapahtumaArkistoitu(pt.getOid()) && dblogger.onkoHoitoasiakirjaArkistoitu(pt.getOid())) {
                    log4j.info((Object)("Palvelutapahtuma " + pt.getOid() + " oli jo arkistoitu."));
                    continue;
                }
                PalvelutapahtumaTask task = new PalvelutapahtumaTask(ptData, logger, this.hoitoasiakirjaPool, this.mode);
                ptFutures.add(pool.submit(task));
            }
            for (int i = 0; i < ptFutures.size(); ++i) {
                TaskResult result = (TaskResult)pool.take().get();
                AsiakirjaPTReq asiakirjaPTReq = result.getAsiakirjaPTReq();
                if (asiakirjaPTReq != null) {
                    logger.openPalveluTapahtuma(asiakirjaPTReq);
                    for (HoitoasiakirjaTaskResult haResult : result.getChildTasks()) {
                        Hoitoasiakirja hoitoasiakirja = haResult.getHoitoasiakirja();
                        logger.openAsiakirja(hoitoasiakirja.getOid());
                        logger.closeAsiakirja(hoitoasiakirja.getOid(), haResult.getResultStatus(), haResult.getResultDescription(), haResult.getSuccess());
                        if (haResult.getSuccess()) {
                            logger.writeCompareLog(hoitoasiakirja.getOid());
                            continue;
                        }
                        taskResult.setSuccess(false);
                        this.hakemistoarkistoitu = false;
                    }
                }
                if (!result.getSuccess()) {
                    taskResult.setSuccess(false);
                    this.hakemistoarkistoitu = false;
                }
                logger.closePalveluTapahtuma(result.getPalvelutapahtuma().getOid(), result.getResultStatus(), result.getResultDescription(), result.getSuccess());
            }
        }
        catch (PropertyException | UtilException e) {
            log4j.error((Object)("Failed pe ue: " + String.valueOf(e)), e);
            taskResult.setSuccess(false);
            this.hakemistoarkistoitu = false;
            dblogger.asetaHakemistoVirheelliseksi(dirPath);
        }
        catch (Exception ex) {
            log4j.error((Object)("Failed: " + String.valueOf(ex)), (Throwable)ex);
            taskResult.setSuccess(false);
            this.hakemistoarkistoitu = false;
            dblogger.asetaHakemistoVirheelliseksi(dirPath);
        }
        finally {
            DirectoryTask.endDirLogging(logger);
        }
        if (this.hakemistoarkistoitu && taskResult.getSuccess()) {
            log4j.debug((Object)("asetetaan hakemisto suoritetuksi: " + dirPath));
            dblogger.asetaHakemistoSuoritetuksi(dirPath);
            dblogger.poistaHakemistoVirhe(dirPath);
        }
        System.out.print(".");
        return taskResult;
    }

    private static void startDirLogging(Manifest manifest, IProcessLogger logger, String logPath, String dataPath) throws IOException, ConfigException {
        String dirLogFile = DirectoryTask.getLogFileName(manifest.getDirectory(), dataPath);
        String relativeDataDir = manifest.getDirectory().substring(dataPath.length());
        logger.startLog(logPath, dirLogFile);
        logger.startCompareLog(dirLogFile);
        logger.log("Hakemisto: " + manifest.getDirectory() + " tiedostolistaus hakemistossa: " + manifest.getFilename());
        logger.writeCompareLog(relativeDataDir);
    }

    private static void endDirLogging(IProcessLogger logger) throws IOException {
        logger.closeLog();
        logger.closeCompareLog();
    }

    private static String getLogFileName(String directory, String root) {
        Object logName = directory.replaceFirst(root, "");
        logName = ((String)logName).replaceAll("\\s", "_");
        logName = ((String)logName).replaceAll("/", "_");
        logName = (String)logName + "_" + System.currentTimeMillis();
        if (((String)(logName = (String)logName + ".log")).startsWith("_")) {
            logName = ((String)logName).substring(1);
        }
        if (((String)logName).length() > 255) {
            logName = ((String)logName).substring(((String)logName).length() - 255);
        }
        Logger.getLogger(Scheduler.class).info((Object)("Lokitiedoston nimi: " + (String)logName));
        return logName;
    }

    private static boolean checkPermission(String palvelunantajaConfig, Manifest manifest, IProcessLogger logger, String dirLogId) throws IOException, InterruptedException, UtilException {
        RequestPermissionChecker permissionChecker;
        log4j.info((Object)"START CheckPermission");
        boolean hasPermission = true;
        DbLogger dblogger = new DbLogger();
        String palvelunantaja = manifest.getPalvelunantaja();
        log4j.info((Object)("palvelunantaja: " + palvelunantaja));
        log4j.info((Object)("palvelunantajaConfig: " + palvelunantajaConfig));
        if (!palvelunantajaConfig.equals(palvelunantaja)) {
            hasPermission = false;
            ERROR_LOGGER.error((Object)(manifest.getDirectory() + "/" + manifest.getFilename() + "\n   + Hakemiston suoritusvirhe: Palvelunantajatiedot eiv\u00e4t vastaa konfiguraatiota " + palvelunantaja + "\n"));
            dblogger.asetaHakemistoVirheelliseksi(manifest.getDirectory());
        }
        if (hasPermission && !(permissionChecker = new RequestPermissionChecker(dirLogId, logger)).checkRequestPermission(manifest)) {
            hasPermission = false;
            logger.error("Ei lupaa palvelupyynt\u00f6\u00f6n: " + manifest.getDirectory());
            ERROR_LOGGER.error((Object)(manifest.getDirectory() + "\n   + Palvelunantajalla ei lupaa palvelupyynt\u00f6\u00f6n " + palvelunantaja + "\n"));
            dblogger.asetaHakemistoVirheelliseksi(manifest.getDirectory());
        }
        log4j.info((Object)"END CheckPermission");
        return hasPermission;
    }
}

