/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.testRedundancy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.Configuration;

public final class TestCoverage {
    @Nullable
    public static final TestCoverage INSTANCE = "true".equals(Configuration.getProperty("redundancy")) ? new TestCoverage() : null;
    @Nonnull
    private final Map<Method, Integer> testsToItemsCovered = new LinkedHashMap<Method, Integer>();
    @Nullable
    private Method currentTestMethod;

    private TestCoverage() {
    }

    public void setCurrentTestMethod(@Nullable Method testMethod) {
        if (testMethod != null) {
            this.testsToItemsCovered.put(testMethod, 0);
        }
        this.currentTestMethod = testMethod;
    }

    public void recordNewItemCoveredByTestIfApplicable(@Nonnegative int previousExecutionCount) {
        if (previousExecutionCount == 0 && this.currentTestMethod != null) {
            Integer itemsCoveredByTest = this.testsToItemsCovered.get(this.currentTestMethod);
            this.testsToItemsCovered.put(this.currentTestMethod, itemsCoveredByTest == null ? 1 : itemsCoveredByTest + 1);
        }
    }

    @Nonnull
    public List<Method> getRedundantTests() {
        ArrayList<Method> redundantTests = new ArrayList<Method>();
        for (Map.Entry<Method, Integer> testAndItemsCovered : this.testsToItemsCovered.entrySet()) {
            Method testMethod = testAndItemsCovered.getKey();
            Integer itemsCovered = testAndItemsCovered.getValue();
            if (itemsCovered != 0) continue;
            redundantTests.add(testMethod);
        }
        return redundantTests;
    }
}

